package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Error}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableError.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableError.of()}.
 */
@Generated(from = "Error", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableError implements Error {
  private final String id;
  private final @Nullable String code;
  private final @Nullable String description;

  private ImmutableError(
      String id,
      @Nullable String code,
      @Nullable String description) {
    this.id = Objects.requireNonNull(id, "id");
    this.code = code;
    this.description = description;
  }

  private ImmutableError(
      ImmutableError original,
      String id,
      @Nullable String code,
      @Nullable String description) {
    this.id = id;
    this.code = code;
    this.description = description;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code code} attribute
   */
  @JsonProperty("code")
  @Override
  public @Nullable String getCode() {
    return code;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableError(this, newValue, this.code, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getCode() code} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for code (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withCode(@Nullable String value) {
    if (Objects.equals(this.code, value)) return this;
    return new ImmutableError(this, this.id, value, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Error#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableError(this, this.id, this.code, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableError
        && equalTo(0, (ImmutableError) another);
  }

  private boolean equalTo(int synthetic, ImmutableError another) {
    return id.equals(another.id)
        && Objects.equals(code, another.code)
        && Objects.equals(description, another.description);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code code}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(code);
    h += (h << 5) + Objects.hashCode(description);
    return h;
  }

  /**
   * Prints the immutable value {@code Error} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Error{"
        + "id=" + id
        + ", code=" + code
        + ", description=" + description
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Error", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Error {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable String code;
    @javax.annotation.Nullable String description;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("code")
    public void setCode(@Nullable String code) {
      this.code = code;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getCode() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableError fromJson(Json json) {
    ImmutableError.Builder builder = ImmutableError.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.code != null) {
      builder.code(json.code);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Error} instance.
   * @param id The value for the {@code id} attribute
   * @param code The value for the {@code code} attribute
   * @param description The value for the {@code description} attribute
   * @return An immutable Error instance
   */
  public static ImmutableError of(String id, @Nullable String code, @Nullable String description) {
    return new ImmutableError(id, code, description);
  }

  /**
   * Creates an immutable copy of a {@link Error} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Error instance
   */
  public static ImmutableError copyOf(Error instance) {
    if (instance instanceof ImmutableError) {
      return (ImmutableError) instance;
    }
    return ImmutableError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableError ImmutableError}.
   * <pre>
   * ImmutableError.builder()
   *    .id(String) // required {@link Error#getId() id}
   *    .code(String | null) // nullable {@link Error#getCode() code}
   *    .description(String | null) // nullable {@link Error#getDescription() description}
   *    .build();
   * </pre>
   * @return A new ImmutableError builder
   */
  public static ImmutableError.Builder builder() {
    return new ImmutableError.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableError ImmutableError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Error", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String code;
    private @javax.annotation.Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableError} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableError instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.idIsSet()) {
        id(instance.getId());
      }
      String codeValue = instance.getCode();
      if (codeValue != null) {
        code(codeValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Error} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Error instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableError) {
        return from((ModifiableError) instance);
      }
      id(instance.getId());
      String codeValue = instance.getCode();
      if (codeValue != null) {
        code(codeValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getCode() code} attribute.
     * @param code The value for code (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("code")
    public final Builder code(@Nullable String code) {
      this.code = code;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Builds a new {@link ImmutableError ImmutableError}.
     * @return An immutable instance of Error
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableError build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableError(null, id, code, description);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Error, some of required attributes are not set " + attributes;
    }
  }
}
