package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ContextValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContextValue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableContextValue.of()}.
 */
@Generated(from = "ContextValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableContextValue implements ContextValue {
  private final String id;
  private final @Nullable Object value;

  private ImmutableContextValue(String id, @Nullable Object value) {
    this.id = id;
    this.value = value;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @JsonInclude(JsonInclude.Include.ALWAYS)
  @Override
  public @Nullable Object getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContextValue#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContextValue withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableContextValue(value, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContextValue#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContextValue withValue(@Nullable Object value) {
    if (this.value == value) return this;
    return new ImmutableContextValue(this.id, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContextValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContextValue
        && equalTo(0, (ImmutableContextValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableContextValue another) {
    return Objects.equals(id, another.id)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code ContextValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ContextValue{"
        + "id=" + id
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ContextValue", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ContextValue {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable Object value;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("value")
    @JsonInclude(JsonInclude.Include.ALWAYS)
    public void setValue(@Nullable Object value) {
      this.value = value;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Object getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableContextValue fromJson(Json json) {
    ImmutableContextValue.Builder builder = ImmutableContextValue.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code ContextValue} instance.
   * @param id The value for the {@code id} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable ContextValue instance
   */
  public static ImmutableContextValue of(String id, @Nullable Object value) {
    return new ImmutableContextValue(id, value);
  }

  /**
   * Creates an immutable copy of a {@link ContextValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContextValue instance
   */
  public static ImmutableContextValue copyOf(ContextValue instance) {
    if (instance instanceof ImmutableContextValue) {
      return (ImmutableContextValue) instance;
    }
    return ImmutableContextValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContextValue ImmutableContextValue}.
   * <pre>
   * ImmutableContextValue.builder()
   *    .id(String | null) // nullable {@link ContextValue#getId() id}
   *    .value(Object | null) // nullable {@link ContextValue#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableContextValue builder
   */
  public static ImmutableContextValue.Builder builder() {
    return new ImmutableContextValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContextValue ImmutableContextValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ContextValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable Object value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableContextValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableContextValue instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContextValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ContextValue instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableContextValue) {
        return from((ModifiableContextValue) instance);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ContextValue#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link ContextValue#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    @JsonInclude(JsonInclude.Include.ALWAYS)
    public final Builder value(@Nullable Object value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContextValue ImmutableContextValue}.
     * @return An immutable instance of ContextValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContextValue build() {
      return new ImmutableContextValue(id, value);
    }
  }
}
