package io.dialob.api.proto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueSetEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueSetEntry.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableValueSetEntry.of()}.
 */
@Generated(from = "ValueSetEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableValueSetEntry implements ValueSetEntry {
  private final String key;
  private final @Nullable String value;

  private ImmutableValueSetEntry(String key, @Nullable String value) {
    this.key = Objects.requireNonNull(key, "key");
    this.value = value;
  }

  private ImmutableValueSetEntry(
      ImmutableValueSetEntry original,
      String key,
      @Nullable String value) {
    this.key = key;
    this.value = value;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("key")
  @Override
  public String getKey() {
    return key;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public @Nullable String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueSetEntry#getKey() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueSetEntry withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableValueSetEntry(this, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueSetEntry#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueSetEntry withValue(@Nullable String value) {
    if (Objects.equals(this.value, value)) return this;
    return new ImmutableValueSetEntry(this, this.key, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueSetEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueSetEntry
        && equalTo(0, (ImmutableValueSetEntry) another);
  }

  private boolean equalTo(int synthetic, ImmutableValueSetEntry another) {
    return key.equals(another.key)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code ValueSetEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueSetEntry")
        .omitNullValues()
        .add("key", key)
        .add("value", value)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ValueSetEntry", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ValueSetEntry {
    @javax.annotation.Nullable String key;
    @javax.annotation.Nullable String value;
    @JsonProperty("key")
    public void setKey(String key) {
      this.key = key;
    }
    @JsonProperty("value")
    public void setValue(@Nullable String value) {
      this.value = value;
    }
    @Override
    public String getKey() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableValueSetEntry fromJson(Json json) {
    ImmutableValueSetEntry.Builder builder = ImmutableValueSetEntry.builder();
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code ValueSetEntry} instance.
   * @param key The value for the {@code key} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable ValueSetEntry instance
   */
  public static ImmutableValueSetEntry of(String key, @Nullable String value) {
    return new ImmutableValueSetEntry(key, value);
  }

  /**
   * Creates an immutable copy of a {@link ValueSetEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueSetEntry instance
   */
  public static ImmutableValueSetEntry copyOf(ValueSetEntry instance) {
    if (instance instanceof ImmutableValueSetEntry) {
      return (ImmutableValueSetEntry) instance;
    }
    return ImmutableValueSetEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueSetEntry ImmutableValueSetEntry}.
   * <pre>
   * ImmutableValueSetEntry.builder()
   *    .key(String) // required {@link ValueSetEntry#getKey() key}
   *    .value(String | null) // nullable {@link ValueSetEntry#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableValueSetEntry builder
   */
  public static ImmutableValueSetEntry.Builder builder() {
    return new ImmutableValueSetEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueSetEntry ImmutableValueSetEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueSetEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String key;
    private @javax.annotation.Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueSetEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ValueSetEntry instance) {
      Objects.requireNonNull(instance, "instance");
      key(instance.getKey());
      String valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ValueSetEntry#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("key")
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueSetEntry#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueSetEntry ImmutableValueSetEntry}.
     * @return An immutable instance of ValueSetEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueSetEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValueSetEntry(null, key, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      return "Cannot build ValueSetEntry, some of required attributes are not set " + attributes;
    }
  }
}
