package io.dialob.api.proto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueSet}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueSet.builder()}.
 */
@Generated(from = "ValueSet", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableValueSet implements ValueSet {
  private final String id;
  private final List<ValueSetEntry> entries;

  private ImmutableValueSet(String id, List<ValueSetEntry> entries) {
    this.id = id;
    this.entries = entries;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code entries} attribute
   */
  @JsonProperty("entries")
  @Override
  public List<ValueSetEntry> getEntries() {
    return entries;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueSet#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueSet withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableValueSet(newValue, this.entries);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValueSet#getEntries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValueSet withEntries(ValueSetEntry... elements) {
    List<ValueSetEntry> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableValueSet(this.id, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValueSet#getEntries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValueSet withEntries(Iterable<? extends ValueSetEntry> elements) {
    if (this.entries == elements) return this;
    List<ValueSetEntry> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableValueSet(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueSet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueSet
        && equalTo(0, (ImmutableValueSet) another);
  }

  private boolean equalTo(int synthetic, ImmutableValueSet another) {
    return id.equals(another.id)
        && entries.equals(another.entries);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code entries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + entries.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueSet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ValueSet{"
        + "id=" + id
        + ", entries=" + entries
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ValueSet", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ValueSet {
    @Nullable String id;
    @Nullable List<ValueSetEntry> entries = Collections.emptyList();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("entries")
    public void setEntries(List<ValueSetEntry> entries) {
      this.entries = entries;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<ValueSetEntry> getEntries() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableValueSet fromJson(Json json) {
    ImmutableValueSet.Builder builder = ImmutableValueSet.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.entries != null) {
      builder.addAllEntries(json.entries);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ValueSet} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueSet instance
   */
  public static ImmutableValueSet copyOf(ValueSet instance) {
    if (instance instanceof ImmutableValueSet) {
      return (ImmutableValueSet) instance;
    }
    return ImmutableValueSet.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueSet ImmutableValueSet}.
   * <pre>
   * ImmutableValueSet.builder()
   *    .id(String) // required {@link ValueSet#getId() id}
   *    .addEntries|addAllEntries(io.dialob.api.proto.ValueSetEntry) // {@link ValueSet#getEntries() entries} elements
   *    .build();
   * </pre>
   * @return A new ImmutableValueSet builder
   */
  public static ImmutableValueSet.Builder builder() {
    return new ImmutableValueSet.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueSet ImmutableValueSet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueSet", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private List<ValueSetEntry> entries = new ArrayList<ValueSetEntry>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueSet} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ValueSet instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      addAllEntries(instance.getEntries());
      return this;
    }

    /**
     * Initializes the value for the {@link ValueSet#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link ValueSet#getEntries() entries} list.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(ValueSetEntry element) {
      element = ImmutableValueSetEntry.copyOf(element);
      this.entries.add(Objects.requireNonNull(element, "entries element"));
      return this;
    }

    /**
     * Constructs and adds an element for the {@link ValueSet#getEntries() entries} list.
     * @param key The value for {@code entries.key} 
     * @param value The value for {@code entries.value} (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(String key, @io.dialob.api.annotation.Nullable String value) {
      return addEntries(ImmutableValueSetEntry.of(key, value));
    }

    /**
     * Adds elements to {@link ValueSet#getEntries() entries} list.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEntries(ValueSetEntry... elements) {
      for (ValueSetEntry element : elements) {
        element = ImmutableValueSetEntry.copyOf(element);
        this.entries.add(Objects.requireNonNull(element, "entries element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ValueSet#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entries")
    public final Builder entries(Iterable<? extends ValueSetEntry> elements) {
      this.entries.clear();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link ValueSet#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEntries(Iterable<? extends ValueSetEntry> elements) {
      for (ValueSetEntry element : elements) {
        element = ImmutableValueSetEntry.copyOf(element);
        this.entries.add(Objects.requireNonNull(element, "entries element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueSet ImmutableValueSet}.
     * @return An immutable instance of ValueSet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueSet build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValueSet(id, createUnmodifiableList(true, entries));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build ValueSet, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
