package io.dialob.api.proto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ActionItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableActionItem.builder()}.
 */
@Generated(from = "ActionItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableActionItem implements ActionItem {
  private final String id;
  private final String type;
  private final @Nullable String view;
  private final @Nullable String label;
  private final @Nullable String description;
  private final @Nullable Boolean inactive;
  private final @Nullable Boolean disabled;
  private final @Nullable Boolean required;
  private final @Nullable List<String> className;
  private final @Nullable Object value;
  private final @Nullable List<String> items;
  private final @Nullable String activeItem;
  private final @Nullable List<String> availableItems;
  private final @Nullable Set<Action.Type> allowedActions;
  private final @Nullable Boolean answered;
  private final @Nullable String valueSetId;
  private final @Nullable Map<String, Object> props;

  private ImmutableActionItem(
      String id,
      String type,
      @Nullable String view,
      @Nullable String label,
      @Nullable String description,
      @Nullable Boolean inactive,
      @Nullable Boolean disabled,
      @Nullable Boolean required,
      @Nullable List<String> className,
      @Nullable Object value,
      @Nullable List<String> items,
      @Nullable String activeItem,
      @Nullable List<String> availableItems,
      @Nullable Set<Action.Type> allowedActions,
      @Nullable Boolean answered,
      @Nullable String valueSetId,
      @Nullable Map<String, Object> props) {
    this.id = id;
    this.type = type;
    this.view = view;
    this.label = label;
    this.description = description;
    this.inactive = inactive;
    this.disabled = disabled;
    this.required = required;
    this.className = className;
    this.value = value;
    this.items = items;
    this.activeItem = activeItem;
    this.availableItems = availableItems;
    this.allowedActions = allowedActions;
    this.answered = answered;
    this.valueSetId = valueSetId;
    this.props = props;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty("view")
  @Override
  public @Nullable String getView() {
    return view;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public @Nullable String getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code inactive} attribute
   */
  @JsonProperty("inactive")
  @Override
  public @Nullable Boolean getInactive() {
    return inactive;
  }

  /**
   * @return The value of the {@code disabled} attribute
   */
  @JsonProperty("disabled")
  @Override
  public @Nullable Boolean getDisabled() {
    return disabled;
  }

  /**
   * @return The value of the {@code required} attribute
   */
  @JsonProperty("required")
  @Override
  public @Nullable Boolean getRequired() {
    return required;
  }

  /**
   * @return The value of the {@code className} attribute
   */
  @JsonProperty("className")
  @Override
  public @Nullable List<String> getClassName() {
    return className;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public @Nullable Object getValue() {
    return value;
  }

  /**
   * @return The value of the {@code items} attribute
   */
  @JsonProperty("items")
  @Override
  public @Nullable List<String> getItems() {
    return items;
  }

  /**
   * @return The value of the {@code activeItem} attribute
   */
  @JsonProperty("activeItem")
  @Override
  public @Nullable String getActiveItem() {
    return activeItem;
  }

  /**
   * @return The value of the {@code availableItems} attribute
   */
  @JsonProperty("availableItems")
  @Override
  public @Nullable List<String> getAvailableItems() {
    return availableItems;
  }

  /**
   * @return The value of the {@code allowedActions} attribute
   */
  @JsonProperty("allowedActions")
  @Override
  public @Nullable Set<Action.Type> getAllowedActions() {
    return allowedActions;
  }

  /**
   * @return The value of the {@code answered} attribute
   */
  @JsonProperty("answered")
  @Override
  public @Nullable Boolean getAnswered() {
    return answered;
  }

  /**
   * @return The value of the {@code valueSetId} attribute
   */
  @JsonProperty("valueSetId")
  @Override
  public @Nullable String getValueSetId() {
    return valueSetId;
  }

  /**
   * @return The value of the {@code props} attribute
   */
  @JsonProperty("props")
  @Override
  public @Nullable Map<String, Object> getProps() {
    return props;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableActionItem(
        newValue,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableActionItem(
        this.id,
        newValue,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getView() view} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for view (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withView(@Nullable String value) {
    if (Objects.equals(this.view, value)) return this;
    return new ImmutableActionItem(
        this.id,
        this.type,
        value,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withLabel(@Nullable String value) {
    if (Objects.equals(this.label, value)) return this;
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        value,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        value,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getInactive() inactive} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inactive (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withInactive(@Nullable Boolean value) {
    if (Objects.equals(this.inactive, value)) return this;
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        value,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getDisabled() disabled} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disabled (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withDisabled(@Nullable Boolean value) {
    if (Objects.equals(this.disabled, value)) return this;
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        value,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getRequired() required} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for required (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withRequired(@Nullable Boolean value) {
    if (Objects.equals(this.required, value)) return this;
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        value,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionItem#getClassName() className}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActionItem withClassName(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableActionItem(
          this.id,
          this.type,
          this.view,
          this.label,
          this.description,
          this.inactive,
          this.disabled,
          this.required,
          null,
          this.value,
          this.items,
          this.activeItem,
          this.availableItems,
          this.allowedActions,
          this.answered,
          this.valueSetId,
          this.props);
    }
    List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        newValue,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionItem#getClassName() className}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of className elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActionItem withClassName(@Nullable Iterable<String> elements) {
    if (this.className == elements) return this;
    List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        newValue,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withValue(@Nullable Object value) {
    if (this.value == value) return this;
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionItem#getItems() items}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActionItem withItems(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableActionItem(
          this.id,
          this.type,
          this.view,
          this.label,
          this.description,
          this.inactive,
          this.disabled,
          this.required,
          this.className,
          this.value,
          null,
          this.activeItem,
          this.availableItems,
          this.allowedActions,
          this.answered,
          this.valueSetId,
          this.props);
    }
    List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        newValue,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionItem#getItems() items}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of items elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActionItem withItems(@Nullable Iterable<String> elements) {
    if (this.items == elements) return this;
    List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        newValue,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getActiveItem() activeItem} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for activeItem (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withActiveItem(@Nullable String value) {
    if (Objects.equals(this.activeItem, value)) return this;
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        value,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionItem#getAvailableItems() availableItems}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActionItem withAvailableItems(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableActionItem(
          this.id,
          this.type,
          this.view,
          this.label,
          this.description,
          this.inactive,
          this.disabled,
          this.required,
          this.className,
          this.value,
          this.items,
          this.activeItem,
          null,
          this.allowedActions,
          this.answered,
          this.valueSetId,
          this.props);
    }
    List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        newValue,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionItem#getAvailableItems() availableItems}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of availableItems elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActionItem withAvailableItems(@Nullable Iterable<String> elements) {
    if (this.availableItems == elements) return this;
    List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        newValue,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionItem#getAllowedActions() allowedActions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActionItem withAllowedActions(@Nullable Action.Type... elements) {
    if (elements == null) {
      return new ImmutableActionItem(
          this.id,
          this.type,
          this.view,
          this.label,
          this.description,
          this.inactive,
          this.disabled,
          this.required,
          this.className,
          this.value,
          this.items,
          this.activeItem,
          this.availableItems,
          null,
          this.answered,
          this.valueSetId,
          this.props);
    }
    Set<Action.Type> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableEnumSet(Arrays.asList(elements));
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        newValue,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionItem#getAllowedActions() allowedActions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of allowedActions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActionItem withAllowedActions(@Nullable Iterable<Action.Type> elements) {
    if (this.allowedActions == elements) return this;
    Set<Action.Type> newValue = elements == null ? null : createUnmodifiableEnumSet(elements);
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        newValue,
        this.answered,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getAnswered() answered} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for answered (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withAnswered(@Nullable Boolean value) {
    if (Objects.equals(this.answered, value)) return this;
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        value,
        this.valueSetId,
        this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionItem#getValueSetId() valueSetId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueSetId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActionItem withValueSetId(@Nullable String value) {
    if (Objects.equals(this.valueSetId, value)) return this;
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        value,
        this.props);
  }

  /**
   * Copy the current immutable object by replacing the {@link ActionItem#getProps() props} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the props map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActionItem withProps(@Nullable Map<String, ? extends Object> entries) {
    if (this.props == entries) return this;
    Map<String, Object> newValue = entries == null ? null : createUnmodifiableMap(false, false, entries);
    return new ImmutableActionItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.inactive,
        this.disabled,
        this.required,
        this.className,
        this.value,
        this.items,
        this.activeItem,
        this.availableItems,
        this.allowedActions,
        this.answered,
        this.valueSetId,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableActionItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableActionItem
        && equalTo(0, (ImmutableActionItem) another);
  }

  private boolean equalTo(int synthetic, ImmutableActionItem another) {
    return id.equals(another.id)
        && type.equals(another.type)
        && Objects.equals(view, another.view)
        && Objects.equals(label, another.label)
        && Objects.equals(description, another.description)
        && Objects.equals(inactive, another.inactive)
        && Objects.equals(disabled, another.disabled)
        && Objects.equals(required, another.required)
        && Objects.equals(className, another.className)
        && Objects.equals(value, another.value)
        && Objects.equals(items, another.items)
        && Objects.equals(activeItem, another.activeItem)
        && Objects.equals(availableItems, another.availableItems)
        && Objects.equals(allowedActions, another.allowedActions)
        && Objects.equals(answered, another.answered)
        && Objects.equals(valueSetId, another.valueSetId)
        && Objects.equals(props, another.props);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code type}, {@code view}, {@code label}, {@code description}, {@code inactive}, {@code disabled}, {@code required}, {@code className}, {@code value}, {@code items}, {@code activeItem}, {@code availableItems}, {@code allowedActions}, {@code answered}, {@code valueSetId}, {@code props}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(view);
    h += (h << 5) + Objects.hashCode(label);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(inactive);
    h += (h << 5) + Objects.hashCode(disabled);
    h += (h << 5) + Objects.hashCode(required);
    h += (h << 5) + Objects.hashCode(className);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(items);
    h += (h << 5) + Objects.hashCode(activeItem);
    h += (h << 5) + Objects.hashCode(availableItems);
    h += (h << 5) + Objects.hashCode(allowedActions);
    h += (h << 5) + Objects.hashCode(answered);
    h += (h << 5) + Objects.hashCode(valueSetId);
    h += (h << 5) + Objects.hashCode(props);
    return h;
  }

  /**
   * Prints the immutable value {@code ActionItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ActionItem{"
        + "id=" + id
        + ", type=" + type
        + ", view=" + view
        + ", label=" + label
        + ", description=" + description
        + ", inactive=" + inactive
        + ", disabled=" + disabled
        + ", required=" + required
        + ", className=" + className
        + ", value=" + value
        + ", items=" + items
        + ", activeItem=" + activeItem
        + ", availableItems=" + availableItems
        + ", allowedActions=" + allowedActions
        + ", answered=" + answered
        + ", valueSetId=" + valueSetId
        + ", props=" + props
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ActionItem", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ActionItem {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable String view;
    @javax.annotation.Nullable String label;
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable Boolean inactive;
    @javax.annotation.Nullable Boolean disabled;
    @javax.annotation.Nullable Boolean required;
    @javax.annotation.Nullable List<String> className = null;
    @javax.annotation.Nullable Object value;
    @javax.annotation.Nullable List<String> items = null;
    @javax.annotation.Nullable String activeItem;
    @javax.annotation.Nullable List<String> availableItems = null;
    @javax.annotation.Nullable Set<Action.Type> allowedActions = null;
    @javax.annotation.Nullable Boolean answered;
    @javax.annotation.Nullable String valueSetId;
    @javax.annotation.Nullable Map<String, Object> props = null;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("view")
    public void setView(@Nullable String view) {
      this.view = view;
    }
    @JsonProperty("label")
    public void setLabel(@Nullable String label) {
      this.label = label;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("inactive")
    public void setInactive(@Nullable Boolean inactive) {
      this.inactive = inactive;
    }
    @JsonProperty("disabled")
    public void setDisabled(@Nullable Boolean disabled) {
      this.disabled = disabled;
    }
    @JsonProperty("required")
    public void setRequired(@Nullable Boolean required) {
      this.required = required;
    }
    @JsonProperty("className")
    public void setClassName(@Nullable List<String> className) {
      this.className = className;
    }
    @JsonProperty("value")
    public void setValue(@Nullable Object value) {
      this.value = value;
    }
    @JsonProperty("items")
    public void setItems(@Nullable List<String> items) {
      this.items = items;
    }
    @JsonProperty("activeItem")
    public void setActiveItem(@Nullable String activeItem) {
      this.activeItem = activeItem;
    }
    @JsonProperty("availableItems")
    public void setAvailableItems(@Nullable List<String> availableItems) {
      this.availableItems = availableItems;
    }
    @JsonProperty("allowedActions")
    public void setAllowedActions(@Nullable Set<Action.Type> allowedActions) {
      this.allowedActions = allowedActions;
    }
    @JsonProperty("answered")
    public void setAnswered(@Nullable Boolean answered) {
      this.answered = answered;
    }
    @JsonProperty("valueSetId")
    public void setValueSetId(@Nullable String valueSetId) {
      this.valueSetId = valueSetId;
    }
    @JsonProperty("props")
    public void setProps(@Nullable Map<String, Object> props) {
      this.props = props;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getView() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getInactive() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getDisabled() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getRequired() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getClassName() { throw new UnsupportedOperationException(); }
    @Override
    public Object getValue() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getItems() { throw new UnsupportedOperationException(); }
    @Override
    public String getActiveItem() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAvailableItems() { throw new UnsupportedOperationException(); }
    @Override
    public Set<Action.Type> getAllowedActions() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAnswered() { throw new UnsupportedOperationException(); }
    @Override
    public String getValueSetId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getProps() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableActionItem fromJson(Json json) {
    ImmutableActionItem.Builder builder = ImmutableActionItem.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.view != null) {
      builder.view(json.view);
    }
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.inactive != null) {
      builder.inactive(json.inactive);
    }
    if (json.disabled != null) {
      builder.disabled(json.disabled);
    }
    if (json.required != null) {
      builder.required(json.required);
    }
    if (json.className != null) {
      builder.addAllClassName(json.className);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.items != null) {
      builder.addAllItems(json.items);
    }
    if (json.activeItem != null) {
      builder.activeItem(json.activeItem);
    }
    if (json.availableItems != null) {
      builder.addAllAvailableItems(json.availableItems);
    }
    if (json.allowedActions != null) {
      builder.addAllAllowedActions(json.allowedActions);
    }
    if (json.answered != null) {
      builder.answered(json.answered);
    }
    if (json.valueSetId != null) {
      builder.valueSetId(json.valueSetId);
    }
    if (json.props != null) {
      builder.putAllProps(json.props);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ActionItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ActionItem instance
   */
  public static ImmutableActionItem copyOf(ActionItem instance) {
    if (instance instanceof ImmutableActionItem) {
      return (ImmutableActionItem) instance;
    }
    return ImmutableActionItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableActionItem ImmutableActionItem}.
   * <pre>
   * ImmutableActionItem.builder()
   *    .id(String) // required {@link ActionItem#getId() id}
   *    .type(String) // required {@link ActionItem#getType() type}
   *    .view(String | null) // nullable {@link ActionItem#getView() view}
   *    .label(String | null) // nullable {@link ActionItem#getLabel() label}
   *    .description(String | null) // nullable {@link ActionItem#getDescription() description}
   *    .inactive(Boolean | null) // nullable {@link ActionItem#getInactive() inactive}
   *    .disabled(Boolean | null) // nullable {@link ActionItem#getDisabled() disabled}
   *    .required(Boolean | null) // nullable {@link ActionItem#getRequired() required}
   *    .className(List&amp;lt;String&amp;gt; | null) // nullable {@link ActionItem#getClassName() className}
   *    .value(Object | null) // nullable {@link ActionItem#getValue() value}
   *    .items(List&amp;lt;String&amp;gt; | null) // nullable {@link ActionItem#getItems() items}
   *    .activeItem(String | null) // nullable {@link ActionItem#getActiveItem() activeItem}
   *    .availableItems(List&amp;lt;String&amp;gt; | null) // nullable {@link ActionItem#getAvailableItems() availableItems}
   *    .allowedActions(Set&amp;lt;io.dialob.api.proto.Action.Type&amp;gt; | null) // nullable {@link ActionItem#getAllowedActions() allowedActions}
   *    .answered(Boolean | null) // nullable {@link ActionItem#getAnswered() answered}
   *    .valueSetId(String | null) // nullable {@link ActionItem#getValueSetId() valueSetId}
   *    .props(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link ActionItem#getProps() props}
   *    .build();
   * </pre>
   * @return A new ImmutableActionItem builder
   */
  public static ImmutableActionItem.Builder builder() {
    return new ImmutableActionItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableActionItem ImmutableActionItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ActionItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable String view;
    private @javax.annotation.Nullable String label;
    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable Boolean inactive;
    private @javax.annotation.Nullable Boolean disabled;
    private @javax.annotation.Nullable Boolean required;
    private List<String> className = null;
    private @javax.annotation.Nullable Object value;
    private List<String> items = null;
    private @javax.annotation.Nullable String activeItem;
    private List<String> availableItems = null;
    private EnumSet<Action.Type> allowedActions = null;
    private @javax.annotation.Nullable Boolean answered;
    private @javax.annotation.Nullable String valueSetId;
    private Map<String, Object> props = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ActionItem} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ActionItem instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      type(instance.getType());
      String viewValue = instance.getView();
      if (viewValue != null) {
        view(viewValue);
      }
      String labelValue = instance.getLabel();
      if (labelValue != null) {
        label(labelValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      Boolean inactiveValue = instance.getInactive();
      if (inactiveValue != null) {
        inactive(inactiveValue);
      }
      Boolean disabledValue = instance.getDisabled();
      if (disabledValue != null) {
        disabled(disabledValue);
      }
      Boolean requiredValue = instance.getRequired();
      if (requiredValue != null) {
        required(requiredValue);
      }
      List<String> classNameValue = instance.getClassName();
      if (classNameValue != null) {
        addAllClassName(classNameValue);
      }
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      List<String> itemsValue = instance.getItems();
      if (itemsValue != null) {
        addAllItems(itemsValue);
      }
      String activeItemValue = instance.getActiveItem();
      if (activeItemValue != null) {
        activeItem(activeItemValue);
      }
      List<String> availableItemsValue = instance.getAvailableItems();
      if (availableItemsValue != null) {
        addAllAvailableItems(availableItemsValue);
      }
      Set<Action.Type> allowedActionsValue = instance.getAllowedActions();
      if (allowedActionsValue != null) {
        addAllAllowedActions(allowedActionsValue);
      }
      Boolean answeredValue = instance.getAnswered();
      if (answeredValue != null) {
        answered(answeredValue);
      }
      String valueSetIdValue = instance.getValueSetId();
      if (valueSetIdValue != null) {
        valueSetId(valueSetIdValue);
      }
      Map<String, Object> propsValue = instance.getProps();
      if (propsValue != null) {
        putAllProps(propsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getView() view} attribute.
     * @param view The value for view (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("view")
    public final Builder view(@Nullable String view) {
      this.view = view;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getLabel() label} attribute.
     * @param label The value for label (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(@Nullable String label) {
      this.label = label;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getInactive() inactive} attribute.
     * @param inactive The value for inactive (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("inactive")
    public final Builder inactive(@Nullable Boolean inactive) {
      this.inactive = inactive;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getDisabled() disabled} attribute.
     * @param disabled The value for disabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disabled")
    public final Builder disabled(@Nullable Boolean disabled) {
      this.disabled = disabled;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getRequired() required} attribute.
     * @param required The value for required (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("required")
    public final Builder required(@Nullable Boolean required) {
      this.required = required;
      return this;
    }

    /**
     * Adds one element to {@link ActionItem#getClassName() className} list.
     * @param element A className element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addClassName(String element) {
      if (this.className == null) {
        this.className = new ArrayList<String>();
      }
      this.className.add(Objects.requireNonNull(element, "className element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionItem#getClassName() className} list.
     * @param elements An array of className elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addClassName(String... elements) {
      if (this.className == null) {
        this.className = new ArrayList<String>();
      }
      for (String element : elements) {
        this.className.add(Objects.requireNonNull(element, "className element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionItem#getClassName() className} list.
     * @param elements An iterable of className elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("className")
    public final Builder className(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.className = null;
        return this;
      }
      this.className = new ArrayList<String>();
      return addAllClassName(elements);
    }

    /**
     * Adds elements to {@link ActionItem#getClassName() className} list.
     * @param elements An iterable of className elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllClassName(Iterable<String> elements) {
      Objects.requireNonNull(elements, "className element");
      if (this.className == null) {
        this.className = new ArrayList<String>();
      }
      for (String element : elements) {
        this.className.add(Objects.requireNonNull(element, "className element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(@Nullable Object value) {
      this.value = value;
      return this;
    }

    /**
     * Adds one element to {@link ActionItem#getItems() items} list.
     * @param element A items element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addItems(String element) {
      if (this.items == null) {
        this.items = new ArrayList<String>();
      }
      this.items.add(Objects.requireNonNull(element, "items element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionItem#getItems() items} list.
     * @param elements An array of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addItems(String... elements) {
      if (this.items == null) {
        this.items = new ArrayList<String>();
      }
      for (String element : elements) {
        this.items.add(Objects.requireNonNull(element, "items element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionItem#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("items")
    public final Builder items(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.items = null;
        return this;
      }
      this.items = new ArrayList<String>();
      return addAllItems(elements);
    }

    /**
     * Adds elements to {@link ActionItem#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllItems(Iterable<String> elements) {
      Objects.requireNonNull(elements, "items element");
      if (this.items == null) {
        this.items = new ArrayList<String>();
      }
      for (String element : elements) {
        this.items.add(Objects.requireNonNull(element, "items element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getActiveItem() activeItem} attribute.
     * @param activeItem The value for activeItem (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("activeItem")
    public final Builder activeItem(@Nullable String activeItem) {
      this.activeItem = activeItem;
      return this;
    }

    /**
     * Adds one element to {@link ActionItem#getAvailableItems() availableItems} list.
     * @param element A availableItems element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAvailableItems(String element) {
      if (this.availableItems == null) {
        this.availableItems = new ArrayList<String>();
      }
      this.availableItems.add(Objects.requireNonNull(element, "availableItems element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionItem#getAvailableItems() availableItems} list.
     * @param elements An array of availableItems elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAvailableItems(String... elements) {
      if (this.availableItems == null) {
        this.availableItems = new ArrayList<String>();
      }
      for (String element : elements) {
        this.availableItems.add(Objects.requireNonNull(element, "availableItems element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionItem#getAvailableItems() availableItems} list.
     * @param elements An iterable of availableItems elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("availableItems")
    public final Builder availableItems(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.availableItems = null;
        return this;
      }
      this.availableItems = new ArrayList<String>();
      return addAllAvailableItems(elements);
    }

    /**
     * Adds elements to {@link ActionItem#getAvailableItems() availableItems} list.
     * @param elements An iterable of availableItems elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAvailableItems(Iterable<String> elements) {
      Objects.requireNonNull(elements, "availableItems element");
      if (this.availableItems == null) {
        this.availableItems = new ArrayList<String>();
      }
      for (String element : elements) {
        this.availableItems.add(Objects.requireNonNull(element, "availableItems element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ActionItem#getAllowedActions() allowedActions} set.
     * @param element A allowedActions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllowedActions(Action.Type element) {
      if (this.allowedActions == null) {
        this.allowedActions = EnumSet.noneOf(Action.Type.class);
      }
      this.allowedActions.add(Objects.requireNonNull(element, "allowedActions element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionItem#getAllowedActions() allowedActions} set.
     * @param elements An array of allowedActions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllowedActions(Action.Type... elements) {
      if (this.allowedActions == null) {
        this.allowedActions = EnumSet.noneOf(Action.Type.class);
      }
      for (Action.Type element : elements) {
        this.allowedActions.add(Objects.requireNonNull(element, "allowedActions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionItem#getAllowedActions() allowedActions} set.
     * @param elements An iterable of allowedActions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowedActions")
    public final Builder allowedActions(@Nullable Iterable<Action.Type> elements) {
      if (elements == null) {
        this.allowedActions = null;
        return this;
      }
      this.allowedActions = EnumSet.noneOf(Action.Type.class);
      return addAllAllowedActions(elements);
    }

    /**
     * Adds elements to {@link ActionItem#getAllowedActions() allowedActions} set.
     * @param elements An iterable of allowedActions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedActions(Iterable<Action.Type> elements) {
      Objects.requireNonNull(elements, "allowedActions element");
      if (this.allowedActions == null) {
        this.allowedActions = EnumSet.noneOf(Action.Type.class);
      }
      for (Action.Type element : elements) {
        this.allowedActions.add(Objects.requireNonNull(element, "allowedActions element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getAnswered() answered} attribute.
     * @param answered The value for answered (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("answered")
    public final Builder answered(@Nullable Boolean answered) {
      this.answered = answered;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionItem#getValueSetId() valueSetId} attribute.
     * @param valueSetId The value for valueSetId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("valueSetId")
    public final Builder valueSetId(@Nullable String valueSetId) {
      this.valueSetId = valueSetId;
      return this;
    }

    /**
     * Put one entry to the {@link ActionItem#getProps() props} map.
     * @param key The key in the props map
     * @param value The associated value in the props map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProps(@javax.annotation.Nullable String key, @javax.annotation.Nullable Object value) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      this.props.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ActionItem#getProps() props} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProps(Map.Entry<String, ? extends Object> entry) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.props.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ActionItem#getProps() props} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the props map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("props")
    public final Builder props(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.props = null;
        return this;
      }
      this.props = new LinkedHashMap<String, Object>();
      return putAllProps(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ActionItem#getProps() props} map. Nulls are not permitted
     * @param entries The entries that will be added to the props map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProps(Map<String, ? extends Object> entries) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.props.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableActionItem ImmutableActionItem}.
     * @return An immutable instance of ActionItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableActionItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableActionItem(
          id,
          type,
          view,
          label,
          description,
          inactive,
          disabled,
          required,
          className == null ? null : createUnmodifiableList(true, className),
          value,
          items == null ? null : createUnmodifiableList(true, items),
          activeItem,
          availableItems == null ? null : createUnmodifiableList(true, availableItems),
          allowedActions == null ? null : createUnmodifiableEnumSet(allowedActions),
          answered,
          valueSetId,
          props == null ? null : createUnmodifiableMap(false, false, props));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ActionItem, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  @SuppressWarnings("unchecked")
  private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
    if (iterable instanceof EnumSet<?>) {
      return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet<T>) iterable));
    }
    List<T> list = createSafeList(iterable, true, false);
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default: return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
