package io.dialob.api.proto;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code ValueSetEntry}.
 * @see ImmutableValueSetEntry
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.proto", generator = "Gsons")
public final class GsonAdaptersValueSetEntry implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ValueSetEntryTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ValueSetEntryTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersValueSetEntry(ValueSetEntry)";
  }

  @org.immutables.value.Generated(from = "ValueSetEntry", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class ValueSetEntryTypeAdapter extends TypeAdapter<ValueSetEntry> {

    ValueSetEntryTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return ValueSetEntry.class == type.getRawType()
          || ImmutableValueSetEntry.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, ValueSetEntry value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeValueSetEntry(out, value);
      }
    }

    @Override
    public ValueSetEntry read(JsonReader in) throws IOException {
      return readValueSetEntry(in);
    }

    private void writeValueSetEntry(JsonWriter out, ValueSetEntry instance)
        throws IOException {
      out.beginObject();
      out.name("key");
      out.value(instance.getKey());
      String valueValue = instance.getValue();
      if (valueValue != null) {
        out.name("value");
        out.value(valueValue);
      } else if (out.getSerializeNulls()) {
        out.name("value");
        out.nullValue();
      }
      out.endObject();
    }

    private  ValueSetEntry readValueSetEntry(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableValueSetEntry.Builder builder = ImmutableValueSetEntry.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableValueSetEntry.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'k':
        if ("key".equals(attributeName)) {
          readInKey(in, builder);
          return;
        }
        break;
      case 'v':
        if ("value".equals(attributeName)) {
          readInValue(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInKey(JsonReader in, ImmutableValueSetEntry.Builder builder)
        throws IOException {
      builder.key(in.nextString());
    }

    private void readInValue(JsonReader in, ImmutableValueSetEntry.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.value(in.nextString());
      }
    }
  }
}
