package io.dialob.api.proto;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code ActionItem}.
 * @see ImmutableActionItem
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.proto", generator = "Gsons")
public final class GsonAdaptersActionItem implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ActionItemTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ActionItemTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersActionItem(ActionItem)";
  }

  @org.immutables.value.Generated(from = "ActionItem", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class ActionItemTypeAdapter extends TypeAdapter<ActionItem> {
    public final Boolean inactiveTypeSample = null;
    public final Boolean disabledTypeSample = null;
    public final Boolean requiredTypeSample = null;
    public final Object valueTypeSample = null;
    public final Action.Type allowedActionsTypeSample = null;
    public final Boolean answeredTypeSample = null;
    public final Object propsSecondaryTypeSample = null;
    private final TypeAdapter<Boolean> inactiveTypeAdapter;
    private final TypeAdapter<Boolean> disabledTypeAdapter;
    private final TypeAdapter<Boolean> requiredTypeAdapter;
    private final TypeAdapter<Object> valueTypeAdapter;
    private final TypeAdapter<Action.Type> allowedActionsTypeAdapter;
    private final TypeAdapter<Boolean> answeredTypeAdapter;
    private final TypeAdapter<Object> propsSecondaryTypeAdapter;

    ActionItemTypeAdapter(Gson gson) {
      this.inactiveTypeAdapter = gson.getAdapter( Boolean.class);
      this.disabledTypeAdapter = gson.getAdapter( Boolean.class);
      this.requiredTypeAdapter = gson.getAdapter( Boolean.class);
      this.valueTypeAdapter = gson.getAdapter( Object.class);
      this.allowedActionsTypeAdapter = gson.getAdapter( Action.Type.class);
      this.answeredTypeAdapter = gson.getAdapter( Boolean.class);
      this.propsSecondaryTypeAdapter = gson.getAdapter( Object.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return ActionItem.class == type.getRawType()
          || ImmutableActionItem.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, ActionItem value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeActionItem(out, value);
      }
    }

    @Override
    public ActionItem read(JsonReader in) throws IOException {
      return readActionItem(in);
    }

    private void writeActionItem(JsonWriter out, ActionItem instance)
        throws IOException {
      out.beginObject();
      out.name("id");
      out.value(instance.getId());
      out.name("type");
      out.value(instance.getType());
      String viewValue = instance.getView();
      if (viewValue != null) {
        out.name("view");
        out.value(viewValue);
      } else if (out.getSerializeNulls()) {
        out.name("view");
        out.nullValue();
      }
      String labelValue = instance.getLabel();
      if (labelValue != null) {
        out.name("label");
        out.value(labelValue);
      } else if (out.getSerializeNulls()) {
        out.name("label");
        out.nullValue();
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        out.name("description");
        out.value(descriptionValue);
      } else if (out.getSerializeNulls()) {
        out.name("description");
        out.nullValue();
      }
      Boolean inactiveValue = instance.getInactive();
      if (inactiveValue != null) {
        out.name("inactive");
        inactiveTypeAdapter.write(out, inactiveValue);
      } else if (out.getSerializeNulls()) {
        out.name("inactive");
        out.nullValue();
      }
      Boolean disabledValue = instance.getDisabled();
      if (disabledValue != null) {
        out.name("disabled");
        disabledTypeAdapter.write(out, disabledValue);
      } else if (out.getSerializeNulls()) {
        out.name("disabled");
        out.nullValue();
      }
      Boolean requiredValue = instance.getRequired();
      if (requiredValue != null) {
        out.name("required");
        requiredTypeAdapter.write(out, requiredValue);
      } else if (out.getSerializeNulls()) {
        out.name("required");
        out.nullValue();
      }
      List<String> classNameElements = instance.getClassName();
      if (classNameElements != null && !classNameElements.isEmpty()) {
        out.name("className");
        out.beginArray();
        for (String e : classNameElements) {
          out.value(e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("className");
        if (classNameElements == null) {
          out.nullValue();
        } else {
          out.beginArray();
          out.endArray();
        }
      }
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        out.name("value");
        valueTypeAdapter.write(out, valueValue);
      } else if (out.getSerializeNulls()) {
        out.name("value");
        out.nullValue();
      }
      List<String> itemsElements = instance.getItems();
      if (itemsElements != null && !itemsElements.isEmpty()) {
        out.name("items");
        out.beginArray();
        for (String e : itemsElements) {
          out.value(e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("items");
        if (itemsElements == null) {
          out.nullValue();
        } else {
          out.beginArray();
          out.endArray();
        }
      }
      String activeItemValue = instance.getActiveItem();
      if (activeItemValue != null) {
        out.name("activeItem");
        out.value(activeItemValue);
      } else if (out.getSerializeNulls()) {
        out.name("activeItem");
        out.nullValue();
      }
      List<String> availableItemsElements = instance.getAvailableItems();
      if (availableItemsElements != null && !availableItemsElements.isEmpty()) {
        out.name("availableItems");
        out.beginArray();
        for (String e : availableItemsElements) {
          out.value(e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("availableItems");
        if (availableItemsElements == null) {
          out.nullValue();
        } else {
          out.beginArray();
          out.endArray();
        }
      }
      Set<Action.Type> allowedActionsElements = instance.getAllowedActions();
      if (allowedActionsElements != null && !allowedActionsElements.isEmpty()) {
        out.name("allowedActions");
        out.beginArray();
        for (Action.Type e : allowedActionsElements) {
          allowedActionsTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("allowedActions");
        if (allowedActionsElements == null) {
          out.nullValue();
        } else {
          out.beginArray();
          out.endArray();
        }
      }
      Boolean answeredValue = instance.getAnswered();
      if (answeredValue != null) {
        out.name("answered");
        answeredTypeAdapter.write(out, answeredValue);
      } else if (out.getSerializeNulls()) {
        out.name("answered");
        out.nullValue();
      }
      String valueSetIdValue = instance.getValueSetId();
      if (valueSetIdValue != null) {
        out.name("valueSetId");
        out.value(valueSetIdValue);
      } else if (out.getSerializeNulls()) {
        out.name("valueSetId");
        out.nullValue();
      }
      Map<String, Object> propsMapping = instance.getProps();
      if (propsMapping != null && !propsMapping.isEmpty()) {
        out.name("props");
        out.beginObject();
        for (Map.Entry<String, Object> e : propsMapping.entrySet()) {
          String key = e.getKey();
          out.name(key);
          Object value = e.getValue();
          propsSecondaryTypeAdapter.write(out, value);
        }
        out.endObject();
      } else if (out.getSerializeNulls()) {
        out.name("props");
        if (propsMapping == null) {
          out.nullValue();
        } else {
          out.beginObject();
          out.endObject();
        }
      }
      out.endObject();
    }

    private  ActionItem readActionItem(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableActionItem.Builder builder = ImmutableActionItem.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        if ("inactive".equals(attributeName)) {
          readInInactive(in, builder);
          return;
        }
        if ("items".equals(attributeName)) {
          readInItems(in, builder);
          return;
        }
        break;
      case 't':
        if ("type".equals(attributeName)) {
          readInType(in, builder);
          return;
        }
        break;
      case 'v':
        if ("view".equals(attributeName)) {
          readInView(in, builder);
          return;
        }
        if ("value".equals(attributeName)) {
          readInValue(in, builder);
          return;
        }
        if ("valueSetId".equals(attributeName)) {
          readInValueSetId(in, builder);
          return;
        }
        break;
      case 'l':
        if ("label".equals(attributeName)) {
          readInLabel(in, builder);
          return;
        }
        break;
      case 'd':
        if ("description".equals(attributeName)) {
          readInDescription(in, builder);
          return;
        }
        if ("disabled".equals(attributeName)) {
          readInDisabled(in, builder);
          return;
        }
        break;
      case 'r':
        if ("required".equals(attributeName)) {
          readInRequired(in, builder);
          return;
        }
        break;
      case 'c':
        if ("className".equals(attributeName)) {
          readInClassName(in, builder);
          return;
        }
        break;
      case 'a':
        if ("activeItem".equals(attributeName)) {
          readInActiveItem(in, builder);
          return;
        }
        if ("availableItems".equals(attributeName)) {
          readInAvailableItems(in, builder);
          return;
        }
        if ("allowedActions".equals(attributeName)) {
          readInAllowedActions(in, builder);
          return;
        }
        if ("answered".equals(attributeName)) {
          readInAnswered(in, builder);
          return;
        }
        break;
      case 'p':
        if ("props".equals(attributeName)) {
          readInProps(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      builder.id(in.nextString());
    }

    private void readInType(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      builder.type(in.nextString());
    }

    private void readInView(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.view(in.nextString());
      }
    }

    private void readInLabel(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.label(in.nextString());
      }
    }

    private void readInDescription(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.description(in.nextString());
      }
    }

    private void readInInactive(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = inactiveTypeAdapter.read(in);
        builder.inactive(value);
      }
    }

    private void readInDisabled(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = disabledTypeAdapter.read(in);
        builder.disabled(value);
      }
    }

    private void readInRequired(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = requiredTypeAdapter.read(in);
        builder.required(value);
      }
    }

    private void readInClassName(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        boolean empty = true;
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            builder.addClassName(in.nextString());
            empty = false;
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          builder.addClassName(in.nextString());
          empty = false;
        }
        if (empty) {
          builder.addAllClassName(Collections.<String>emptyList());
        }
      }
    }

    private void readInValue(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Object value = valueTypeAdapter.read(in);
        builder.value(value);
      }
    }

    private void readInItems(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        boolean empty = true;
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            builder.addItems(in.nextString());
            empty = false;
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          builder.addItems(in.nextString());
          empty = false;
        }
        if (empty) {
          builder.addAllItems(Collections.<String>emptyList());
        }
      }
    }

    private void readInActiveItem(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.activeItem(in.nextString());
      }
    }

    private void readInAvailableItems(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        boolean empty = true;
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            builder.addAvailableItems(in.nextString());
            empty = false;
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          builder.addAvailableItems(in.nextString());
          empty = false;
        }
        if (empty) {
          builder.addAllAvailableItems(Collections.<String>emptyList());
        }
      }
    }

    private void readInAllowedActions(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        boolean empty = true;
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            Action.Type value = allowedActionsTypeAdapter.read(in);
            builder.addAllowedActions(value);
            empty = false;
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          Action.Type value = allowedActionsTypeAdapter.read(in);
          builder.addAllowedActions(value);
          empty = false;
        }
        if (empty) {
          builder.addAllAllowedActions(Collections.<Action.Type>emptyList());
        }
      }
    }

    private void readInAnswered(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = answeredTypeAdapter.read(in);
        builder.answered(value);
      }
    }

    private void readInValueSetId(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.valueSetId(in.nextString());
      }
    }

    private void readInProps(JsonReader in, ImmutableActionItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          in.beginObject();
          boolean empty = true;
          while(in.hasNext()) {
            String rawKey = in.nextName();
            String key = rawKey;
            Object value = propsSecondaryTypeAdapter.read(in);
            builder.putProps(key, value);
            empty = false;
          }
          if (empty) {
            builder.putAllProps(Collections.<String, Object>emptyMap());
          }
          in.endObject();
        }
      }
    }
  }
}
