package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link FormValueSet FormValueSet} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableFormValueSet is not thread-safe</em>
 * @see ImmutableFormValueSet
 */
@Generated(from = "FormValueSet", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "FormValueSet"})
@NotThreadSafe
public final class ModifiableFormValueSet implements FormValueSet {

  private String id;
  private final ArrayList<FormValueSetEntry> entries = new ArrayList<FormValueSetEntry>();
  private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

  private ModifiableFormValueSet() {}

  /**
   * Construct a modifiable instance of {@code FormValueSet}.
   * @return A new modifiable instance
   */
  public static ModifiableFormValueSet create() {
    return new ModifiableFormValueSet();
  }

  /**
   * @return value of {@code id} attribute, may be {@code null}
   */
  @JsonProperty("id")
  @Override
  public final String getId() {
    return id;
  }

  /**
   * @return modifiable list {@code entries}
   */
  @JsonProperty("entries")
  @Override
  public final List<FormValueSetEntry> getEntries() {
    return entries;
  }

  /**
   * @return value of {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @JsonInclude
  @Override
  public final Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSet clear() {
    id = null;
    entries.clear();
    additionalProperties.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link FormValueSet} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSet from(FormValueSet instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableFormValueSet) {
      from((ModifiableFormValueSet) instance);
      return this;
    }
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    addAllEntries(instance.getEntries());
    putAllAdditionalProperties(instance.getAdditionalProperties());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link FormValueSet} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSet from(ModifiableFormValueSet instance) {
    Objects.requireNonNull(instance, "instance");
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    addAllEntries(instance.getEntries());
    putAllAdditionalProperties(instance.getAdditionalProperties());
    return this;
  }

  /**
   * Assigns a value to the {@link FormValueSet#getId() id} attribute.
   * @param id The value for id, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSet setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Adds one element to {@link FormValueSet#getEntries() entries} list.
   * @param element The entries element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSet addEntries(FormValueSetEntry element) {
    this.entries.add(element);
    return this;
  }

  /**
   * Adds elements to {@link FormValueSet#getEntries() entries} list.
   * @param elements An array of entries elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableFormValueSet addEntries(FormValueSetEntry... elements) {
    for (FormValueSetEntry e : elements) {
      addEntries(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link FormValueSet#getEntries() entries} list.
   * @param elements An iterable of entries elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSet setEntries(Iterable<? extends FormValueSetEntry> elements) {
    this.entries.clear();
    addAllEntries(elements);
    return this;
  }

  /**
   * Adds elements to {@link FormValueSet#getEntries() entries} list.
   * @param elements An iterable of entries elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSet addAllEntries(Iterable<? extends FormValueSetEntry> elements) {
    for (FormValueSetEntry e : elements) {
      addEntries(e);
    }
    return this;
  }

  /**
   * Put one entry to the {@link FormValueSet#getAdditionalProperties() additionalProperties} map.
   * @param key The key in additionalProperties map
   * @param value The associated value in the additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSet putAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(
        Objects.requireNonNull(key, "additionalProperties key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link FormValueSet#getAdditionalProperties() additionalProperties} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSet setAdditionalProperties(Map<String, ? extends Object> entries) {
    this.additionalProperties.clear();
    this.putAllAdditionalProperties(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link FormValueSet#getAdditionalProperties() additionalProperties} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSet putAllAdditionalProperties(Map<String, ? extends Object> entries) {
    for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
      String k = e.getKey();
      Object v = e.getValue();
      this.additionalProperties.put(
          Objects.requireNonNull(k, "additionalProperties key"),
          v);
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableFormValueSet ImmutableFormValueSet}.
   * @return An immutable instance of FormValueSet
   */
  public final ImmutableFormValueSet toImmutable() {
    return ImmutableFormValueSet.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableFormValueSet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableFormValueSet)) return false;
    ModifiableFormValueSet other = (ModifiableFormValueSet) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableFormValueSet another) {
    return Objects.equals(id, another.id)
        && entries.equals(another.entries)
        && additionalProperties.equals(another.additionalProperties);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code entries}, {@code additionalProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + entries.hashCode();
    h += (h << 5) + additionalProperties.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code FormValueSet}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableFormValueSet{"
        + "id=" + getId()
        + ", entries=" + getEntries()
        + ", additionalProperties=" + getAdditionalProperties()
        + "}";
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
