package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormTag}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormTag.builder()}.
 */
@Generated(from = "FormTag", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFormTag implements FormTag {
  private final String formName;
  private final String name;
  private final @Nullable String refName;
  private final @Nullable Date created;
  private final @Nullable String formId;
  private final @Nullable String description;
  private final FormTag.Type type;

  private ImmutableFormTag(ImmutableFormTag.Builder builder) {
    this.formName = builder.formName;
    this.name = builder.name;
    this.refName = builder.refName;
    this.created = builder.created;
    this.formId = builder.formId;
    this.description = builder.description;
    this.type = builder.typeIsSet()
        ? builder.type
        : FormTag.super.getType();
  }

  private ImmutableFormTag(
      String formName,
      String name,
      @Nullable String refName,
      @Nullable Date created,
      @Nullable String formId,
      @Nullable String description,
      FormTag.Type type) {
    this.formName = formName;
    this.name = name;
    this.refName = refName;
    this.created = created;
    this.formId = formId;
    this.description = description;
    this.type = type;
  }

  /**
   * @return The value of the {@code formName} attribute
   */
  @JsonProperty("formName")
  @Override
  public String getFormName() {
    return formName;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code refName} attribute
   */
  @JsonProperty("refName")
  @Override
  public @Nullable String getRefName() {
    return refName;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public @Nullable Date getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code formId} attribute
   */
  @JsonProperty("formId")
  @Override
  public @Nullable String getFormId() {
    return formId;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public FormTag.Type getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTag#getFormName() formName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTag withFormName(String value) {
    if (Objects.equals(this.formName, value)) return this;
    return new ImmutableFormTag(value, this.name, this.refName, this.created, this.formId, this.description, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTag#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTag withName(String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableFormTag(this.formName, value, this.refName, this.created, this.formId, this.description, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTag#getRefName() refName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTag withRefName(@Nullable String value) {
    if (Objects.equals(this.refName, value)) return this;
    return new ImmutableFormTag(this.formName, this.name, value, this.created, this.formId, this.description, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTag#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTag withCreated(@Nullable Date value) {
    if (this.created == value) return this;
    return new ImmutableFormTag(this.formName, this.name, this.refName, value, this.formId, this.description, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTag#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTag withFormId(@Nullable String value) {
    if (Objects.equals(this.formId, value)) return this;
    return new ImmutableFormTag(this.formName, this.name, this.refName, this.created, value, this.description, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTag#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTag withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableFormTag(this.formName, this.name, this.refName, this.created, this.formId, value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormTag#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTag withType(FormTag.Type value) {
    FormTag.Type newValue = value;
    if (this.type == newValue) return this;
    return new ImmutableFormTag(this.formName, this.name, this.refName, this.created, this.formId, this.description, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormTag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormTag
        && equalTo(0, (ImmutableFormTag) another);
  }

  private boolean equalTo(int synthetic, ImmutableFormTag another) {
    return Objects.equals(formName, another.formName)
        && Objects.equals(name, another.name)
        && Objects.equals(refName, another.refName)
        && Objects.equals(created, another.created)
        && Objects.equals(formId, another.formId)
        && Objects.equals(description, another.description)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code formName}, {@code name}, {@code refName}, {@code created}, {@code formId}, {@code description}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(formName);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(refName);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(formId);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormTag} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FormTag{"
        + "formName=" + formName
        + ", name=" + name
        + ", refName=" + refName
        + ", created=" + created
        + ", formId=" + formId
        + ", description=" + description
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FormTag", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FormTag {
    @javax.annotation.Nullable String formName;
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String refName;
    @javax.annotation.Nullable Date created;
    @javax.annotation.Nullable String formId;
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable FormTag.Type type;
    boolean typeIsSet;
    @JsonProperty("formName")
    public void setFormName(String formName) {
      this.formName = formName;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("refName")
    public void setRefName(@Nullable String refName) {
      this.refName = refName;
    }
    @JsonProperty("created")
    public void setCreated(@Nullable Date created) {
      this.created = created;
    }
    @JsonProperty("formId")
    public void setFormId(@Nullable String formId) {
      this.formId = formId;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("type")
    public void setType(FormTag.Type type) {
      this.type = type;
      this.typeIsSet = true;
    }
    @Override
    public String getFormName() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRefName() { throw new UnsupportedOperationException(); }
    @Override
    public Date getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public String getFormId() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public FormTag.Type getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormTag fromJson(Json json) {
    ImmutableFormTag.Builder builder = ImmutableFormTag.builder();
    if (json.formName != null) {
      builder.formName(json.formName);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.refName != null) {
      builder.refName(json.refName);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.formId != null) {
      builder.formId(json.formId);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.typeIsSet) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FormTag} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormTag instance
   */
  public static ImmutableFormTag copyOf(FormTag instance) {
    if (instance instanceof ImmutableFormTag) {
      return (ImmutableFormTag) instance;
    }
    return ImmutableFormTag.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormTag ImmutableFormTag}.
   * <pre>
   * ImmutableFormTag.builder()
   *    .formName(String | null) // nullable {@link FormTag#getFormName() formName}
   *    .name(String | null) // nullable {@link FormTag#getName() name}
   *    .refName(String | null) // nullable {@link FormTag#getRefName() refName}
   *    .created(Date | null) // nullable {@link FormTag#getCreated() created}
   *    .formId(String | null) // nullable {@link FormTag#getFormId() formId}
   *    .description(String | null) // nullable {@link FormTag#getDescription() description}
   *    .type(io.dialob.api.form.FormTag.Type) // optional {@link FormTag#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableFormTag builder
   */
  public static ImmutableFormTag.Builder builder() {
    return new ImmutableFormTag.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormTag ImmutableFormTag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormTag", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_TYPE = 0x1L;
    private long optBits;

    private @javax.annotation.Nullable String formName;
    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String refName;
    private @javax.annotation.Nullable Date created;
    private @javax.annotation.Nullable String formId;
    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable FormTag.Type type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FormTag} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormTag instance) {
      Objects.requireNonNull(instance, "instance");
      String formNameValue = instance.getFormName();
      if (formNameValue != null) {
        formName(formNameValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String refNameValue = instance.getRefName();
      if (refNameValue != null) {
        refName(refNameValue);
      }
      Date createdValue = instance.getCreated();
      if (createdValue != null) {
        created(createdValue);
      }
      String formIdValue = instance.getFormId();
      if (formIdValue != null) {
        formId(formIdValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link FormTag#getFormName() formName} attribute.
     * @param formName The value for formName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("formName")
    public final Builder formName(String formName) {
      this.formName = formName;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTag#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTag#getRefName() refName} attribute.
     * @param refName The value for refName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("refName")
    public final Builder refName(@Nullable String refName) {
      this.refName = refName;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTag#getCreated() created} attribute.
     * @param created The value for created (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(@Nullable Date created) {
      this.created = created;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTag#getFormId() formId} attribute.
     * @param formId The value for formId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("formId")
    public final Builder formId(@Nullable String formId) {
      this.formId = formId;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTag#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link FormTag#getType() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FormTag#getType() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(FormTag.Type type) {
      this.type = type;
      optBits |= OPT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormTag ImmutableFormTag}.
     * @return An immutable instance of FormTag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormTag build() {
      return new ImmutableFormTag(this);
    }

    private boolean typeIsSet() {
      return (optBits & OPT_BIT_TYPE) != 0;
    }
  }
}
