package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Form}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableForm.builder()}.
 */
@Generated(from = "Form", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties({"saving", "rules", "updated", "failed", "serviceCalls"})
public final class ImmutableForm implements Form {
  private final @Nullable String id;
  private final @Nullable String rev;
  private final @Nullable String name;
  private final Map<String, FormItem> data;
  private final Form.Metadata metadata;
  private final List<Variable> variables;
  private final Map<String, Form> namespaces;
  private final List<FormValueSet> valueSets;
  private final Map<String, String> requiredErrorText;

  private ImmutableForm(
      @Nullable String id,
      @Nullable String rev,
      @Nullable String name,
      Map<String, FormItem> data,
      Form.Metadata metadata,
      List<Variable> variables,
      Map<String, Form> namespaces,
      List<FormValueSet> valueSets,
      Map<String, String> requiredErrorText) {
    this.id = id;
    this.rev = rev;
    this.name = name;
    this.data = data;
    this.metadata = metadata;
    this.variables = variables;
    this.namespaces = namespaces;
    this.valueSets = valueSets;
    this.requiredErrorText = requiredErrorText;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("_id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("_rev")
  @Override
  public @Nullable String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code data} attribute
   */
  @JsonProperty("data")
  @Override
  public Map<String, FormItem> getData() {
    return data;
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty("metadata")
  @Override
  public Form.Metadata getMetadata() {
    return metadata;
  }

  /**
   * @return The value of the {@code variables} attribute
   */
  @JsonProperty("variables")
  @Override
  public List<Variable> getVariables() {
    return variables;
  }

  /**
   * @return The value of the {@code namespaces} attribute
   */
  @JsonProperty("namespaces")
  @Override
  public Map<String, Form> getNamespaces() {
    return namespaces;
  }

  /**
   * @return The value of the {@code valueSets} attribute
   */
  @JsonProperty("valueSets")
  @Override
  public List<FormValueSet> getValueSets() {
    return valueSets;
  }

  /**
   * @return error text for required fields, unless not defined per item
   */
  @JsonProperty("requiredErrorText")
  @Override
  public Map<String, String> getRequiredErrorText() {
    return requiredErrorText;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForm withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return validate(new ImmutableForm(
        value,
        this.rev,
        this.name,
        this.data,
        this.metadata,
        this.variables,
        this.namespaces,
        this.valueSets,
        this.requiredErrorText));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForm withRev(@Nullable String value) {
    if (Objects.equals(this.rev, value)) return this;
    return validate(new ImmutableForm(
        this.id,
        value,
        this.name,
        this.data,
        this.metadata,
        this.variables,
        this.namespaces,
        this.valueSets,
        this.requiredErrorText));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForm withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new ImmutableForm(
        this.id,
        this.rev,
        value,
        this.data,
        this.metadata,
        this.variables,
        this.namespaces,
        this.valueSets,
        this.requiredErrorText));
  }

  /**
   * Copy the current immutable object by replacing the {@link Form#getData() data} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the data map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForm withData(Map<String, ? extends FormItem> entries) {
    if (this.data == entries) return this;
    Map<String, FormItem> newValue = createUnmodifiableMap(false, false, entries);
    return validate(new ImmutableForm(
        this.id,
        this.rev,
        this.name,
        newValue,
        this.metadata,
        this.variables,
        this.namespaces,
        this.valueSets,
        this.requiredErrorText));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form#getMetadata() metadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadata (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForm withMetadata(Form.Metadata value) {
    if (this.metadata == value) return this;
    return validate(new ImmutableForm(
        this.id,
        this.rev,
        this.name,
        this.data,
        value,
        this.variables,
        this.namespaces,
        this.valueSets,
        this.requiredErrorText));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Form#getVariables() variables}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForm withVariables(Variable... elements) {
    List<Variable> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return validate(new ImmutableForm(
        this.id,
        this.rev,
        this.name,
        this.data,
        this.metadata,
        newValue,
        this.namespaces,
        this.valueSets,
        this.requiredErrorText));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Form#getVariables() variables}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of variables elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForm withVariables(Iterable<? extends Variable> elements) {
    if (this.variables == elements) return this;
    List<Variable> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return validate(new ImmutableForm(
        this.id,
        this.rev,
        this.name,
        this.data,
        this.metadata,
        newValue,
        this.namespaces,
        this.valueSets,
        this.requiredErrorText));
  }

  /**
   * Copy the current immutable object by replacing the {@link Form#getNamespaces() namespaces} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the namespaces map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForm withNamespaces(Map<String, ? extends Form> entries) {
    if (this.namespaces == entries) return this;
    Map<String, Form> newValue = createUnmodifiableMap(false, false, entries);
    return validate(new ImmutableForm(
        this.id,
        this.rev,
        this.name,
        this.data,
        this.metadata,
        this.variables,
        newValue,
        this.valueSets,
        this.requiredErrorText));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Form#getValueSets() valueSets}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForm withValueSets(FormValueSet... elements) {
    List<FormValueSet> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return validate(new ImmutableForm(
        this.id,
        this.rev,
        this.name,
        this.data,
        this.metadata,
        this.variables,
        this.namespaces,
        newValue,
        this.requiredErrorText));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Form#getValueSets() valueSets}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of valueSets elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForm withValueSets(Iterable<? extends FormValueSet> elements) {
    if (this.valueSets == elements) return this;
    List<FormValueSet> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return validate(new ImmutableForm(
        this.id,
        this.rev,
        this.name,
        this.data,
        this.metadata,
        this.variables,
        this.namespaces,
        newValue,
        this.requiredErrorText));
  }

  /**
   * Copy the current immutable object by replacing the {@link Form#getRequiredErrorText() requiredErrorText} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the requiredErrorText map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForm withRequiredErrorText(Map<String, ? extends String> entries) {
    if (this.requiredErrorText == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(false, false, entries);
    return validate(new ImmutableForm(
        this.id,
        this.rev,
        this.name,
        this.data,
        this.metadata,
        this.variables,
        this.namespaces,
        this.valueSets,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableForm} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableForm
        && equalTo(0, (ImmutableForm) another);
  }

  private boolean equalTo(int synthetic, ImmutableForm another) {
    return Objects.equals(id, another.id)
        && Objects.equals(rev, another.rev)
        && Objects.equals(name, another.name)
        && data.equals(another.data)
        && Objects.equals(metadata, another.metadata)
        && variables.equals(another.variables)
        && namespaces.equals(another.namespaces)
        && valueSets.equals(another.valueSets)
        && requiredErrorText.equals(another.requiredErrorText);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code name}, {@code data}, {@code metadata}, {@code variables}, {@code namespaces}, {@code valueSets}, {@code requiredErrorText}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(rev);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + data.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + namespaces.hashCode();
    h += (h << 5) + valueSets.hashCode();
    h += (h << 5) + requiredErrorText.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Form} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Form{"
        + "id=" + id
        + ", rev=" + rev
        + ", name=" + name
        + ", data=" + data
        + ", metadata=" + metadata
        + ", variables=" + variables
        + ", namespaces=" + namespaces
        + ", valueSets=" + valueSets
        + ", requiredErrorText=" + requiredErrorText
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Form", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Form {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable String rev;
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable Map<String, FormItem> data = Collections.emptyMap();
    @javax.annotation.Nullable Form.Metadata metadata;
    @javax.annotation.Nullable List<Variable> variables = Collections.emptyList();
    @javax.annotation.Nullable Map<String, Form> namespaces = Collections.emptyMap();
    @javax.annotation.Nullable List<FormValueSet> valueSets = Collections.emptyList();
    @javax.annotation.Nullable Map<String, String> requiredErrorText = Collections.emptyMap();
    @JsonProperty("_id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("_rev")
    public void setRev(@Nullable String rev) {
      this.rev = rev;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("data")
    public void setData(Map<String, FormItem> data) {
      this.data = data;
    }
    @JsonProperty("metadata")
    public void setMetadata(Form.Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("variables")
    public void setVariables(List<Variable> variables) {
      this.variables = variables;
    }
    @JsonProperty("namespaces")
    public void setNamespaces(Map<String, Form> namespaces) {
      this.namespaces = namespaces;
    }
    @JsonProperty("valueSets")
    public void setValueSets(List<FormValueSet> valueSets) {
      this.valueSets = valueSets;
    }
    @JsonProperty("requiredErrorText")
    public void setRequiredErrorText(Map<String, String> requiredErrorText) {
      this.requiredErrorText = requiredErrorText;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, FormItem> getData() { throw new UnsupportedOperationException(); }
    @Override
    public Form.Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public List<Variable> getVariables() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Form> getNamespaces() { throw new UnsupportedOperationException(); }
    @Override
    public List<FormValueSet> getValueSets() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getRequiredErrorText() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableForm fromJson(Json json) {
    ImmutableForm.Builder builder = ImmutableForm.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.data != null) {
      builder.putAllData(json.data);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.variables != null) {
      builder.addAllVariables(json.variables);
    }
    if (json.namespaces != null) {
      builder.putAllNamespaces(json.namespaces);
    }
    if (json.valueSets != null) {
      builder.addAllValueSets(json.valueSets);
    }
    if (json.requiredErrorText != null) {
      builder.putAllRequiredErrorText(json.requiredErrorText);
    }
    return builder.build();
  }

  private static ImmutableForm validate(ImmutableForm instance) {
    instance = (ImmutableForm) instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Form} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Form instance
   */
  public static ImmutableForm copyOf(Form instance) {
    if (instance instanceof ImmutableForm) {
      return (ImmutableForm) instance;
    }
    return ImmutableForm.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link ImmutableForm ImmutableForm}.
   * <pre>
   * ImmutableForm.builder()
   *    .id(String | null) // nullable {@link Form#getId() id}
   *    .rev(String | null) // nullable {@link Form#getRev() rev}
   *    .name(String | null) // nullable {@link Form#getName() name}
   *    .putData|putAllData(String =&gt; io.dialob.api.form.FormItem) // {@link Form#getData() data} mappings
   *    .metadata(io.dialob.api.form.Form.Metadata | null) // nullable {@link Form#getMetadata() metadata}
   *    .addVariables|addAllVariables(io.dialob.api.form.Variable) // {@link Form#getVariables() variables} elements
   *    .putNamespaces|putAllNamespaces(String =&gt; io.dialob.api.form.Form) // {@link Form#getNamespaces() namespaces} mappings
   *    .addValueSets|addAllValueSets(io.dialob.api.form.FormValueSet) // {@link Form#getValueSets() valueSets} elements
   *    .putRequiredErrorText|putAllRequiredErrorText(String =&gt; String) // {@link Form#getRequiredErrorText() requiredErrorText} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableForm builder
   */
  public static ImmutableForm.Builder builder() {
    return new ImmutableForm.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableForm ImmutableForm}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Form", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String rev;
    private @javax.annotation.Nullable String name;
    private Map<String, FormItem> data = new LinkedHashMap<String, FormItem>();
    private @javax.annotation.Nullable Form.Metadata metadata;
    private List<Variable> variables = new ArrayList<Variable>();
    private Map<String, Form> namespaces = new LinkedHashMap<String, Form>();
    private List<FormValueSet> valueSets = new ArrayList<FormValueSet>();
    private Map<String, String> requiredErrorText = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableForm} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableForm instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String revValue = instance.getRev();
      if (revValue != null) {
        rev(revValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      putAllData(instance.getData());
      Form.Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      addAllVariables(instance.getVariables());
      putAllNamespaces(instance.getNamespaces());
      addAllValueSets(instance.getValueSets());
      putAllRequiredErrorText(instance.getRequiredErrorText());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Form} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Form instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableForm) {
        return from((ModifiableForm) instance);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String revValue = instance.getRev();
      if (revValue != null) {
        rev(revValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      putAllData(instance.getData());
      Form.Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      addAllVariables(instance.getVariables());
      putAllNamespaces(instance.getNamespaces());
      addAllValueSets(instance.getValueSets());
      putAllRequiredErrorText(instance.getRequiredErrorText());
      return this;
    }

    /**
     * Initializes the value for the {@link Form#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("_id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Form#getRev() rev} attribute.
     * @param rev The value for rev (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("_rev")
    public final Builder rev(@Nullable String rev) {
      this.rev = rev;
      return this;
    }

    /**
     * Initializes the value for the {@link Form#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Put one entry to the {@link Form#getData() data} map.
     * @param key The key in the data map
     * @param value The associated value in the data map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putData(@javax.annotation.Nullable String key, @javax.annotation.Nullable FormItem value) {
      this.data.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Form#getData() data} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putData(Map.Entry<String, ? extends FormItem> entry) {
      String k = entry.getKey();
      FormItem v = entry.getValue();
      this.data.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Form#getData() data} map. Nulls are not permitted
     * @param entries The entries that will be added to the data map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(Map<String, ? extends FormItem> entries) {
      this.data.clear();
      return putAllData(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Form#getData() data} map. Nulls are not permitted
     * @param entries The entries that will be added to the data map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllData(Map<String, ? extends FormItem> entries) {
      for (Map.Entry<String, ? extends FormItem> e : entries.entrySet()) {
        String k = e.getKey();
        FormItem v = e.getValue();
        this.data.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Form#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(Form.Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Adds one element to {@link Form#getVariables() variables} list.
     * @param element A variables element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVariables(@javax.annotation.Nullable Variable element) {
      this.variables.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Form#getVariables() variables} list.
     * @param elements An array of variables elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVariables(Variable... elements) {
      for (Variable element : elements) {
        this.variables.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Form#getVariables() variables} list.
     * @param elements An iterable of variables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("variables")
    public final Builder variables(Iterable<? extends Variable> elements) {
      this.variables.clear();
      return addAllVariables(elements);
    }

    /**
     * Adds elements to {@link Form#getVariables() variables} list.
     * @param elements An iterable of variables elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVariables(Iterable<? extends Variable> elements) {
      for (Variable element : elements) {
        this.variables.add(element);
      }
      return this;
    }

    /**
     * Put one entry to the {@link Form#getNamespaces() namespaces} map.
     * @param key The key in the namespaces map
     * @param value The associated value in the namespaces map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putNamespaces(@javax.annotation.Nullable String key, @javax.annotation.Nullable Form value) {
      this.namespaces.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Form#getNamespaces() namespaces} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putNamespaces(Map.Entry<String, ? extends Form> entry) {
      String k = entry.getKey();
      Form v = entry.getValue();
      this.namespaces.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Form#getNamespaces() namespaces} map. Nulls are not permitted
     * @param entries The entries that will be added to the namespaces map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("namespaces")
    public final Builder namespaces(Map<String, ? extends Form> entries) {
      this.namespaces.clear();
      return putAllNamespaces(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Form#getNamespaces() namespaces} map. Nulls are not permitted
     * @param entries The entries that will be added to the namespaces map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllNamespaces(Map<String, ? extends Form> entries) {
      for (Map.Entry<String, ? extends Form> e : entries.entrySet()) {
        String k = e.getKey();
        Form v = e.getValue();
        this.namespaces.put(k, v);
      }
      return this;
    }

    /**
     * Adds one element to {@link Form#getValueSets() valueSets} list.
     * @param element A valueSets element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValueSets(@javax.annotation.Nullable FormValueSet element) {
      this.valueSets.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Form#getValueSets() valueSets} list.
     * @param elements An array of valueSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValueSets(FormValueSet... elements) {
      for (FormValueSet element : elements) {
        this.valueSets.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Form#getValueSets() valueSets} list.
     * @param elements An iterable of valueSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("valueSets")
    public final Builder valueSets(Iterable<? extends FormValueSet> elements) {
      this.valueSets.clear();
      return addAllValueSets(elements);
    }

    /**
     * Adds elements to {@link Form#getValueSets() valueSets} list.
     * @param elements An iterable of valueSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllValueSets(Iterable<? extends FormValueSet> elements) {
      for (FormValueSet element : elements) {
        this.valueSets.add(element);
      }
      return this;
    }

    /**
     * Put one entry to the {@link Form#getRequiredErrorText() requiredErrorText} map.
     * @param key The key in the requiredErrorText map
     * @param value The associated value in the requiredErrorText map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putRequiredErrorText(@javax.annotation.Nullable String key, @javax.annotation.Nullable String value) {
      this.requiredErrorText.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Form#getRequiredErrorText() requiredErrorText} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putRequiredErrorText(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.requiredErrorText.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Form#getRequiredErrorText() requiredErrorText} map. Nulls are not permitted
     * @param entries The entries that will be added to the requiredErrorText map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requiredErrorText")
    public final Builder requiredErrorText(Map<String, ? extends String> entries) {
      this.requiredErrorText.clear();
      return putAllRequiredErrorText(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Form#getRequiredErrorText() requiredErrorText} map. Nulls are not permitted
     * @param entries The entries that will be added to the requiredErrorText map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllRequiredErrorText(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.requiredErrorText.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableForm ImmutableForm}.
     * @return An immutable instance of Form
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableForm build() {
      return ImmutableForm.validate(new ImmutableForm(
          id,
          rev,
          name,
          createUnmodifiableMap(false, false, data),
          metadata,
          createUnmodifiableList(true, variables),
          createUnmodifiableMap(false, false, namespaces),
          createUnmodifiableList(true, valueSets),
          createUnmodifiableMap(false, false, requiredErrorText)));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
