package io.dialob.api.form;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code FormValueSet}.
 * @see ImmutableFormValueSet
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.form", generator = "Gsons")
public final class GsonAdaptersFormValueSet implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (FormValueSetTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new FormValueSetTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersFormValueSet(FormValueSet)";
  }

  @org.immutables.value.Generated(from = "FormValueSet", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class FormValueSetTypeAdapter extends TypeAdapter<FormValueSet> {
    public final FormValueSetEntry entriesTypeSample = null;
    private final TypeAdapter<FormValueSetEntry> entriesTypeAdapter;

    FormValueSetTypeAdapter(Gson gson) {
      this.entriesTypeAdapter = gson.getAdapter( FormValueSetEntry.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return FormValueSet.class == type.getRawType()
          || ImmutableFormValueSet.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, FormValueSet value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeFormValueSet(out, value);
      }
    }

    @Override
    public FormValueSet read(JsonReader in) throws IOException {
      return readFormValueSet(in);
    }

    private void writeFormValueSet(JsonWriter out, FormValueSet instance)
        throws IOException {
      out.beginObject();
      String idValue = instance.getId();
      if (idValue != null) {
        out.name("id");
        out.value(idValue);
      } else if (out.getSerializeNulls()) {
        out.name("id");
        out.nullValue();
      }
      List<FormValueSetEntry> entriesElements = instance.getEntries();
      if (!entriesElements.isEmpty()) {
        out.name("entries");
        out.beginArray();
        for (FormValueSetEntry e : entriesElements) {
          entriesTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("entries");
        out.beginArray();
        out.endArray();
      }
      out.endObject();
    }

    private  FormValueSet readFormValueSet(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableFormValueSet.Builder builder = ImmutableFormValueSet.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableFormValueSet.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'e':
        if ("entries".equals(attributeName)) {
          readInEntries(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableFormValueSet.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.id(in.nextString());
      }
    }

    private void readInEntries(JsonReader in, ImmutableFormValueSet.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          FormValueSetEntry value = entriesTypeAdapter.read(in);
          builder.addEntries(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        FormValueSetEntry value = entriesTypeAdapter.read(in);
        builder.addEntries(value);
      }
    }
  }
}
