package io.dialob.api.form;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

/**
 * A {@code FormRepository} provides type-safe access for storing and retrieving documents
 * from the MongoDB collection {@code "forms"}.
 */
@Generated(from = "Form", generator = "Repositories")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@ThreadSafe
public class FormRepository extends Repositories.Repository<Form> {
  private static final String DOCUMENT_COLLECTION_NAME = "forms";

  private final Serialization serialization;
  private final Criteria anyCriteria;

  /**
   * Constructs a {@link Form} repository using {@link RepositorySetup configuration}.
   * @param configuration The repository configuration
   */
  public FormRepository(RepositorySetup configuration) {
    super(configuration, DOCUMENT_COLLECTION_NAME, Form.class);
    this.serialization = new Serialization(codecRegistry(), fieldNamingStrategy());
    this.anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());
  }

  /**
   * Inserts a single document into the collection.
   * @param document The form to insert
   * @return A future representing the number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(Form document) {
    return super.doInsert(ImmutableList.of(document));
  }

  /**
   * Insert documents into the collection.
   * @param documents The documents to insert
   * @return A future representing the number of inserted documents if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(Iterable<? extends Form> documents) {
    return super.doInsert(ImmutableList.copyOf(documents));
  }

  /**
   * Finds all documents. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch all} or other operations.
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findAll() {
    return find(criteria());
  }

  /**
   * Find documents by the criteria expressed as a JSON string. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch} or {@link Finder#fetchFirst() fetch} operations.
   * @param jsonCriteria A JSON string for native criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(String jsonCriteria) {
    return new Finder(this, Support.jsonQuery(jsonCriteria));
  }

  /**
   * Find documents by the {@link Form#getId() id} identity attribute. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchFirst() fetch} or {@link Finder#fetchAll() fetchAll} read operations.
   * You can also use {@link Finder#andModifyFirst() modify}, {@link Finder#andReplaceFirst(Form) replace}
   * or {@link Finder#deleteFirst() delete} operations to update / delete the document.
   * @param id The exact {@code id} value
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findById(java.lang.String id) {
    return find(criteria().id(id));
  }

  /**
   * Update or insert a document, matched by the identifier value of the 'id' attribute.
   * @param document The form to upsert
   * @return A future representing the of number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> upsert(Form document) {
    Criteria byId = criteria().id(document.getId());
    return super.doUpsert(byId.constraint, document);
  }

  /**
   * Find a document by the given {@link FormRepository#criteria() criteria}. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch}  operations.
   * You can also use {@link Finder#andModifyFirst() modify} or {@link Finder#deleteFirst() delete}
   * operations to update / delete the document(s).
   * @param criteria The search criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(Criteria criteria) {
    return new Finder(this, criteria.constraint);
  }

  /**
   * The finder object used to proceed with find operations via the
   * {@link Finder#fetchAll()}, {@link Finder#fetchFirst()}, {@link Finder#andModifyFirst()}, or {@link Finder#deleteFirst()} methods.
   * Configure exclusion and sort ordering for results using the family of {@code exclude*()} and {@code orderBy*()} attribute-specific methods.
   * @see FormRepository#find(Criteria)
   */
  @Generated(from = "Form", generator = "Repositories")
  @NotThreadSafe
  public static final class Finder extends Repositories.FinderWithDelete<Form, Finder> {
    private final Serialization serialization;

    private Finder(FormRepository repository, Constraints.ConstraintHost criteria) {
      super(repository);
      this.criteria = criteria;
      this.serialization = repository.serialization;
    }

    /**
     * Order by {@link Form#getId() id} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Form#getId() id} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderById() {
      ordering = ordering.equal(serialization.idName, false, 1);
      return this;
    }

    /**
     * Order by {@link Form#getId() id} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Form#getId() id} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByIdDesceding() {
      ordering = ordering.equal(serialization.idName, false, -1);
      return this;
    }

    /**
     * Order by {@link Form#getRev() rev} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Form#getRev() rev} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByRev() {
      ordering = ordering.equal(serialization.revName, false, 1);
      return this;
    }

    /**
     * Order by {@link Form#getRev() rev} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Form#getRev() rev} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByRevDesceding() {
      ordering = ordering.equal(serialization.revName, false, -1);
      return this;
    }

    /**
     * Order by {@link Form#getName() name} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Form#getName() name} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByName() {
      ordering = ordering.equal(serialization.nameName, false, 1);
      return this;
    }

    /**
     * Order by {@link Form#getName() name} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Form#getName() name} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByNameDesceding() {
      ordering = ordering.equal(serialization.nameName, false, -1);
      return this;
    }

    /**
     * Order by {@link Form#getData() data} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Form#getData() data} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByData() {
      ordering = ordering.equal(serialization.dataName, false, 1);
      return this;
    }

    /**
     * Order by {@link Form#getData() data} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Form#getData() data} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByDataDesceding() {
      ordering = ordering.equal(serialization.dataName, false, -1);
      return this;
    }

    /**
     * Order by {@link Form#getMetadata() metadata} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Form#getMetadata() metadata} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByMetadata() {
      ordering = ordering.equal(serialization.metadataName, false, 1);
      return this;
    }

    /**
     * Order by {@link Form#getMetadata() metadata} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Form#getMetadata() metadata} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByMetadataDesceding() {
      ordering = ordering.equal(serialization.metadataName, false, -1);
      return this;
    }

    /**
     * Order by {@link Form#getVariables() variables} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Form#getVariables() variables} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByVariables() {
      ordering = ordering.equal(serialization.variablesName, false, 1);
      return this;
    }

    /**
     * Order by {@link Form#getVariables() variables} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Form#getVariables() variables} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByVariablesDesceding() {
      ordering = ordering.equal(serialization.variablesName, false, -1);
      return this;
    }

    /**
     * Order by {@link Form#getNamespaces() namespaces} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Form#getNamespaces() namespaces} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByNamespaces() {
      ordering = ordering.equal(serialization.namespacesName, false, 1);
      return this;
    }

    /**
     * Order by {@link Form#getNamespaces() namespaces} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Form#getNamespaces() namespaces} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByNamespacesDesceding() {
      ordering = ordering.equal(serialization.namespacesName, false, -1);
      return this;
    }

    /**
     * Order by {@link Form#getValueSets() valueSets} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Form#getValueSets() valueSets} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByValueSets() {
      ordering = ordering.equal(serialization.valueSetsName, false, 1);
      return this;
    }

    /**
     * Order by {@link Form#getValueSets() valueSets} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Form#getValueSets() valueSets} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByValueSetsDesceding() {
      ordering = ordering.equal(serialization.valueSetsName, false, -1);
      return this;
    }

    /**
     * Order by {@link Form#getRequiredErrorText() requiredErrorText} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Form#getRequiredErrorText() requiredErrorText} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByRequiredErrorText() {
      ordering = ordering.equal(serialization.requiredErrorTextName, false, 1);
      return this;
    }

    /**
     * Order by {@link Form#getRequiredErrorText() requiredErrorText} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Form#getRequiredErrorText() requiredErrorText} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByRequiredErrorTextDesceding() {
      ordering = ordering.equal(serialization.requiredErrorTextName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link Form#getData() data} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeData() {
      exclusion = exclusion.equal(serialization.dataName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link Form#getVariables() variables} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeVariables() {
      exclusion = exclusion.equal(serialization.variablesName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link Form#getNamespaces() namespaces} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeNamespaces() {
      exclusion = exclusion.equal(serialization.namespacesName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link Form#getValueSets() valueSets} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeValueSets() {
      exclusion = exclusion.equal(serialization.valueSetsName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link Form#getRequiredErrorText() requiredErrorText} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeRequiredErrorText() {
      exclusion = exclusion.equal(serialization.requiredErrorTextName, false, -1);
      return this;
    }

    /**
     * Turn a find operation into an atomic {@link DBCollection#findAndModify(DBObject, DBObject, DBObject, boolean, DBObject, boolean, boolean) findAndModify}
     * operation. Use the family of {@code set*()}, {@code unset*()}, {@code add*()}, {@code remove*()}, {@code put*()}m and {@code init*()}
     * (and other attribute-specific) methods to describe the modification.
     * @return A modifier object to complete the {@code findAndModify} operation
     */
    @CheckReturnValue
    public Modifier andModifyFirst() {
      return new Modifier((FormRepository) repository, criteria, ordering, exclusion);
    }

    /**
     * Used to replace in-place existing version of the document
     */
    @CheckReturnValue
    public Replacer andReplaceFirst(Form document) {
      return new Replacer((FormRepository) repository, document, criteria, ordering);
    }
  }

  /**
   * Update the set of {@code "forms"} documents.
   * @param criteria The search criteria for update
   * @return An updater object that will be used to complete the update.
   */
  @CheckReturnValue
  public Updater update(Criteria criteria) {
    return new Updater(this, criteria);
  }

  /**
   * {@link #update(Criteria) Given} the criteria updater describes how to perform
   * update operations on sets of documents.
   */
  @Generated(from = "Form", generator = "Repositories")
  @NotThreadSafe
  public static final class Updater extends Repositories.Updater<Form> {
    private final Serialization serialization;

    private Updater(FormRepository repository, Criteria criteria) {
      super(repository);
      this.criteria = criteria.constraint;
      this.serialization = repository.serialization;
    }

    /**
     * Specify a new value for the {@code id} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code id} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setId(java.lang.String value) {
      setFields = setFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code id} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code id} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initId(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }


    /**
     * Specify a new value for the {@code rev} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code rev} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setRev(java.lang.String value) {
      setFields = setFields.equal(serialization.revName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code rev} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code rev} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initRev(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.revName, false, Support.writable(value));
      return this;
    }


    /**
     * Specify a new value for the {@code name} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code name} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setName(java.lang.String value) {
      setFields = setFields.equal(serialization.nameName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code name} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code name} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initName(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.nameName, false, Support.writable(value));
      return this;
    }


    /**
     * Clear the {@code data} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator, used to reset to empty object
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearData() {
      setFields = setFields.equal(serialization.dataName, false, Support.emptyBsonObject());
      return this;
    }

    /**
     * Put the given key and value into the {@code data} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator for nested objects
     * @param key The key
     * @param value The value
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater putData(java.lang.String key, FormItem value) {
      setFields = setFields.equal(serialization.dataName + "." + key, false, Support.writable(serialization.dataSecondaryEncoder, value));
      return this;
    }

    /**
     * Remove the key to value mapping from the {@code data} map attribute.
     * <p>
     * Corresponds to MongoDB {@code $unset} operator for nested objects
     * @param key The key
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeData(java.lang.String key) {
      unsetFields = unsetFields.equal(serialization.dataName + "." + key, false, 1);
      return this;
    }

    /**
     * Specify a new value for the {@code metadata} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code metadata} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setMetadata(Form.Metadata value) {
      setFields = setFields.equal(serialization.metadataName, false, Support.writable(serialization.metadataEncoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code metadata} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code metadata} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initMetadata(Form.Metadata value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.metadataName, false, Support.writable(serialization.metadataEncoder, value));
      return this;
    }


    /**
     * Clear the {@code variables} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearVariables() {
      unsetFields = unsetFields.equal(serialization.variablesName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code variables} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeVariables(Variable value) {
      pullFields = pullFields.equal(serialization.variablesName, false, Support.writable(serialization.variablesEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code variables} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addVariables(Variable value) {
      pushFields = pushFields.equal(serialization.variablesName, false, Support.writable(serialization.variablesEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code variables} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setVariables(Iterable<? extends Variable> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (Variable value : values) {
         wrappedValues.add(Support.writable(serialization.variablesEncoder, value));
       }

       setFields = setFields.equal(serialization.variablesName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code variables} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllVariables(Iterable<? extends Variable> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Variable value : values) {
        wrappedValues.add(Support.writable(serialization.variablesEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.variablesName, false, v);
      return this;
    }


    /**
     * Clear the {@code namespaces} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator, used to reset to empty object
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearNamespaces() {
      setFields = setFields.equal(serialization.namespacesName, false, Support.emptyBsonObject());
      return this;
    }

    /**
     * Put the given key and value into the {@code namespaces} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator for nested objects
     * @param key The key
     * @param value The value
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater putNamespaces(java.lang.String key, Form value) {
      setFields = setFields.equal(serialization.namespacesName + "." + key, false, Support.writable(serialization.namespacesSecondaryEncoder, value));
      return this;
    }

    /**
     * Remove the key to value mapping from the {@code namespaces} map attribute.
     * <p>
     * Corresponds to MongoDB {@code $unset} operator for nested objects
     * @param key The key
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeNamespaces(java.lang.String key) {
      unsetFields = unsetFields.equal(serialization.namespacesName + "." + key, false, 1);
      return this;
    }

    /**
     * Clear the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearValueSets() {
      unsetFields = unsetFields.equal(serialization.valueSetsName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeValueSets(FormValueSet value) {
      pullFields = pullFields.equal(serialization.valueSetsName, false, Support.writable(serialization.valueSetsEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addValueSets(FormValueSet value) {
      pushFields = pushFields.equal(serialization.valueSetsName, false, Support.writable(serialization.valueSetsEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code valueSets} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setValueSets(Iterable<? extends FormValueSet> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (FormValueSet value : values) {
         wrappedValues.add(Support.writable(serialization.valueSetsEncoder, value));
       }

       setFields = setFields.equal(serialization.valueSetsName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllValueSets(Iterable<? extends FormValueSet> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (FormValueSet value : values) {
        wrappedValues.add(Support.writable(serialization.valueSetsEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.valueSetsName, false, v);
      return this;
    }


    /**
     * Clear the {@code requiredErrorText} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator, used to reset to empty object
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearRequiredErrorText() {
      setFields = setFields.equal(serialization.requiredErrorTextName, false, Support.emptyBsonObject());
      return this;
    }

    /**
     * Put the given key and value into the {@code requiredErrorText} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator for nested objects
     * @param key The key
     * @param value The value
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater putRequiredErrorText(java.lang.String key, java.lang.String value) {
      setFields = setFields.equal(serialization.requiredErrorTextName + "." + key, false, Support.writable(value));
      return this;
    }

    /**
     * Remove the key to value mapping from the {@code requiredErrorText} map attribute.
     * <p>
     * Corresponds to MongoDB {@code $unset} operator for nested objects
     * @param key The key
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeRequiredErrorText(java.lang.String key) {
      unsetFields = unsetFields.equal(serialization.requiredErrorTextName + "." + key, false, 1);
      return this;
    }
  }

  @Generated(from = "Form", generator = "Repositories")
  @NotThreadSafe
  public static final class Modifier extends Repositories.Modifier<Form, Modifier> {
    private final Serialization serialization;

    private Modifier(
        FormRepository repository,
        Constraints.ConstraintHost criteria,
        Constraints.Constraint ordering,
        Constraints.Constraint exclusion) {
      super(repository);
      this.serialization = repository.serialization;
      this.criteria = criteria;
      this.ordering = ordering;
      this.exclusion = exclusion;
    }

    /**
     * Specify a new value for the {@code id} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code id} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setId(java.lang.String value) {
      setFields = setFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code id} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code id} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initId(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }


    /**
     * Specify a new value for the {@code rev} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code rev} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setRev(java.lang.String value) {
      setFields = setFields.equal(serialization.revName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code rev} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code rev} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initRev(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.revName, false, Support.writable(value));
      return this;
    }


    /**
     * Specify a new value for the {@code name} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code name} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setName(java.lang.String value) {
      setFields = setFields.equal(serialization.nameName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code name} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code name} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initName(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.nameName, false, Support.writable(value));
      return this;
    }


    /**
     * Clear the {@code data} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator, used to reset to empty object
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearData() {
      setFields = setFields.equal(serialization.dataName, false, Support.emptyBsonObject());
      return this;
    }

    /**
     * Put the given key and value into the {@code data} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator for nested objects
     * @param key The key
     * @param value The value
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier putData(java.lang.String key, FormItem value) {
      setFields = setFields.equal(serialization.dataName + "." + key, false, Support.writable(serialization.dataSecondaryEncoder, value));
      return this;
    }

    /**
     * Remove the key to value mapping from the {@code data} map attribute.
     * <p>
     * Corresponds to MongoDB {@code $unset} operator for nested objects
     * @param key The key
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeData(java.lang.String key) {
      unsetFields = unsetFields.equal(serialization.dataName + "." + key, false, 1);
      return this;
    }

    /**
     * Specify a new value for the {@code metadata} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code metadata} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setMetadata(Form.Metadata value) {
      setFields = setFields.equal(serialization.metadataName, false, Support.writable(serialization.metadataEncoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code metadata} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code metadata} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initMetadata(Form.Metadata value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.metadataName, false, Support.writable(serialization.metadataEncoder, value));
      return this;
    }


    /**
     * Clear the {@code variables} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearVariables() {
      unsetFields = unsetFields.equal(serialization.variablesName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code variables} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeVariables(Variable value) {
      pullFields = pullFields.equal(serialization.variablesName, false, Support.writable(serialization.variablesEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code variables} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addVariables(Variable value) {
      pushFields = pushFields.equal(serialization.variablesName, false, Support.writable(serialization.variablesEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code variables} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setVariables(Iterable<? extends Variable> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (Variable value : values) {
         wrappedValues.add(Support.writable(serialization.variablesEncoder, value));
       }

       setFields = setFields.equal(serialization.variablesName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code variables} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllVariables(Iterable<? extends Variable> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Variable value : values) {
        wrappedValues.add(Support.writable(serialization.variablesEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.variablesName, false, v);
      return this;
    }


    /**
     * Clear the {@code namespaces} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator, used to reset to empty object
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearNamespaces() {
      setFields = setFields.equal(serialization.namespacesName, false, Support.emptyBsonObject());
      return this;
    }

    /**
     * Put the given key and value into the {@code namespaces} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator for nested objects
     * @param key The key
     * @param value The value
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier putNamespaces(java.lang.String key, Form value) {
      setFields = setFields.equal(serialization.namespacesName + "." + key, false, Support.writable(serialization.namespacesSecondaryEncoder, value));
      return this;
    }

    /**
     * Remove the key to value mapping from the {@code namespaces} map attribute.
     * <p>
     * Corresponds to MongoDB {@code $unset} operator for nested objects
     * @param key The key
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeNamespaces(java.lang.String key) {
      unsetFields = unsetFields.equal(serialization.namespacesName + "." + key, false, 1);
      return this;
    }

    /**
     * Clear the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearValueSets() {
      unsetFields = unsetFields.equal(serialization.valueSetsName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeValueSets(FormValueSet value) {
      pullFields = pullFields.equal(serialization.valueSetsName, false, Support.writable(serialization.valueSetsEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addValueSets(FormValueSet value) {
      pushFields = pushFields.equal(serialization.valueSetsName, false, Support.writable(serialization.valueSetsEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code valueSets} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setValueSets(Iterable<? extends FormValueSet> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (FormValueSet value : values) {
         wrappedValues.add(Support.writable(serialization.valueSetsEncoder, value));
       }

       setFields = setFields.equal(serialization.valueSetsName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllValueSets(Iterable<? extends FormValueSet> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (FormValueSet value : values) {
        wrappedValues.add(Support.writable(serialization.valueSetsEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.valueSetsName, false, v);
      return this;
    }


    /**
     * Clear the {@code requiredErrorText} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator, used to reset to empty object
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearRequiredErrorText() {
      setFields = setFields.equal(serialization.requiredErrorTextName, false, Support.emptyBsonObject());
      return this;
    }

    /**
     * Put the given key and value into the {@code requiredErrorText} map attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator for nested objects
     * @param key The key
     * @param value The value
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier putRequiredErrorText(java.lang.String key, java.lang.String value) {
      setFields = setFields.equal(serialization.requiredErrorTextName + "." + key, false, Support.writable(value));
      return this;
    }

    /**
     * Remove the key to value mapping from the {@code requiredErrorText} map attribute.
     * <p>
     * Corresponds to MongoDB {@code $unset} operator for nested objects
     * @param key The key
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeRequiredErrorText(java.lang.String key) {
      unsetFields = unsetFields.equal(serialization.requiredErrorTextName + "." + key, false, 1);
      return this;
    }
  }

  @Generated(from = "Form", generator = "Repositories")
  @NotThreadSafe
  public static final class Replacer extends Repositories.Replacer<Form, Replacer> {
    protected Replacer(FormRepository repository, Form document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
      super(repository, document, criteria, ordering);
    }
  }

  /**
   * {@link DBCollection#createIndex(DBObject, DBObject) Ensure an index} on collection forms by one or
   * more attributes using the family of {@code with*()} attribute-specific methods.
   * While indexes will usually be maintained by special administration scripts, for simple cases it is convenient
   * to ensure an index on application startup.
   * @see Indexer#named(String)
   * @see Indexer#unique()
   * @return An indexer object to be completed with the {@link Indexer#ensure()} operation.
   */
  @CheckReturnValue
  public Indexer index() {
    return new Indexer(this);
  }

  /**
   * An indexer used to create an index on the {@code "forms"} collection if it does not exist by one or more attributes.
   * @see DBCollection#createIndex(DBObject, DBObject)
   */
  @Generated(from = "Form", generator = "Repositories")
  @NotThreadSafe
  public static final class Indexer extends Repositories.Indexer<Form, Indexer> {
    private final Serialization serialization;

    private Indexer(FormRepository repository) {
      super(repository);
      this.serialization = repository.serialization;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getId() id}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withId() {
      fields = fields.equal(serialization.idName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getId() id}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withIdDesceding() {
      fields = fields.equal(serialization.idName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getRev() rev}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withRev() {
      fields = fields.equal(serialization.revName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getRev() rev}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withRevDesceding() {
      fields = fields.equal(serialization.revName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getName() name}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withName() {
      fields = fields.equal(serialization.nameName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getName() name}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withNameDesceding() {
      fields = fields.equal(serialization.nameName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getData() data}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withData() {
      fields = fields.equal(serialization.dataName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getData() data}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withDataDesceding() {
      fields = fields.equal(serialization.dataName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getMetadata() metadata}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withMetadata() {
      fields = fields.equal(serialization.metadataName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getMetadata() metadata}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withMetadataDesceding() {
      fields = fields.equal(serialization.metadataName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getVariables() variables}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withVariables() {
      fields = fields.equal(serialization.variablesName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getVariables() variables}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withVariablesDesceding() {
      fields = fields.equal(serialization.variablesName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getNamespaces() namespaces}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withNamespaces() {
      fields = fields.equal(serialization.namespacesName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getNamespaces() namespaces}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withNamespacesDesceding() {
      fields = fields.equal(serialization.namespacesName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getValueSets() valueSets}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withValueSets() {
      fields = fields.equal(serialization.valueSetsName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getValueSets() valueSets}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withValueSetsDesceding() {
      fields = fields.equal(serialization.valueSetsName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getRequiredErrorText() requiredErrorText}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withRequiredErrorText() {
      fields = fields.equal(serialization.requiredErrorTextName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Form#getRequiredErrorText() requiredErrorText}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withRequiredErrorTextDesceding() {
      fields = fields.equal(serialization.requiredErrorTextName, false, -1);
      return this;
    }
  }

  /**
   * Search criteria.
   * Returns an initial object to create criteria by invoking methods that describe attribute specific constraints.
   * @return An empty immutable criteria
   */
  public Criteria criteria() {
    return anyCriteria;
  }

  @Beta
  Bson toBson(Criteria criteria) {
    return Support.convertToBson(criteria.constraint);
  }

  /**
   * {@code FormRepository.Criteria} is a Form document search query.
   * Call methods on the criteria to add constraints for search queries.
   */
  @Generated(from = "Form", generator = "Repositories")
  @Immutable
  @SuppressWarnings("unchecked")
  public static final class Criteria extends Repositories.Criteria {
    private final Constraints.Constraint constraint;
    private final Serialization serialization;

    Criteria(Serialization serialization, Constraints.Constraint constraint) {
      this.constraint = constraint;
      this.serialization = serialization;
    }

    public Criteria id(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.idName, false, Support.writable(value)));
    }

    public Criteria idNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.idName, true, Support.writable(value)));
    }

    public Criteria idIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, false, wrappedValues));
    }

    public Criteria idIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, false, values));
    }

    public Criteria idNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, true, wrappedValues));
    }

    public Criteria idNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, true, values));
    }

    public Criteria idStartsWith(String prefix) {
      return new Criteria(serialization, constraint.match(serialization.idName, false, Constraints.prefixPatternOf(prefix)));
    }

    public Criteria idMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.idName, false, pattern));
    }

    public Criteria idNotMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.idName, true, pattern));
    }

    public Criteria idGreaterThan(java.lang.String lower) {
      return idIn(Range.greaterThan(lower));
    }

    public Criteria idLessThan(java.lang.String upper) {
      return idIn(Range.lessThan(upper));
    }

    public Criteria idAtMost(java.lang.String upperInclusive) {
      return idIn(Range.atMost(upperInclusive));
    }

    public Criteria idAtLeast(java.lang.String lowerInclusive) {
      return idIn(Range.atLeast(lowerInclusive));
    }

    public Criteria idIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.idName, false, Support.writable(range)));
    }

    public Criteria idNotIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.idName, true, Support.writable(range)));
    }

    public Criteria rev(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.revName, false, Support.writable(value)));
    }

    public Criteria revNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.revName, true, Support.writable(value)));
    }

    public Criteria revIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.revName, false, wrappedValues));
    }

    public Criteria revIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.revName, false, values));
    }

    public Criteria revNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.revName, true, wrappedValues));
    }

    public Criteria revNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.revName, true, values));
    }

    public Criteria revStartsWith(String prefix) {
      return new Criteria(serialization, constraint.match(serialization.revName, false, Constraints.prefixPatternOf(prefix)));
    }

    public Criteria revMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.revName, false, pattern));
    }

    public Criteria revNotMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.revName, true, pattern));
    }

    public Criteria revGreaterThan(java.lang.String lower) {
      return revIn(Range.greaterThan(lower));
    }

    public Criteria revLessThan(java.lang.String upper) {
      return revIn(Range.lessThan(upper));
    }

    public Criteria revAtMost(java.lang.String upperInclusive) {
      return revIn(Range.atMost(upperInclusive));
    }

    public Criteria revAtLeast(java.lang.String lowerInclusive) {
      return revIn(Range.atLeast(lowerInclusive));
    }

    public Criteria revIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.revName, false, Support.writable(range)));
    }

    public Criteria revNotIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.revName, true, Support.writable(range)));
    }

    public Criteria name(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.nameName, false, Support.writable(value)));
    }

    public Criteria nameNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.nameName, true, Support.writable(value)));
    }

    public Criteria nameIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.nameName, false, wrappedValues));
    }

    public Criteria nameIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.nameName, false, values));
    }

    public Criteria nameNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.nameName, true, wrappedValues));
    }

    public Criteria nameNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.nameName, true, values));
    }

    public Criteria nameStartsWith(String prefix) {
      return new Criteria(serialization, constraint.match(serialization.nameName, false, Constraints.prefixPatternOf(prefix)));
    }

    public Criteria nameMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.nameName, false, pattern));
    }

    public Criteria nameNotMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.nameName, true, pattern));
    }

    public Criteria nameGreaterThan(java.lang.String lower) {
      return nameIn(Range.greaterThan(lower));
    }

    public Criteria nameLessThan(java.lang.String upper) {
      return nameIn(Range.lessThan(upper));
    }

    public Criteria nameAtMost(java.lang.String upperInclusive) {
      return nameIn(Range.atMost(upperInclusive));
    }

    public Criteria nameAtLeast(java.lang.String lowerInclusive) {
      return nameIn(Range.atLeast(lowerInclusive));
    }

    public Criteria nameIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.nameName, false, Support.writable(range)));
    }

    public Criteria nameNotIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.nameName, true, Support.writable(range)));
    }

    public Criteria data(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.dataName, false, Support.writable(value)));
    }

    public Criteria dataNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.dataName, true, Support.writable(value)));
    }

    public Criteria dataIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.dataName, false, wrappedValues));
    }

    public Criteria dataIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.dataName, false, values));
    }

    public Criteria dataNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.dataName, true, wrappedValues));
    }

    public Criteria dataNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.dataName, true, values));
    }

    public Criteria metadata(Form.Metadata value) {
      return new Criteria(serialization, constraint.equal(serialization.metadataName, false, Support.writable(serialization.metadataEncoder, value)));
    }

    public Criteria metadataNot(Form.Metadata value) {
      return new Criteria(serialization, constraint.equal(serialization.metadataName, true, Support.writable(serialization.metadataEncoder, value)));
    }

    public Criteria metadataIn(Iterable<Form.Metadata> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Form.Metadata value : values) {
        wrappedValues.add(Support.writable(serialization.metadataEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.metadataName, false, wrappedValues));
    }

    public Criteria metadataIn(Form.Metadata first, Form.Metadata second, Form.Metadata... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.metadataEncoder, first));
      values.add(Support.writable(serialization.metadataEncoder, second));
      for (Form.Metadata value : rest) {
        values.add(Support.writable(serialization.metadataEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.metadataName, false, values));
    }

    public Criteria metadataNotIn(Iterable<Form.Metadata> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Form.Metadata value : values) {
        wrappedValues.add(Support.writable(serialization.metadataEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.metadataName, true, wrappedValues));
    }

    public Criteria metadataNotIn(Form.Metadata first, Form.Metadata second, Form.Metadata... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.metadataEncoder, first));
      values.add(Support.writable(serialization.metadataEncoder, second));
      for (Form.Metadata value : rest) {
        values.add(Support.writable(serialization.metadataEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.metadataName, true, values));
    }

    public Criteria variablesEmpty() {
      return new Criteria(serialization, constraint.size(serialization.variablesName, false, 0));
    }

    public Criteria variablesNonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.variablesName, true, 0));
    }

    public Criteria variablesSize(int size) {
      return new Criteria(serialization, constraint.size(serialization.variablesName, false, size));
    }

    public Criteria variablesContains(Variable value) {
      return new Criteria(serialization, constraint.equal(serialization.variablesName, false, Support.writable(serialization.variablesEncoder, value)));
    }

    public Criteria variablesContainsAll(Iterable<Variable> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Variable value : values) {
        wrappedValues.add(Support.writable(serialization.variablesEncoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.variablesName, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria namespaces(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.namespacesName, false, Support.writable(value)));
    }

    public Criteria namespacesNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.namespacesName, true, Support.writable(value)));
    }

    public Criteria namespacesIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.namespacesName, false, wrappedValues));
    }

    public Criteria namespacesIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.namespacesName, false, values));
    }

    public Criteria namespacesNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.namespacesName, true, wrappedValues));
    }

    public Criteria namespacesNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.namespacesName, true, values));
    }

    public Criteria valueSetsEmpty() {
      return new Criteria(serialization, constraint.size(serialization.valueSetsName, false, 0));
    }

    public Criteria valueSetsNonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.valueSetsName, true, 0));
    }

    public Criteria valueSetsSize(int size) {
      return new Criteria(serialization, constraint.size(serialization.valueSetsName, false, size));
    }

    public Criteria valueSetsContains(FormValueSet value) {
      return new Criteria(serialization, constraint.equal(serialization.valueSetsName, false, Support.writable(serialization.valueSetsEncoder, value)));
    }

    public Criteria valueSetsContainsAll(Iterable<FormValueSet> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (FormValueSet value : values) {
        wrappedValues.add(Support.writable(serialization.valueSetsEncoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.valueSetsName, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria requiredErrorText(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.requiredErrorTextName, false, Support.writable(value)));
    }

    public Criteria requiredErrorTextNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.requiredErrorTextName, true, Support.writable(value)));
    }

    public Criteria requiredErrorTextIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.requiredErrorTextName, false, wrappedValues));
    }

    public Criteria requiredErrorTextIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.requiredErrorTextName, false, values));
    }

    public Criteria requiredErrorTextNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.requiredErrorTextName, true, wrappedValues));
    }

    public Criteria requiredErrorTextNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.requiredErrorTextName, true, values));
    }

    @Override
    public Criteria or() {
      return new Criteria(serialization, constraint.disjunction());
    }

    public Criteria with(Criteria criteria) {
      return new Criteria(serialization, criteria.constraint.accept(constraint));
    }

    @Override
    public String toString() {
      return "FormRepository.criteria(" + Support.stringify(constraint) + ")";
    }
  }

  @Generated(from = "Form", generator = "Repositories")
  private static class Serialization {
    final Encoder<FormItem> dataSecondaryEncoder;
    final Encoder<Form.Metadata> metadataEncoder;
    final Encoder<Variable> variablesEncoder;
    final Encoder<Form> namespacesSecondaryEncoder;
    final Encoder<FormValueSet> valueSetsEncoder;
    final CodecRegistry registry;
    final String idName;
    final String revName;
    final String nameName;
    final String dataName;
    final String metadataName;
    final String variablesName;
    final String namespacesName;
    final String valueSetsName;
    final String requiredErrorTextName;

    Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
      this.registry = registry;
      this.dataSecondaryEncoder = this.registry.get(FormItem.class);
      this.metadataEncoder = this.registry.get(Form.Metadata.class);
      this.variablesEncoder = this.registry.get(Variable.class);
      this.namespacesSecondaryEncoder = this.registry.get(Form.class);
      this.valueSetsEncoder = this.registry.get(FormValueSet.class);
      this.idName = "_id";
      this.revName = "_rev";
      this.nameName = translateName(fieldNamingStrategy, "name");
      this.dataName = translateName(fieldNamingStrategy, "data");
      this.metadataName = translateName(fieldNamingStrategy, "metadata");
      this.variablesName = translateName(fieldNamingStrategy, "variables");
      this.namespacesName = translateName(fieldNamingStrategy, "namespaces");
      this.valueSetsName = translateName(fieldNamingStrategy, "valueSets");
      this.requiredErrorTextName = translateName(fieldNamingStrategy, "requiredErrorText");
    }

    @Generated(from = "Form", generator = "Repositories")
    static final class FormNamingFields {
      public java.lang.String id;
      public java.lang.String rev;
      public java.lang.String name;
      public Map<java.lang.String, FormItem> data;
      public Form.Metadata metadata;
      public List<Variable> variables;
      public Map<java.lang.String, Form> namespaces;
      public List<FormValueSet> valueSets;
      public Map<java.lang.String, java.lang.String> requiredErrorText;
    }

    private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
      try {
        return fieldNamingStrategy.translateName(
            FormNamingFields.class.getField(fieldName));
      } catch (NoSuchFieldException noSuchField) {
        throw new AssertionError(noSuchField);
      }
    }
  }
}
