/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableError;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Error", generator="Modifiables")
@NotThreadSafe
public final class ModifiableError
implements Error {
    private static final long INIT_BIT_ID = 1L;
    private long initBits = 1L;
    private String id;
    private String code;
    private String description;

    private ModifiableError() {
    }

    public static ModifiableError create(String id, String code, String description) {
        return new ModifiableError().setId(id).setCode(code).setDescription(description);
    }

    public static ModifiableError create() {
        return new ModifiableError();
    }

    @Override
    @JsonProperty(value="id")
    public final String getId() {
        if (!this.idIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.id;
    }

    @Override
    @JsonProperty(value="code")
    public final String getCode() {
        return this.code;
    }

    @Override
    @JsonProperty(value="description")
    public final String getDescription() {
        return this.description;
    }

    public ModifiableError clear() {
        this.initBits = 1L;
        this.id = null;
        this.code = null;
        this.description = null;
        return this;
    }

    public ModifiableError from(Error instance) {
        String descriptionValue;
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableError) {
            this.from((ModifiableError)instance);
            return this;
        }
        this.setId(instance.getId());
        String codeValue = instance.getCode();
        if (codeValue != null) {
            this.setCode(codeValue);
        }
        if ((descriptionValue = instance.getDescription()) != null) {
            this.setDescription(descriptionValue);
        }
        return this;
    }

    public ModifiableError from(ModifiableError instance) {
        String descriptionValue;
        String codeValue;
        Objects.requireNonNull(instance, "instance");
        if (instance.idIsSet()) {
            this.setId(instance.getId());
        }
        if ((codeValue = instance.getCode()) != null) {
            this.setCode(codeValue);
        }
        if ((descriptionValue = instance.getDescription()) != null) {
            this.setDescription(descriptionValue);
        }
        return this;
    }

    public ModifiableError setId(String id) {
        this.id = Objects.requireNonNull(id, "id");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ModifiableError setCode(String code) {
        this.code = code;
        return this;
    }

    public ModifiableError setDescription(String description) {
        this.description = description;
        return this;
    }

    public final boolean idIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final ModifiableError unsetId() {
        this.initBits |= 1L;
        this.id = null;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.idIsSet()) {
            attributes.add("id");
        }
        return "Error is not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutableError toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableError.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableError)) {
            return false;
        }
        ModifiableError other = (ModifiableError)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableError another) {
        return this.id.equals(another.id) && Objects.equals(this.code, another.code) && Objects.equals(this.description, another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.code);
        h += (h << 5) + Objects.hashCode(this.description);
        return h;
    }

    public String toString() {
        return "ModifiableError{id=" + (this.idIsSet() ? this.getId() : "?") + ", code=" + this.getCode() + ", description=" + this.getDescription() + "}";
    }
}

