/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.proto;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.proto.ImmutableValueSetEntry;
import io.dialob.api.proto.ValueSetEntry;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.proto", generator="Gsons")
public final class GsonAdaptersValueSetEntry
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ValueSetEntryTypeAdapter.adapts(type)) {
            return new ValueSetEntryTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersValueSetEntry(ValueSetEntry)";
    }

    @Generated(from="ValueSetEntry", generator="Gsons")
    private static class ValueSetEntryTypeAdapter
    extends TypeAdapter<ValueSetEntry> {
        ValueSetEntryTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return ValueSetEntry.class == type.getRawType() || ImmutableValueSetEntry.class == type.getRawType();
        }

        public void write(JsonWriter out, ValueSetEntry value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeValueSetEntry(out, value);
            }
        }

        public ValueSetEntry read(JsonReader in) throws IOException {
            return this.readValueSetEntry(in);
        }

        private void writeValueSetEntry(JsonWriter out, ValueSetEntry instance) throws IOException {
            out.beginObject();
            out.name("key");
            out.value(instance.getKey());
            String valueValue = instance.getValue();
            if (valueValue != null) {
                out.name("value");
                out.value(valueValue);
            } else if (out.getSerializeNulls()) {
                out.name("value");
                out.nullValue();
            }
            out.endObject();
        }

        private ValueSetEntry readValueSetEntry(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableValueSetEntry.Builder builder = ImmutableValueSetEntry.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableValueSetEntry.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'k': {
                    if (!"key".equals(attributeName)) break;
                    this.readInKey(in, builder);
                    return;
                }
                case 'v': {
                    if (!"value".equals(attributeName)) break;
                    this.readInValue(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInKey(JsonReader in, ImmutableValueSetEntry.Builder builder) throws IOException {
            builder.key(in.nextString());
        }

        private void readInValue(JsonReader in, ImmutableValueSetEntry.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.value(in.nextString());
            }
        }
    }
}

