/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.proto;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.proto.Action;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Error;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.proto", generator="Gsons")
public final class GsonAdaptersAction
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ActionTypeAdapter.adapts(type)) {
            return new ActionTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersAction(Action)";
    }

    @Generated(from="Action", generator="Gsons")
    private static class ActionTypeAdapter
    extends TypeAdapter<Action> {
        public final Action.Type typeTypeSample = null;
        public final ActionItem itemTypeSample = null;
        public final Error errorTypeSample = null;
        public final Object answerTypeSample = null;
        public final Object valueTypeSample = null;
        public final ValueSet valueSetTypeSample = null;
        public final Boolean serverEventTypeSample = null;
        private final TypeAdapter<Action.Type> typeTypeAdapter;
        private final TypeAdapter<ActionItem> itemTypeAdapter;
        private final TypeAdapter<Error> errorTypeAdapter;
        private final TypeAdapter<Object> answerTypeAdapter;
        private final TypeAdapter<Object> valueTypeAdapter;
        private final TypeAdapter<ValueSet> valueSetTypeAdapter;
        private final TypeAdapter<Boolean> serverEventTypeAdapter;

        ActionTypeAdapter(Gson gson) {
            this.typeTypeAdapter = gson.getAdapter(Action.Type.class);
            this.itemTypeAdapter = gson.getAdapter(ActionItem.class);
            this.errorTypeAdapter = gson.getAdapter(Error.class);
            this.answerTypeAdapter = gson.getAdapter(Object.class);
            this.valueTypeAdapter = gson.getAdapter(Object.class);
            this.valueSetTypeAdapter = gson.getAdapter(ValueSet.class);
            this.serverEventTypeAdapter = gson.getAdapter(Boolean.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Action.class == type.getRawType() || ImmutableAction.class == type.getRawType();
        }

        public void write(JsonWriter out, Action value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeAction(out, value);
            }
        }

        public Action read(JsonReader in) throws IOException {
            return this.readAction(in);
        }

        private void writeAction(JsonWriter out, Action instance) throws IOException {
            out.beginObject();
            out.name("type");
            this.typeTypeAdapter.write(out, (Object)instance.getType());
            String idValue = instance.getId();
            if (idValue != null) {
                out.name("id");
                out.value(idValue);
            } else if (out.getSerializeNulls()) {
                out.name("id");
                out.nullValue();
            }
            String messageValue = instance.getMessage();
            if (messageValue != null) {
                out.name("message");
                out.value(messageValue);
            } else if (out.getSerializeNulls()) {
                out.name("message");
                out.nullValue();
            }
            String traceValue = instance.getTrace();
            if (traceValue != null) {
                out.name("trace");
                out.value(traceValue);
            } else if (out.getSerializeNulls()) {
                out.name("trace");
                out.nullValue();
            }
            ActionItem itemValue = instance.getItem();
            if (itemValue != null) {
                out.name("item");
                this.itemTypeAdapter.write(out, (Object)itemValue);
            } else if (out.getSerializeNulls()) {
                out.name("item");
                out.nullValue();
            }
            Error errorValue = instance.getError();
            if (errorValue != null) {
                out.name("error");
                this.errorTypeAdapter.write(out, (Object)errorValue);
            } else if (out.getSerializeNulls()) {
                out.name("error");
                out.nullValue();
            }
            Object answerValue = instance.getAnswer();
            if (answerValue != null) {
                out.name("answer");
                this.answerTypeAdapter.write(out, answerValue);
            } else if (out.getSerializeNulls()) {
                out.name("answer");
                out.nullValue();
            }
            List<String> idsElements = instance.getIds();
            if (idsElements != null && !idsElements.isEmpty()) {
                out.name("ids");
                out.beginArray();
                for (String e : idsElements) {
                    out.value(e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("ids");
                if (idsElements == null) {
                    out.nullValue();
                } else {
                    out.beginArray();
                    out.endArray();
                }
            }
            Object valueValue = instance.getValue();
            if (valueValue != null) {
                out.name("value");
                this.valueTypeAdapter.write(out, valueValue);
            } else if (out.getSerializeNulls()) {
                out.name("value");
                out.nullValue();
            }
            ValueSet valueSetValue = instance.getValueSet();
            if (valueSetValue != null) {
                out.name("valueSet");
                this.valueSetTypeAdapter.write(out, (Object)valueSetValue);
            } else if (out.getSerializeNulls()) {
                out.name("valueSet");
                out.nullValue();
            }
            Boolean serverEventValue = instance.getServerEvent();
            if (serverEventValue != null) {
                out.name("serverEvent");
                this.serverEventTypeAdapter.write(out, (Object)serverEventValue);
            } else if (out.getSerializeNulls()) {
                out.name("serverEvent");
                out.nullValue();
            }
            String resourceIdValue = instance.getResourceId();
            if (resourceIdValue != null) {
                out.name("resourceId");
                out.value(resourceIdValue);
            } else if (out.getSerializeNulls()) {
                out.name("resourceId");
                out.nullValue();
            }
            out.endObject();
        }

        private Action readAction(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableAction.Builder builder = ImmutableAction.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 't': {
                    if ("type".equals(attributeName)) {
                        this.readInType(in, builder);
                        return;
                    }
                    if (!"trace".equals(attributeName)) break;
                    this.readInTrace(in, builder);
                    return;
                }
                case 'i': {
                    if ("id".equals(attributeName)) {
                        this.readInId(in, builder);
                        return;
                    }
                    if ("item".equals(attributeName)) {
                        this.readInItem(in, builder);
                        return;
                    }
                    if (!"ids".equals(attributeName)) break;
                    this.readInIds(in, builder);
                    return;
                }
                case 'm': {
                    if (!"message".equals(attributeName)) break;
                    this.readInMessage(in, builder);
                    return;
                }
                case 'e': {
                    if (!"error".equals(attributeName)) break;
                    this.readInError(in, builder);
                    return;
                }
                case 'a': {
                    if (!"answer".equals(attributeName)) break;
                    this.readInAnswer(in, builder);
                    return;
                }
                case 'v': {
                    if ("value".equals(attributeName)) {
                        this.readInValue(in, builder);
                        return;
                    }
                    if (!"valueSet".equals(attributeName)) break;
                    this.readInValueSet(in, builder);
                    return;
                }
                case 's': {
                    if (!"serverEvent".equals(attributeName)) break;
                    this.readInServerEvent(in, builder);
                    return;
                }
                case 'r': {
                    if (!"resourceId".equals(attributeName)) break;
                    this.readInResourceId(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInType(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            Action.Type value = (Action.Type)((Object)this.typeTypeAdapter.read(in));
            builder.type(value);
        }

        private void readInId(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.id(in.nextString());
            }
        }

        private void readInMessage(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.message(in.nextString());
            }
        }

        private void readInTrace(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.trace(in.nextString());
            }
        }

        private void readInItem(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ActionItem value = (ActionItem)this.itemTypeAdapter.read(in);
                builder.item(value);
            }
        }

        private void readInError(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Error value = (Error)this.errorTypeAdapter.read(in);
                builder.error(value);
            }
        }

        private void readInAnswer(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Object value = this.answerTypeAdapter.read(in);
                builder.answer(value);
            }
        }

        private void readInIds(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                boolean empty = true;
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    while (in.hasNext()) {
                        builder.addIds(in.nextString());
                        empty = false;
                    }
                    in.endArray();
                } else if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                } else {
                    builder.addIds(in.nextString());
                    empty = false;
                }
                if (empty) {
                    builder.addAllIds(Collections.emptyList());
                }
            }
        }

        private void readInValue(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Object value = this.valueTypeAdapter.read(in);
                builder.value(value);
            }
        }

        private void readInValueSet(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ValueSet value = (ValueSet)this.valueSetTypeAdapter.read(in);
                builder.valueSet(value);
            }
        }

        private void readInServerEvent(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Boolean value = (Boolean)this.serverEventTypeAdapter.read(in);
                builder.serverEvent(value);
            }
        }

        private void readInResourceId(JsonReader in, ImmutableAction.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.resourceId(in.nextString());
            }
        }
    }
}

