/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.form.ImmutableValidation;
import io.dialob.api.form.Validation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Validation", generator="Modifiables")
@NotThreadSafe
public final class ModifiableValidation
implements Validation {
    private final Map<String, String> message = new LinkedHashMap<String, String>();
    private String rule;

    private ModifiableValidation() {
    }

    public static ModifiableValidation create() {
        return new ModifiableValidation();
    }

    @Override
    @JsonProperty(value="message")
    public final Map<String, String> getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty(value="rule")
    public final String getRule() {
        return this.rule;
    }

    public ModifiableValidation clear() {
        this.message.clear();
        this.rule = null;
        return this;
    }

    public ModifiableValidation from(Validation instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableValidation) {
            this.from((ModifiableValidation)instance);
            return this;
        }
        this.putAllMessage(instance.getMessage());
        String ruleValue = instance.getRule();
        if (ruleValue != null) {
            this.setRule(ruleValue);
        }
        return this;
    }

    public ModifiableValidation from(ModifiableValidation instance) {
        Objects.requireNonNull(instance, "instance");
        this.putAllMessage(instance.getMessage());
        String ruleValue = instance.getRule();
        if (ruleValue != null) {
            this.setRule(ruleValue);
        }
        return this;
    }

    public ModifiableValidation putMessage(String key, String value) {
        this.message.put(Objects.requireNonNull(key, "message key"), Objects.requireNonNull(value, "message value"));
        return this;
    }

    public ModifiableValidation setMessage(Map<String, ? extends String> entries) {
        this.message.clear();
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.message.put(Objects.requireNonNull(k, "message key"), Objects.requireNonNull(v, "message value"));
        }
        return this;
    }

    public ModifiableValidation putAllMessage(Map<String, ? extends String> entries) {
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.message.put(Objects.requireNonNull(k, "message key"), Objects.requireNonNull(v, "message value"));
        }
        return this;
    }

    public ModifiableValidation setRule(String rule) {
        this.rule = rule;
        return this;
    }

    public final boolean isInitialized() {
        return true;
    }

    public final ImmutableValidation toImmutable() {
        return ImmutableValidation.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableValidation)) {
            return false;
        }
        ModifiableValidation other = (ModifiableValidation)another;
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableValidation another) {
        return this.message.equals(another.message) && Objects.equals(this.rule, another.rule);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.rule);
        return h;
    }

    public String toString() {
        return "ModifiableValidation{message=" + this.getMessage() + ", rule=" + this.getRule() + "}";
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

