/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.form.ImmutableValidation;
import io.dialob.api.form.Validation;
import java.io.IOException;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.form", generator="Gsons")
public final class GsonAdaptersValidation
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ValidationTypeAdapter.adapts(type)) {
            return new ValidationTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersValidation(Validation)";
    }

    @Generated(from="Validation", generator="Gsons")
    private static class ValidationTypeAdapter
    extends TypeAdapter<Validation> {
        ValidationTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return Validation.class == type.getRawType() || ImmutableValidation.class == type.getRawType();
        }

        public void write(JsonWriter out, Validation value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeValidation(out, value);
            }
        }

        public Validation read(JsonReader in) throws IOException {
            return this.readValidation(in);
        }

        private void writeValidation(JsonWriter out, Validation instance) throws IOException {
            out.beginObject();
            Map<String, String> messageMapping = instance.getMessage();
            out.name("message");
            out.beginObject();
            for (Map.Entry<String, String> e : messageMapping.entrySet()) {
                String key = e.getKey();
                out.name(key);
                String value = e.getValue();
                out.value(value);
            }
            out.endObject();
            String ruleValue = instance.getRule();
            if (ruleValue != null) {
                out.name("rule");
                out.value(ruleValue);
            } else if (out.getSerializeNulls()) {
                out.name("rule");
                out.nullValue();
            }
            out.endObject();
        }

        private Validation readValidation(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableValidation.Builder builder = ImmutableValidation.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableValidation.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'm': {
                    if (!"message".equals(attributeName)) break;
                    this.readInMessage(in, builder);
                    return;
                }
                case 'r': {
                    if (!"rule".equals(attributeName)) break;
                    this.readInRule(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInMessage(JsonReader in, ImmutableValidation.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putMessage(key, value);
                }
                in.endObject();
            }
        }

        private void readInRule(JsonReader in, ImmutableValidation.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.rule(in.nextString());
            }
        }
    }
}

