/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.form.FormTag;
import io.dialob.api.form.ImmutableFormTag;
import java.io.IOException;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.form", generator="Gsons")
public final class GsonAdaptersFormTag
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (FormTagTypeAdapter.adapts(type)) {
            return new FormTagTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersFormTag(FormTag)";
    }

    @Generated(from="FormTag", generator="Gsons")
    private static class FormTagTypeAdapter
    extends TypeAdapter<FormTag> {
        public final Date createdTypeSample = null;
        public final FormTag.Type typeTypeSample = null;
        private final TypeAdapter<Date> createdTypeAdapter;
        private final TypeAdapter<FormTag.Type> typeTypeAdapter;

        FormTagTypeAdapter(Gson gson) {
            this.createdTypeAdapter = gson.getAdapter(Date.class);
            this.typeTypeAdapter = gson.getAdapter(FormTag.Type.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return FormTag.class == type.getRawType() || ImmutableFormTag.class == type.getRawType();
        }

        public void write(JsonWriter out, FormTag value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeFormTag(out, value);
            }
        }

        public FormTag read(JsonReader in) throws IOException {
            return this.readFormTag(in);
        }

        private void writeFormTag(JsonWriter out, FormTag instance) throws IOException {
            out.beginObject();
            String formNameValue = instance.getFormName();
            if (formNameValue != null) {
                out.name("formName");
                out.value(formNameValue);
            } else if (out.getSerializeNulls()) {
                out.name("formName");
                out.nullValue();
            }
            String nameValue = instance.getName();
            if (nameValue != null) {
                out.name("name");
                out.value(nameValue);
            } else if (out.getSerializeNulls()) {
                out.name("name");
                out.nullValue();
            }
            String refNameValue = instance.getRefName();
            if (refNameValue != null) {
                out.name("refName");
                out.value(refNameValue);
            } else if (out.getSerializeNulls()) {
                out.name("refName");
                out.nullValue();
            }
            Date createdValue = instance.getCreated();
            if (createdValue != null) {
                out.name("created");
                this.createdTypeAdapter.write(out, (Object)createdValue);
            } else if (out.getSerializeNulls()) {
                out.name("created");
                out.nullValue();
            }
            String formIdValue = instance.getFormId();
            if (formIdValue != null) {
                out.name("formId");
                out.value(formIdValue);
            } else if (out.getSerializeNulls()) {
                out.name("formId");
                out.nullValue();
            }
            String descriptionValue = instance.getDescription();
            if (descriptionValue != null) {
                out.name("description");
                out.value(descriptionValue);
            } else if (out.getSerializeNulls()) {
                out.name("description");
                out.nullValue();
            }
            out.name("type");
            this.typeTypeAdapter.write(out, (Object)instance.getType());
            out.endObject();
        }

        private FormTag readFormTag(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableFormTag.Builder builder = ImmutableFormTag.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableFormTag.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'f': {
                    if ("formName".equals(attributeName)) {
                        this.readInFormName(in, builder);
                        return;
                    }
                    if (!"formId".equals(attributeName)) break;
                    this.readInFormId(in, builder);
                    return;
                }
                case 'n': {
                    if (!"name".equals(attributeName)) break;
                    this.readInName(in, builder);
                    return;
                }
                case 'r': {
                    if (!"refName".equals(attributeName)) break;
                    this.readInRefName(in, builder);
                    return;
                }
                case 'c': {
                    if (!"created".equals(attributeName)) break;
                    this.readInCreated(in, builder);
                    return;
                }
                case 'd': {
                    if (!"description".equals(attributeName)) break;
                    this.readInDescription(in, builder);
                    return;
                }
                case 't': {
                    if (!"type".equals(attributeName)) break;
                    this.readInType(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInFormName(JsonReader in, ImmutableFormTag.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.formName(in.nextString());
            }
        }

        private void readInName(JsonReader in, ImmutableFormTag.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.name(in.nextString());
            }
        }

        private void readInRefName(JsonReader in, ImmutableFormTag.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.refName(in.nextString());
            }
        }

        private void readInCreated(JsonReader in, ImmutableFormTag.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Date value = (Date)this.createdTypeAdapter.read(in);
                builder.created(value);
            }
        }

        private void readInFormId(JsonReader in, ImmutableFormTag.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.formId(in.nextString());
            }
        }

        private void readInDescription(JsonReader in, ImmutableFormTag.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.description(in.nextString());
            }
        }

        private void readInType(JsonReader in, ImmutableFormTag.Builder builder) throws IOException {
            FormTag.Type value = (FormTag.Type)((Object)this.typeTypeAdapter.read(in));
            builder.type(value);
        }
    }
}

