/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dialob.api.form.FormEntity;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.FormValueSet;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormMetadata;
import io.dialob.api.form.Variable;
import io.dialob.api.validation.WithValidation;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.immutables.gson.Gson;
import org.immutables.value.Value;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;

@JsonSerialize(as=ImmutableForm.class)
@JsonDeserialize(as=ImmutableForm.class)
@JsonInclude(content=JsonInclude.Include.NON_NULL, value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(value={"saving", "rules", "updated", "failed", "serviceCalls"})
@Value.Immutable
@Value.Modifiable
@Gson.TypeAdapters(emptyAsNulls=true)
@Value.Style(validationMethod=Value.Style.ValidationMethod.NONE, jdkOnly=true)
public interface Form
extends WithValidation<Form>,
FormEntity {
    @JsonProperty(value="_id")
    @Id
    @Gson.Named(value="_id")
    public String getId();

    @JsonProperty(value="_rev")
    @Version
    @Gson.Named(value="_rev")
    public String getRev();

    public String getName();

    @Valid
    @NotNull
    public Map<String, FormItem> getData();

    @Valid
    @NotNull
    public Metadata getMetadata();

    @Valid
    @NotNull
    public List<Variable> getVariables();

    @Valid
    @NotNull
    public Map<String, Form> getNamespaces();

    @Valid
    @NotNull
    public List<FormValueSet> getValueSets();

    @NotNull
    public Map<String, String> getRequiredErrorText();

    @JsonSerialize(as=ImmutableFormMetadata.class)
    @JsonDeserialize(as=ImmutableFormMetadata.class)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(content=JsonInclude.Include.NON_NULL, value=JsonInclude.Include.NON_EMPTY)
    @Value.Immutable
    @Value.Style(typeImmutable="ImmutableForm*", typeModifiable="ModifiableForm*", validationMethod=Value.Style.ValidationMethod.NONE, jdkOnly=true)
    @Value.Modifiable
    @Gson.TypeAdapters(emptyAsNulls=true)
    public static interface Metadata
    extends Serializable {
        @NotNull
        public String getLabel();

        public Date getCreated();

        public Date getLastSaved();

        public Boolean getValid();

        public String getCreator();

        public String getTenantId();

        public String getSavedBy();

        @NotNull
        public Set<String> getLabels();

        public String getDefaultSubmitUrl();

        @NotNull
        public Set<String> getLanguages();

        @JsonInclude
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties();
    }
}

