package io.dialob.api.rest;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code IdAndRevision}.
 * @see ImmutableIdAndRevision
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.rest", generator = "Gsons")
public final class GsonAdaptersIdAndRevision implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (IdAndRevisionTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new IdAndRevisionTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersIdAndRevision(IdAndRevision)";
  }

  @org.immutables.value.Generated(from = "IdAndRevision", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class IdAndRevisionTypeAdapter extends TypeAdapter<IdAndRevision> {

    IdAndRevisionTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return IdAndRevision.class == type.getRawType()
          || ImmutableIdAndRevision.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, IdAndRevision value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeIdAndRevision(out, value);
      }
    }

    @Override
    public IdAndRevision read(JsonReader in) throws IOException {
      return readIdAndRevision(in);
    }

    private void writeIdAndRevision(JsonWriter out, IdAndRevision instance)
        throws IOException {
      out.beginObject();
      out.name("_id");
      out.value(instance.getId());
      out.name("_rev");
      out.value(instance.getRev());
      out.endObject();
    }

    private  IdAndRevision readIdAndRevision(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableIdAndRevision.Builder builder = ImmutableIdAndRevision.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableIdAndRevision.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case '_':
        if ("_id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        if ("_rev".equals(attributeName)) {
          readInRev(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableIdAndRevision.Builder builder)
        throws IOException {
      builder.id(in.nextString());
    }

    private void readInRev(JsonReader in, ImmutableIdAndRevision.Builder builder)
        throws IOException {
      builder.rev(in.nextString());
    }
  }
}
