package io.dialob.api.questionnaire;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code QuestionnaireListItem}.
 * @see ImmutableQuestionnaireListItem
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.questionnaire", generator = "Gsons")
public final class GsonAdaptersQuestionnaireListItem implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (QuestionnaireListItemTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new QuestionnaireListItemTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersQuestionnaireListItem(QuestionnaireListItem)";
  }

  @org.immutables.value.Generated(from = "QuestionnaireListItem", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class QuestionnaireListItemTypeAdapter extends TypeAdapter<QuestionnaireListItem> {
    public final Questionnaire.Metadata metadataTypeSample = null;
    private final TypeAdapter<Questionnaire.Metadata> metadataTypeAdapter;

    QuestionnaireListItemTypeAdapter(Gson gson) {
      this.metadataTypeAdapter = gson.getAdapter( Questionnaire.Metadata.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return QuestionnaireListItem.class == type.getRawType()
          || ImmutableQuestionnaireListItem.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, QuestionnaireListItem value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeQuestionnaireListItem(out, value);
      }
    }

    @Override
    public QuestionnaireListItem read(JsonReader in) throws IOException {
      return readQuestionnaireListItem(in);
    }

    private void writeQuestionnaireListItem(JsonWriter out, QuestionnaireListItem instance)
        throws IOException {
      out.beginObject();
      out.name("id");
      out.value(instance.getId());
      out.name("metadata");
      metadataTypeAdapter.write(out, instance.getMetadata());
      out.endObject();
    }

    private  QuestionnaireListItem readQuestionnaireListItem(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableQuestionnaireListItem.Builder builder = ImmutableQuestionnaireListItem.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableQuestionnaireListItem.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'm':
        if ("metadata".equals(attributeName)) {
          readInMetadata(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableQuestionnaireListItem.Builder builder)
        throws IOException {
      builder.id(in.nextString());
    }

    private void readInMetadata(JsonReader in, ImmutableQuestionnaireListItem.Builder builder)
        throws IOException {
      Questionnaire.Metadata value = metadataTypeAdapter.read(in);
      builder.metadata(value);
    }
  }
}
