package io.dialob.api.questionnaire;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Error}.
 * @see ImmutableError
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.questionnaire", generator = "Gsons")
public final class GsonAdaptersError implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ErrorTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ErrorTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersError(Error)";
  }

  @org.immutables.value.Generated(from = "Error", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class ErrorTypeAdapter extends TypeAdapter<Error> {

    ErrorTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return Error.class == type.getRawType()
          || ImmutableError.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Error value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeError(out, value);
      }
    }

    @Override
    public Error read(JsonReader in) throws IOException {
      return readError(in);
    }

    private void writeError(JsonWriter out, Error instance)
        throws IOException {
      out.beginObject();
      out.name("id");
      out.value(instance.getId());
      String codeValue = instance.getCode();
      if (codeValue != null) {
        out.name("code");
        out.value(codeValue);
      } else if (out.getSerializeNulls()) {
        out.name("code");
        out.nullValue();
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        out.name("description");
        out.value(descriptionValue);
      } else if (out.getSerializeNulls()) {
        out.name("description");
        out.nullValue();
      }
      out.endObject();
    }

    private  Error readError(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableError.Builder builder = ImmutableError.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableError.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'c':
        if ("code".equals(attributeName)) {
          readInCode(in, builder);
          return;
        }
        break;
      case 'd':
        if ("description".equals(attributeName)) {
          readInDescription(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableError.Builder builder)
        throws IOException {
      builder.id(in.nextString());
    }

    private void readInCode(JsonReader in, ImmutableError.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.code(in.nextString());
      }
    }

    private void readInDescription(JsonReader in, ImmutableError.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.description(in.nextString());
      }
    }
  }
}
