package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Variable Variable} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableVariable is not thread-safe</em>
 * @see ImmutableVariable
 */
@Generated(from = "Variable", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "Variable"})
@NotThreadSafe
public final class ModifiableVariable implements Variable {

  private String name;
  private @Nullable String expression;
  private @Nullable java.lang.Object defaultValue;
  private @Nullable Boolean context;
  private @Nullable Boolean published;
  private @Nullable String contextType;

  private ModifiableVariable() {}

  /**
   * Construct a modifiable instance of {@code Variable}.
   * @param name The value for the {@link Variable#getName() name} attribute (can be {@code null})
   * @param expression The value for the {@link Variable#getExpression() expression} attribute (can be {@code null})
   * @return A new modifiable instance
   */
  public static ModifiableVariable create(String name, @Nullable String expression) {
    return new ModifiableVariable()
        .setName(name)
        .setExpression(expression);
  }

  /**
   * Construct a modifiable instance of {@code Variable}.
   * @return A new modifiable instance
   */
  public static ModifiableVariable create() {
    return new ModifiableVariable();
  }

  /**
   * @return value of {@code name} attribute, may be {@code null}
   */
  @JsonProperty("name")
  @Override
  public final String getName() {
    return name;
  }

  /**
   * @return value of {@code expression} attribute, may be {@code null}
   */
  @JsonProperty("expression")
  @Override
  public final @Nullable String getExpression() {
    return expression;
  }

  /**
   * @return value of {@code defaultValue} attribute, may be {@code null}
   */
  @JsonProperty("defaultValue")
  @Override
  public final @Nullable java.lang.Object getDefaultValue() {
    return defaultValue;
  }

  /**
   * @return true when this is context variable
   */
  @JsonProperty("context")
  @Override
  public final @Nullable Boolean getContext() {
    return context;
  }

  /**
   * @return true when context variable can be published and sent to client.
   */
  @JsonProperty("published")
  @Override
  public final @Nullable Boolean getPublished() {
    return published;
  }

  /**
   * @return value of {@code contextType} attribute, may be {@code null}
   */
  @JsonProperty("contextType")
  @Override
  public final @Nullable String getContextType() {
    return contextType;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariable clear() {
    name = null;
    expression = null;
    defaultValue = null;
    context = null;
    published = null;
    contextType = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Variable} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariable from(Variable instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableVariable) {
      from((ModifiableVariable) instance);
      return this;
    }
    String nameValue = instance.getName();
    if (nameValue != null) {
      setName(nameValue);
    }
    String expressionValue = instance.getExpression();
    if (expressionValue != null) {
      setExpression(expressionValue);
    }
    java.lang.Object defaultValueValue = instance.getDefaultValue();
    if (defaultValueValue != null) {
      setDefaultValue(defaultValueValue);
    }
    Boolean contextValue = instance.getContext();
    if (contextValue != null) {
      setContext(contextValue);
    }
    Boolean publishedValue = instance.getPublished();
    if (publishedValue != null) {
      setPublished(publishedValue);
    }
    String contextTypeValue = instance.getContextType();
    if (contextTypeValue != null) {
      setContextType(contextTypeValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Variable} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariable from(ModifiableVariable instance) {
    Objects.requireNonNull(instance, "instance");
    String nameValue = instance.getName();
    if (nameValue != null) {
      setName(nameValue);
    }
    String expressionValue = instance.getExpression();
    if (expressionValue != null) {
      setExpression(expressionValue);
    }
    java.lang.Object defaultValueValue = instance.getDefaultValue();
    if (defaultValueValue != null) {
      setDefaultValue(defaultValueValue);
    }
    Boolean contextValue = instance.getContext();
    if (contextValue != null) {
      setContext(contextValue);
    }
    Boolean publishedValue = instance.getPublished();
    if (publishedValue != null) {
      setPublished(publishedValue);
    }
    String contextTypeValue = instance.getContextType();
    if (contextTypeValue != null) {
      setContextType(contextTypeValue);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Variable#getName() name} attribute.
   * @param name The value for name, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariable setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Assigns a value to the {@link Variable#getExpression() expression} attribute.
   * @param expression The value for expression, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariable setExpression(@Nullable String expression) {
    this.expression = expression;
    return this;
  }

  /**
   * Assigns a value to the {@link Variable#getDefaultValue() defaultValue} attribute.
   * @param defaultValue The value for defaultValue, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariable setDefaultValue(@Nullable java.lang.Object defaultValue) {
    this.defaultValue = defaultValue;
    return this;
  }

  /**
   * Assigns a value to the {@link Variable#getContext() context} attribute.
   * @param context The value for context, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariable setContext(@Nullable Boolean context) {
    this.context = context;
    return this;
  }

  /**
   * Assigns a value to the {@link Variable#getPublished() published} attribute.
   * @param published The value for published, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariable setPublished(@Nullable Boolean published) {
    this.published = published;
    return this;
  }

  /**
   * Assigns a value to the {@link Variable#getContextType() contextType} attribute.
   * @param contextType The value for contextType, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariable setContextType(@Nullable String contextType) {
    this.contextType = contextType;
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableVariable ImmutableVariable}.
   * @return An immutable instance of Variable
   */
  public final ImmutableVariable toImmutable() {
    return ImmutableVariable.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableVariable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableVariable)) return false;
    ModifiableVariable other = (ModifiableVariable) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableVariable another) {
    return Objects.equals(name, another.name)
        && Objects.equals(expression, another.expression)
        && Objects.equals(defaultValue, another.defaultValue)
        && Objects.equals(context, another.context)
        && Objects.equals(published, another.published)
        && Objects.equals(contextType, another.contextType);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code expression}, {@code defaultValue}, {@code context}, {@code published}, {@code contextType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(expression);
    h += (h << 5) + Objects.hashCode(defaultValue);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(published);
    h += (h << 5) + Objects.hashCode(contextType);
    return h;
  }

  /**
   * Generates a string representation of this {@code Variable}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableVariable{"
        + "name=" + getName()
        + ", expression=" + getExpression()
        + ", defaultValue=" + getDefaultValue()
        + ", context=" + getContext()
        + ", published=" + getPublished()
        + ", contextType=" + getContextType()
        + "}";
  }
}
