package io.dialob.api.form;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code FormItem}.
 * @see ImmutableFormItem
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.form", generator = "Gsons")
public final class GsonAdaptersFormItem implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (FormItemTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new FormItemTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersFormItem(FormItem)";
  }

  @org.immutables.value.Generated(from = "FormItem", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class FormItemTypeAdapter extends TypeAdapter<FormItem> {
    public final Boolean readOnlyTypeSample = null;
    public final Validation validationsTypeSample = null;
    public final Object defaultValueTypeSample = null;
    public final Object propsSecondaryTypeSample = null;
    private final TypeAdapter<Boolean> readOnlyTypeAdapter;
    private final TypeAdapter<Validation> validationsTypeAdapter;
    private final TypeAdapter<Object> defaultValueTypeAdapter;
    private final TypeAdapter<Object> propsSecondaryTypeAdapter;

    FormItemTypeAdapter(Gson gson) {
      this.readOnlyTypeAdapter = gson.getAdapter( Boolean.class);
      this.validationsTypeAdapter = gson.getAdapter( Validation.class);
      this.defaultValueTypeAdapter = gson.getAdapter( Object.class);
      this.propsSecondaryTypeAdapter = gson.getAdapter( Object.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return FormItem.class == type.getRawType()
          || ImmutableFormItem.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, FormItem value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeFormItem(out, value);
      }
    }

    @Override
    public FormItem read(JsonReader in) throws IOException {
      return readFormItem(in);
    }

    private void writeFormItem(JsonWriter out, FormItem instance)
        throws IOException {
      out.beginObject();
      String idValue = instance.getId();
      if (idValue != null) {
        out.name("id");
        out.value(idValue);
      } else if (out.getSerializeNulls()) {
        out.name("id");
        out.nullValue();
      }
      String typeValue = instance.getType();
      if (typeValue != null) {
        out.name("type");
        out.value(typeValue);
      } else if (out.getSerializeNulls()) {
        out.name("type");
        out.nullValue();
      }
      String viewValue = instance.getView();
      if (viewValue != null) {
        out.name("view");
        out.value(viewValue);
      } else if (out.getSerializeNulls()) {
        out.name("view");
        out.nullValue();
      }
      Map<String, String> labelMapping = instance.getLabel();
      out.name("label");
      out.beginObject();
      for (Map.Entry<String, String> e : labelMapping.entrySet()) {
        String key = e.getKey();
        out.name(key);
        String value = e.getValue();
        out.value(value);
      }
      out.endObject();
      Map<String, String> descriptionMapping = instance.getDescription();
      out.name("description");
      out.beginObject();
      for (Map.Entry<String, String> e : descriptionMapping.entrySet()) {
        String key = e.getKey();
        out.name(key);
        String value = e.getValue();
        out.value(value);
      }
      out.endObject();
      String requiredValue = instance.getRequired();
      if (requiredValue != null) {
        out.name("required");
        out.value(requiredValue);
      } else if (out.getSerializeNulls()) {
        out.name("required");
        out.nullValue();
      }
      Map<String, String> requiredErrorTextMapping = instance.getRequiredErrorText();
      out.name("requiredErrorText");
      out.beginObject();
      for (Map.Entry<String, String> e : requiredErrorTextMapping.entrySet()) {
        String key = e.getKey();
        out.name(key);
        String value = e.getValue();
        out.value(value);
      }
      out.endObject();
      Boolean readOnlyValue = instance.getReadOnly();
      if (readOnlyValue != null) {
        out.name("readOnly");
        readOnlyTypeAdapter.write(out, readOnlyValue);
      } else if (out.getSerializeNulls()) {
        out.name("readOnly");
        out.nullValue();
      }
      List<String> itemsElements = instance.getItems();
      out.name("items");
      out.beginArray();
      for (String e : itemsElements) {
        out.value(e);
      }
      out.endArray();
      List<String> classNameElements = instance.getClassName();
      out.name("className");
      out.beginArray();
      for (String e : classNameElements) {
        out.value(e);
      }
      out.endArray();
      String activeWhenValue = instance.getActiveWhen();
      if (activeWhenValue != null) {
        out.name("activeWhen");
        out.value(activeWhenValue);
      } else if (out.getSerializeNulls()) {
        out.name("activeWhen");
        out.nullValue();
      }
      String canAddRowWhenValue = instance.getCanAddRowWhen();
      if (canAddRowWhenValue != null) {
        out.name("canAddRowWhen");
        out.value(canAddRowWhenValue);
      } else if (out.getSerializeNulls()) {
        out.name("canAddRowWhen");
        out.nullValue();
      }
      String canRemoveRowWhenValue = instance.getCanRemoveRowWhen();
      if (canRemoveRowWhenValue != null) {
        out.name("canRemoveRowWhen");
        out.value(canRemoveRowWhenValue);
      } else if (out.getSerializeNulls()) {
        out.name("canRemoveRowWhen");
        out.nullValue();
      }
      List<Validation> validationsElements = instance.getValidations();
      out.name("validations");
      out.beginArray();
      for (Validation e : validationsElements) {
        validationsTypeAdapter.write(out, e);
      }
      out.endArray();
      String valueSetIdValue = instance.getValueSetId();
      if (valueSetIdValue != null) {
        out.name("valueSetId");
        out.value(valueSetIdValue);
      } else if (out.getSerializeNulls()) {
        out.name("valueSetId");
        out.nullValue();
      }
      Object defaultValueValue = instance.getDefaultValue();
      if (defaultValueValue != null) {
        out.name("defaultValue");
        defaultValueTypeAdapter.write(out, defaultValueValue);
      } else if (out.getSerializeNulls()) {
        out.name("defaultValue");
        out.nullValue();
      }
      Map<String, Object> propsMapping = instance.getProps();
      if (propsMapping != null) {
        out.name("props");
        out.beginObject();
        for (Map.Entry<String, Object> e : propsMapping.entrySet()) {
          String key = e.getKey();
          out.name(key);
          Object value = e.getValue();
          propsSecondaryTypeAdapter.write(out, value);
        }
        out.endObject();
      } else if (out.getSerializeNulls()) {
        out.name("props");
        out.nullValue();
      }
      out.endObject();
    }

    private  FormItem readFormItem(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableFormItem.Builder builder = ImmutableFormItem.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        if ("items".equals(attributeName)) {
          readInItems(in, builder);
          return;
        }
        break;
      case 't':
        if ("type".equals(attributeName)) {
          readInType(in, builder);
          return;
        }
        break;
      case 'v':
        if ("view".equals(attributeName)) {
          readInView(in, builder);
          return;
        }
        if ("validations".equals(attributeName)) {
          readInValidations(in, builder);
          return;
        }
        if ("valueSetId".equals(attributeName)) {
          readInValueSetId(in, builder);
          return;
        }
        break;
      case 'l':
        if ("label".equals(attributeName)) {
          readInLabel(in, builder);
          return;
        }
        break;
      case 'd':
        if ("description".equals(attributeName)) {
          readInDescription(in, builder);
          return;
        }
        if ("defaultValue".equals(attributeName)) {
          readInDefaultValue(in, builder);
          return;
        }
        break;
      case 'r':
        if ("required".equals(attributeName)) {
          readInRequired(in, builder);
          return;
        }
        if ("requiredErrorText".equals(attributeName)) {
          readInRequiredErrorText(in, builder);
          return;
        }
        if ("readOnly".equals(attributeName)) {
          readInReadOnly(in, builder);
          return;
        }
        break;
      case 'c':
        if ("className".equals(attributeName)) {
          readInClassName(in, builder);
          return;
        }
        if ("canAddRowWhen".equals(attributeName)) {
          readInCanAddRowWhen(in, builder);
          return;
        }
        if ("canRemoveRowWhen".equals(attributeName)) {
          readInCanRemoveRowWhen(in, builder);
          return;
        }
        break;
      case 'a':
        if ("activeWhen".equals(attributeName)) {
          readInActiveWhen(in, builder);
          return;
        }
        break;
      case 'p':
        if ("props".equals(attributeName)) {
          readInProps(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.id(in.nextString());
      }
    }

    private void readInType(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.type(in.nextString());
      }
    }

    private void readInView(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.view(in.nextString());
      }
    }

    private void readInLabel(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          String value = in.nextString();
          builder.putLabel(key, value);
        }
        in.endObject();
      }
    }

    private void readInDescription(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          String value = in.nextString();
          builder.putDescription(key, value);
        }
        in.endObject();
      }
    }

    private void readInRequired(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.required(in.nextString());
      }
    }

    private void readInRequiredErrorText(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          String value = in.nextString();
          builder.putRequiredErrorText(key, value);
        }
        in.endObject();
      }
    }

    private void readInReadOnly(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = readOnlyTypeAdapter.read(in);
        builder.readOnly(value);
      }
    }

    private void readInItems(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addItems(in.nextString());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addItems(in.nextString());
      }
    }

    private void readInClassName(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addClassName(in.nextString());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addClassName(in.nextString());
      }
    }

    private void readInActiveWhen(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.activeWhen(in.nextString());
      }
    }

    private void readInCanAddRowWhen(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.canAddRowWhen(in.nextString());
      }
    }

    private void readInCanRemoveRowWhen(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.canRemoveRowWhen(in.nextString());
      }
    }

    private void readInValidations(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          Validation value = validationsTypeAdapter.read(in);
          builder.addValidations(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Validation value = validationsTypeAdapter.read(in);
        builder.addValidations(value);
      }
    }

    private void readInValueSetId(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.valueSetId(in.nextString());
      }
    }

    private void readInDefaultValue(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Object value = defaultValueTypeAdapter.read(in);
        builder.defaultValue(value);
      }
    }

    private void readInProps(JsonReader in, ImmutableFormItem.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          in.beginObject();
          boolean empty = true;
          while(in.hasNext()) {
            String rawKey = in.nextName();
            String key = rawKey;
            Object value = propsSecondaryTypeAdapter.read(in);
            builder.putProps(key, value);
            empty = false;
          }
          if (empty) {
            builder.putAllProps(Collections.<String, Object>emptyMap());
          }
          in.endObject();
        }
      }
    }
  }
}
