/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.rest.Items;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Items", generator="Immutables")
@Immutable
public final class ImmutableItems
implements Items {
    private final String activeItem;
    private final List<String> items;
    private final List<String> availableItems;

    private ImmutableItems(String activeItem, List<String> items, List<String> availableItems) {
        this.activeItem = activeItem;
        this.items = items;
        this.availableItems = availableItems;
    }

    @Override
    @JsonProperty(value="activeItem")
    public String getActiveItem() {
        return this.activeItem;
    }

    @Override
    @JsonProperty(value="items")
    public List<String> getItems() {
        return this.items;
    }

    @Override
    @JsonProperty(value="availableItems")
    public List<String> getAvailableItems() {
        return this.availableItems;
    }

    public final ImmutableItems withActiveItem(String value) {
        String newValue = Objects.requireNonNull(value, "activeItem");
        if (this.activeItem.equals(newValue)) {
            return this;
        }
        return new ImmutableItems(newValue, this.items, this.availableItems);
    }

    public final ImmutableItems withItems(String ... elements) {
        List<String> newValue = ImmutableItems.createUnmodifiableList(false, ImmutableItems.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableItems(this.activeItem, newValue, this.availableItems);
    }

    public final ImmutableItems withItems(Iterable<String> elements) {
        if (this.items == elements) {
            return this;
        }
        List<String> newValue = ImmutableItems.createUnmodifiableList(false, ImmutableItems.createSafeList(elements, true, false));
        return new ImmutableItems(this.activeItem, newValue, this.availableItems);
    }

    public final ImmutableItems withAvailableItems(String ... elements) {
        List<String> newValue = ImmutableItems.createUnmodifiableList(false, ImmutableItems.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableItems(this.activeItem, this.items, newValue);
    }

    public final ImmutableItems withAvailableItems(Iterable<String> elements) {
        if (this.availableItems == elements) {
            return this;
        }
        List<String> newValue = ImmutableItems.createUnmodifiableList(false, ImmutableItems.createSafeList(elements, true, false));
        return new ImmutableItems(this.activeItem, this.items, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableItems && this.equalTo((ImmutableItems)another);
    }

    private boolean equalTo(ImmutableItems another) {
        return this.activeItem.equals(another.activeItem) && this.items.equals(another.items) && this.availableItems.equals(another.availableItems);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.activeItem.hashCode();
        h += (h << 5) + this.items.hashCode();
        h += (h << 5) + this.availableItems.hashCode();
        return h;
    }

    public String toString() {
        return "Items{activeItem=" + this.activeItem + ", items=" + this.items + ", availableItems=" + this.availableItems + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableItems fromJson(Json json) {
        Builder builder = ImmutableItems.builder();
        if (json.activeItem != null) {
            builder.activeItem(json.activeItem);
        }
        if (json.items != null) {
            builder.addAllItems(json.items);
        }
        if (json.availableItems != null) {
            builder.addAllAvailableItems(json.availableItems);
        }
        return builder.build();
    }

    public static ImmutableItems copyOf(Items instance) {
        if (instance instanceof ImmutableItems) {
            return (ImmutableItems)instance;
        }
        return ImmutableItems.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Items", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACTIVE_ITEM = 1L;
        private long initBits = 1L;
        @Nullable
        private String activeItem;
        private List<String> items = new ArrayList<String>();
        private List<String> availableItems = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(Items instance) {
            Objects.requireNonNull(instance, "instance");
            this.activeItem(instance.getActiveItem());
            this.addAllItems(instance.getItems());
            this.addAllAvailableItems(instance.getAvailableItems());
            return this;
        }

        @JsonProperty(value="activeItem")
        public final Builder activeItem(String activeItem) {
            this.activeItem = Objects.requireNonNull(activeItem, "activeItem");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addItems(String element) {
            this.items.add(Objects.requireNonNull(element, "items element"));
            return this;
        }

        public final Builder addItems(String ... elements) {
            for (String element : elements) {
                this.items.add(Objects.requireNonNull(element, "items element"));
            }
            return this;
        }

        @JsonProperty(value="items")
        public final Builder items(Iterable<String> elements) {
            this.items.clear();
            return this.addAllItems(elements);
        }

        public final Builder addAllItems(Iterable<String> elements) {
            for (String element : elements) {
                this.items.add(Objects.requireNonNull(element, "items element"));
            }
            return this;
        }

        public final Builder addAvailableItems(String element) {
            this.availableItems.add(Objects.requireNonNull(element, "availableItems element"));
            return this;
        }

        public final Builder addAvailableItems(String ... elements) {
            for (String element : elements) {
                this.availableItems.add(Objects.requireNonNull(element, "availableItems element"));
            }
            return this;
        }

        @JsonProperty(value="availableItems")
        public final Builder availableItems(Iterable<String> elements) {
            this.availableItems.clear();
            return this.addAllAvailableItems(elements);
        }

        public final Builder addAllAvailableItems(Iterable<String> elements) {
            for (String element : elements) {
                this.availableItems.add(Objects.requireNonNull(element, "availableItems element"));
            }
            return this;
        }

        public ImmutableItems build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableItems(this.activeItem, ImmutableItems.createUnmodifiableList(true, this.items), ImmutableItems.createUnmodifiableList(true, this.availableItems));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("activeItem");
            }
            return "Cannot build Items, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Items", generator="Immutables")
    static final class Json
    implements Items {
        @Nullable
        String activeItem;
        @Nullable
        List<String> items = Collections.emptyList();
        @Nullable
        List<String> availableItems = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="activeItem")
        public void setActiveItem(String activeItem) {
            this.activeItem = activeItem;
        }

        @JsonProperty(value="items")
        public void setItems(List<String> items) {
            this.items = items;
        }

        @JsonProperty(value="availableItems")
        public void setAvailableItems(List<String> availableItems) {
            this.availableItems = availableItems;
        }

        @Override
        public String getActiveItem() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getItems() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAvailableItems() {
            throw new UnsupportedOperationException();
        }
    }
}

