/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dialob.api.rest.ImmutableErrors;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.immutables.gson.Gson;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableErrors.class)
@JsonDeserialize(as=ImmutableErrors.class)
@JsonInclude(content=JsonInclude.Include.NON_NULL, value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@Value.Enclosing
@Gson.TypeAdapters
@Value.Style(jdkOnly=true)
public abstract class Errors
implements Serializable {
    @Schema(description="error timestamp")
    @Value.Default
    public Date getTimestamp() {
        return new Date();
    }

    @Schema(description="HTTP status code", example="403")
    public abstract Integer getStatus();

    public abstract String getError();

    public abstract String getMessage();

    @Schema(description="Java stacktrace, if server is configured to send one.")
    public abstract String getTrace();

    public abstract String getPath();

    @Schema(description="List of identified errors in entity")
    public abstract List<Error> getErrors();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(as=ImmutableErrors.Error.class)
    @JsonDeserialize(as=ImmutableErrors.Error.class)
    @Value.Immutable
    @Gson.TypeAdapters
    @Value.Style(jdkOnly=true)
    public static interface Error
    extends Serializable {
        @Schema(description="Error classifying code")
        public String getCode();

        @Schema(description="Javascript path notation to entity attribute")
        public String getContext();

        @Schema(description="Invalid value on entity attribute")
        public Object getRejectedValue();

        @Schema(description="Error description")
        public String getError();
    }
}

