/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.VariableValue;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Questionnaire", generator="Repositories")
@ThreadSafe
public class QuestionnaireRepository
extends Repositories.Repository<Questionnaire> {
    private static final String DOCUMENT_COLLECTION_NAME = "questionnaires";
    private final Serialization serialization = new Serialization(this.codecRegistry(), this.fieldNamingStrategy());
    private final Criteria anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());

    public QuestionnaireRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, Questionnaire.class);
    }

    public FluentFuture<Integer> insert(Questionnaire document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends Questionnaire> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    @CheckReturnValue
    public Finder findAll() {
        return this.find(this.criteria());
    }

    @CheckReturnValue
    public Finder find(String jsonCriteria) {
        return new Finder(this, Support.jsonQuery((String)jsonCriteria));
    }

    @CheckReturnValue
    public Finder findById(String id) {
        return this.find(this.criteria().id(id));
    }

    public FluentFuture<Integer> upsert(Questionnaire document) {
        Criteria byId = this.criteria().id(document.getId());
        return super.doUpsert((Constraints.ConstraintHost)byId.constraint, (Object)document);
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, (Constraints.ConstraintHost)criteria.constraint);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public Criteria criteria() {
        return this.anyCriteria;
    }

    @Beta
    Bson toBson(Criteria criteria) {
        return Support.convertToBson((Constraints.ConstraintHost)criteria.constraint);
    }

    @Generated(from="Questionnaire", generator="Repositories")
    private static class Serialization {
        final Encoder<Answer> answersEncoder;
        final Encoder<ContextValue> contextEncoder;
        final Encoder<Error> errorsEncoder;
        final Encoder<VariableValue> variableValuesEncoder;
        final Encoder<ValueSet> valueSetsEncoder;
        final Encoder<Questionnaire.Metadata> metadataEncoder;
        final CodecRegistry registry;
        final String idName;
        final String revName;
        final String answersName;
        final String contextName;
        final String activeItemName;
        final String errorsName;
        final String variableValuesName;
        final String valueSetsName;
        final String metadataName;

        Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
            this.registry = registry;
            this.answersEncoder = this.registry.get(Answer.class);
            this.contextEncoder = this.registry.get(ContextValue.class);
            this.errorsEncoder = this.registry.get(Error.class);
            this.variableValuesEncoder = this.registry.get(VariableValue.class);
            this.valueSetsEncoder = this.registry.get(ValueSet.class);
            this.metadataEncoder = this.registry.get(Questionnaire.Metadata.class);
            this.idName = "_id";
            this.revName = "_rev";
            this.answersName = Serialization.translateName(fieldNamingStrategy, "answers");
            this.contextName = Serialization.translateName(fieldNamingStrategy, "context");
            this.activeItemName = Serialization.translateName(fieldNamingStrategy, "activeItem");
            this.errorsName = Serialization.translateName(fieldNamingStrategy, "errors");
            this.variableValuesName = Serialization.translateName(fieldNamingStrategy, "variableValues");
            this.valueSetsName = Serialization.translateName(fieldNamingStrategy, "valueSets");
            this.metadataName = Serialization.translateName(fieldNamingStrategy, "metadata");
        }

        private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
            try {
                return fieldNamingStrategy.translateName((Member)QuestionnaireNamingFields.class.getField(fieldName));
            }
            catch (NoSuchFieldException noSuchField) {
                throw new AssertionError((Object)noSuchField);
            }
        }

        @Generated(from="Questionnaire", generator="Repositories")
        static final class QuestionnaireNamingFields {
            public String id;
            public String rev;
            public List<Answer> answers;
            public List<ContextValue> context;
            public String activeItem;
            public List<Error> errors;
            public List<VariableValue> variableValues;
            public List<ValueSet> valueSets;
            public Questionnaire.Metadata metadata;

            QuestionnaireNamingFields() {
            }
        }
    }

    @Generated(from="Questionnaire", generator="Repositories")
    @Immutable
    public static final class Criteria
    extends Repositories.Criteria {
        private final Constraints.Constraint constraint;
        private final Serialization serialization;

        Criteria(Serialization serialization, Constraints.Constraint constraint) {
            this.constraint = constraint;
            this.serialization = serialization;
        }

        public Criteria id(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.idName, false, Support.writable((Object)value)));
        }

        public Criteria idNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.idName, true, Support.writable((Object)value)));
        }

        public Criteria idIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, false, wrappedValues));
        }

        public Criteria idIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, false, values));
        }

        public Criteria idNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, true, wrappedValues));
        }

        public Criteria idNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, true, values));
        }

        public Criteria idStartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria idMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, false, pattern));
        }

        public Criteria idNotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, true, pattern));
        }

        public Criteria idGreaterThan(String lower) {
            return this.idIn((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria idLessThan(String upper) {
            return this.idIn((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria idAtMost(String upperInclusive) {
            return this.idIn((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria idAtLeast(String lowerInclusive) {
            return this.idIn((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria idIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.idName, false, Support.writable(range)));
        }

        public Criteria idNotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.idName, true, Support.writable(range)));
        }

        public Criteria rev(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.revName, false, Support.writable((Object)value)));
        }

        public Criteria revNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.revName, true, Support.writable((Object)value)));
        }

        public Criteria revIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.revName, false, wrappedValues));
        }

        public Criteria revIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.revName, false, values));
        }

        public Criteria revNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.revName, true, wrappedValues));
        }

        public Criteria revNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.revName, true, values));
        }

        public Criteria revStartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.revName, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria revMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.revName, false, pattern));
        }

        public Criteria revNotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.revName, true, pattern));
        }

        public Criteria revGreaterThan(String lower) {
            return this.revIn((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria revLessThan(String upper) {
            return this.revIn((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria revAtMost(String upperInclusive) {
            return this.revIn((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria revAtLeast(String lowerInclusive) {
            return this.revIn((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria revIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.revName, false, Support.writable(range)));
        }

        public Criteria revNotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.revName, true, Support.writable(range)));
        }

        public Criteria answersEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.answersName, false, 0));
        }

        public Criteria answersNonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.answersName, true, 0));
        }

        public Criteria answersSize(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.answersName, false, size));
        }

        public Criteria answersContains(Answer value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.answersName, false, Support.writable(this.serialization.answersEncoder, (Object)value)));
        }

        public Criteria answersContainsAll(Iterable<Answer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Answer value : values) {
                wrappedValues.add(Support.writable(this.serialization.answersEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.answersName, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria contextEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.contextName, false, 0));
        }

        public Criteria contextNonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.contextName, true, 0));
        }

        public Criteria contextSize(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.contextName, false, size));
        }

        public Criteria contextContains(ContextValue value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.contextName, false, Support.writable(this.serialization.contextEncoder, (Object)value)));
        }

        public Criteria contextContainsAll(Iterable<ContextValue> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ContextValue value : values) {
                wrappedValues.add(Support.writable(this.serialization.contextEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.contextName, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria activeItem(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.activeItemName, false, Support.writable((Object)value)));
        }

        public Criteria activeItemNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.activeItemName, true, Support.writable((Object)value)));
        }

        public Criteria activeItemIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.activeItemName, false, wrappedValues));
        }

        public Criteria activeItemIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.activeItemName, false, values));
        }

        public Criteria activeItemNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.activeItemName, true, wrappedValues));
        }

        public Criteria activeItemNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.activeItemName, true, values));
        }

        public Criteria activeItemStartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.activeItemName, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria activeItemMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.activeItemName, false, pattern));
        }

        public Criteria activeItemNotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.activeItemName, true, pattern));
        }

        public Criteria activeItemGreaterThan(String lower) {
            return this.activeItemIn((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria activeItemLessThan(String upper) {
            return this.activeItemIn((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria activeItemAtMost(String upperInclusive) {
            return this.activeItemIn((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria activeItemAtLeast(String lowerInclusive) {
            return this.activeItemIn((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria activeItemIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.activeItemName, false, Support.writable(range)));
        }

        public Criteria activeItemNotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.activeItemName, true, Support.writable(range)));
        }

        public Criteria errorsEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.errorsName, false, 0));
        }

        public Criteria errorsNonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.errorsName, true, 0));
        }

        public Criteria errorsSize(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.errorsName, false, size));
        }

        public Criteria errorsContains(Error value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.errorsName, false, Support.writable(this.serialization.errorsEncoder, (Object)value)));
        }

        public Criteria errorsContainsAll(Iterable<Error> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Error value : values) {
                wrappedValues.add(Support.writable(this.serialization.errorsEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.errorsName, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria variableValuesEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.variableValuesName, false, 0));
        }

        public Criteria variableValuesNonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.variableValuesName, true, 0));
        }

        public Criteria variableValuesSize(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.variableValuesName, false, size));
        }

        public Criteria variableValuesContains(VariableValue value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.variableValuesName, false, Support.writable(this.serialization.variableValuesEncoder, (Object)value)));
        }

        public Criteria variableValuesContainsAll(Iterable<VariableValue> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (VariableValue value : values) {
                wrappedValues.add(Support.writable(this.serialization.variableValuesEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.variableValuesName, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria valueSetsEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.valueSetsName, false, 0));
        }

        public Criteria valueSetsNonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.valueSetsName, true, 0));
        }

        public Criteria valueSetsSize(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.valueSetsName, false, size));
        }

        public Criteria valueSetsContains(ValueSet value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.valueSetsName, false, Support.writable(this.serialization.valueSetsEncoder, (Object)value)));
        }

        public Criteria valueSetsContainsAll(Iterable<ValueSet> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ValueSet value : values) {
                wrappedValues.add(Support.writable(this.serialization.valueSetsEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.valueSetsName, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria metadata(Questionnaire.Metadata value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.metadataName, false, Support.writable(this.serialization.metadataEncoder, (Object)value)));
        }

        public Criteria metadataNot(Questionnaire.Metadata value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.metadataName, true, Support.writable(this.serialization.metadataEncoder, (Object)value)));
        }

        public Criteria metadataIn(Iterable<Questionnaire.Metadata> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Questionnaire.Metadata value : values) {
                wrappedValues.add(Support.writable(this.serialization.metadataEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.metadataName, false, wrappedValues));
        }

        public Criteria metadataIn(Questionnaire.Metadata first, Questionnaire.Metadata second, Questionnaire.Metadata ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.metadataEncoder, (Object)first));
            values.add(Support.writable(this.serialization.metadataEncoder, (Object)second));
            for (Questionnaire.Metadata value : rest) {
                values.add(Support.writable(this.serialization.metadataEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.metadataName, false, values));
        }

        public Criteria metadataNotIn(Iterable<Questionnaire.Metadata> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Questionnaire.Metadata value : values) {
                wrappedValues.add(Support.writable(this.serialization.metadataEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.metadataName, true, wrappedValues));
        }

        public Criteria metadataNotIn(Questionnaire.Metadata first, Questionnaire.Metadata second, Questionnaire.Metadata ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.metadataEncoder, (Object)first));
            values.add(Support.writable(this.serialization.metadataEncoder, (Object)second));
            for (Questionnaire.Metadata value : rest) {
                values.add(Support.writable(this.serialization.metadataEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.metadataName, true, values));
        }

        public Criteria or() {
            return new Criteria(this.serialization, this.constraint.disjunction());
        }

        public Criteria with(Criteria criteria) {
            return new Criteria(this.serialization, (Constraints.Constraint)criteria.constraint.accept((Constraints.ConstraintVisitor)this.constraint));
        }

        public String toString() {
            return "QuestionnaireRepository.criteria(" + Support.stringify((Constraints.ConstraintHost)this.constraint) + ")";
        }
    }

    @Generated(from="Questionnaire", generator="Repositories")
    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<Questionnaire, Indexer> {
        private final Serialization serialization;

        private Indexer(QuestionnaireRepository repository) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
        }

        public Indexer withId() {
            this.fields = this.fields.equal(this.serialization.idName, false, (Object)1);
            return this;
        }

        public Indexer withIdDesceding() {
            this.fields = this.fields.equal(this.serialization.idName, false, (Object)-1);
            return this;
        }

        public Indexer withRev() {
            this.fields = this.fields.equal(this.serialization.revName, false, (Object)1);
            return this;
        }

        public Indexer withRevDesceding() {
            this.fields = this.fields.equal(this.serialization.revName, false, (Object)-1);
            return this;
        }

        public Indexer withAnswers() {
            this.fields = this.fields.equal(this.serialization.answersName, false, (Object)1);
            return this;
        }

        public Indexer withAnswersDesceding() {
            this.fields = this.fields.equal(this.serialization.answersName, false, (Object)-1);
            return this;
        }

        public Indexer withContext() {
            this.fields = this.fields.equal(this.serialization.contextName, false, (Object)1);
            return this;
        }

        public Indexer withContextDesceding() {
            this.fields = this.fields.equal(this.serialization.contextName, false, (Object)-1);
            return this;
        }

        public Indexer withActiveItem() {
            this.fields = this.fields.equal(this.serialization.activeItemName, false, (Object)1);
            return this;
        }

        public Indexer withActiveItemDesceding() {
            this.fields = this.fields.equal(this.serialization.activeItemName, false, (Object)-1);
            return this;
        }

        public Indexer withErrors() {
            this.fields = this.fields.equal(this.serialization.errorsName, false, (Object)1);
            return this;
        }

        public Indexer withErrorsDesceding() {
            this.fields = this.fields.equal(this.serialization.errorsName, false, (Object)-1);
            return this;
        }

        public Indexer withVariableValues() {
            this.fields = this.fields.equal(this.serialization.variableValuesName, false, (Object)1);
            return this;
        }

        public Indexer withVariableValuesDesceding() {
            this.fields = this.fields.equal(this.serialization.variableValuesName, false, (Object)-1);
            return this;
        }

        public Indexer withValueSets() {
            this.fields = this.fields.equal(this.serialization.valueSetsName, false, (Object)1);
            return this;
        }

        public Indexer withValueSetsDesceding() {
            this.fields = this.fields.equal(this.serialization.valueSetsName, false, (Object)-1);
            return this;
        }

        public Indexer withMetadata() {
            this.fields = this.fields.equal(this.serialization.metadataName, false, (Object)1);
            return this;
        }

        public Indexer withMetadataDesceding() {
            this.fields = this.fields.equal(this.serialization.metadataName, false, (Object)-1);
            return this;
        }
    }

    @Generated(from="Questionnaire", generator="Repositories")
    @NotThreadSafe
    public static final class Replacer
    extends Repositories.Replacer<Questionnaire, Replacer> {
        protected Replacer(QuestionnaireRepository repository, Questionnaire document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
            super((Repositories.Repository)repository, (Object)document, criteria, ordering);
        }
    }

    @Generated(from="Questionnaire", generator="Repositories")
    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<Questionnaire, Modifier> {
        private final Serialization serialization;

        private Modifier(QuestionnaireRepository repository, Constraints.ConstraintHost criteria, Constraints.Constraint ordering, Constraints.Constraint exclusion) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }

        public Modifier setId(String value) {
            this.setFields = this.setFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initId(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier setRev(String value) {
            this.setFields = this.setFields.equal(this.serialization.revName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initRev(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.revName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier clearAnswers() {
            this.unsetFields = this.unsetFields.equal(this.serialization.answersName, false, (Object)1);
            return this;
        }

        public Modifier removeAnswers(Answer value) {
            this.pullFields = this.pullFields.equal(this.serialization.answersName, false, Support.writable(this.serialization.answersEncoder, (Object)value));
            return this;
        }

        public Modifier addAnswers(Answer value) {
            this.pushFields = this.pushFields.equal(this.serialization.answersName, false, Support.writable(this.serialization.answersEncoder, (Object)value));
            return this;
        }

        public Modifier setAnswers(Iterable<? extends Answer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Answer answer : values) {
                wrappedValues.add(Support.writable(this.serialization.answersEncoder, (Object)answer));
            }
            this.setFields = this.setFields.equal(this.serialization.answersName, false, wrappedValues);
            return this;
        }

        public Modifier addAllAnswers(Iterable<? extends Answer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Answer answer : values) {
                wrappedValues.add(Support.writable(this.serialization.answersEncoder, (Object)answer));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.answersName, false, v);
            return this;
        }

        public Modifier clearContext() {
            this.unsetFields = this.unsetFields.equal(this.serialization.contextName, false, (Object)1);
            return this;
        }

        public Modifier removeContext(ContextValue value) {
            this.pullFields = this.pullFields.equal(this.serialization.contextName, false, Support.writable(this.serialization.contextEncoder, (Object)value));
            return this;
        }

        public Modifier addContext(ContextValue value) {
            this.pushFields = this.pushFields.equal(this.serialization.contextName, false, Support.writable(this.serialization.contextEncoder, (Object)value));
            return this;
        }

        public Modifier setContext(Iterable<? extends ContextValue> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ContextValue contextValue : values) {
                wrappedValues.add(Support.writable(this.serialization.contextEncoder, (Object)contextValue));
            }
            this.setFields = this.setFields.equal(this.serialization.contextName, false, wrappedValues);
            return this;
        }

        public Modifier addAllContext(Iterable<? extends ContextValue> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ContextValue contextValue : values) {
                wrappedValues.add(Support.writable(this.serialization.contextEncoder, (Object)contextValue));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.contextName, false, v);
            return this;
        }

        public Modifier setActiveItem(String value) {
            this.setFields = this.setFields.equal(this.serialization.activeItemName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initActiveItem(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.activeItemName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier clearErrors() {
            this.unsetFields = this.unsetFields.equal(this.serialization.errorsName, false, (Object)1);
            return this;
        }

        public Modifier removeErrors(Error value) {
            this.pullFields = this.pullFields.equal(this.serialization.errorsName, false, Support.writable(this.serialization.errorsEncoder, (Object)value));
            return this;
        }

        public Modifier addErrors(Error value) {
            this.pushFields = this.pushFields.equal(this.serialization.errorsName, false, Support.writable(this.serialization.errorsEncoder, (Object)value));
            return this;
        }

        public Modifier setErrors(Iterable<? extends Error> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Error error : values) {
                wrappedValues.add(Support.writable(this.serialization.errorsEncoder, (Object)error));
            }
            this.setFields = this.setFields.equal(this.serialization.errorsName, false, wrappedValues);
            return this;
        }

        public Modifier addAllErrors(Iterable<? extends Error> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Error error : values) {
                wrappedValues.add(Support.writable(this.serialization.errorsEncoder, (Object)error));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.errorsName, false, v);
            return this;
        }

        public Modifier clearVariableValues() {
            this.unsetFields = this.unsetFields.equal(this.serialization.variableValuesName, false, (Object)1);
            return this;
        }

        public Modifier removeVariableValues(VariableValue value) {
            this.pullFields = this.pullFields.equal(this.serialization.variableValuesName, false, Support.writable(this.serialization.variableValuesEncoder, (Object)value));
            return this;
        }

        public Modifier addVariableValues(VariableValue value) {
            this.pushFields = this.pushFields.equal(this.serialization.variableValuesName, false, Support.writable(this.serialization.variableValuesEncoder, (Object)value));
            return this;
        }

        public Modifier setVariableValues(Iterable<? extends VariableValue> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (VariableValue variableValue : values) {
                wrappedValues.add(Support.writable(this.serialization.variableValuesEncoder, (Object)variableValue));
            }
            this.setFields = this.setFields.equal(this.serialization.variableValuesName, false, wrappedValues);
            return this;
        }

        public Modifier addAllVariableValues(Iterable<? extends VariableValue> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (VariableValue variableValue : values) {
                wrappedValues.add(Support.writable(this.serialization.variableValuesEncoder, (Object)variableValue));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.variableValuesName, false, v);
            return this;
        }

        public Modifier clearValueSets() {
            this.unsetFields = this.unsetFields.equal(this.serialization.valueSetsName, false, (Object)1);
            return this;
        }

        public Modifier removeValueSets(ValueSet value) {
            this.pullFields = this.pullFields.equal(this.serialization.valueSetsName, false, Support.writable(this.serialization.valueSetsEncoder, (Object)value));
            return this;
        }

        public Modifier addValueSets(ValueSet value) {
            this.pushFields = this.pushFields.equal(this.serialization.valueSetsName, false, Support.writable(this.serialization.valueSetsEncoder, (Object)value));
            return this;
        }

        public Modifier setValueSets(Iterable<? extends ValueSet> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ValueSet valueSet : values) {
                wrappedValues.add(Support.writable(this.serialization.valueSetsEncoder, (Object)valueSet));
            }
            this.setFields = this.setFields.equal(this.serialization.valueSetsName, false, wrappedValues);
            return this;
        }

        public Modifier addAllValueSets(Iterable<? extends ValueSet> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ValueSet valueSet : values) {
                wrappedValues.add(Support.writable(this.serialization.valueSetsEncoder, (Object)valueSet));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.valueSetsName, false, v);
            return this;
        }

        public Modifier setMetadata(Questionnaire.Metadata value) {
            this.setFields = this.setFields.equal(this.serialization.metadataName, false, Support.writable(this.serialization.metadataEncoder, (Object)value));
            return this;
        }

        public Modifier initMetadata(Questionnaire.Metadata value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.metadataName, false, Support.writable(this.serialization.metadataEncoder, (Object)value));
            return this;
        }
    }

    @Generated(from="Questionnaire", generator="Repositories")
    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<Questionnaire> {
        private final Serialization serialization;

        private Updater(QuestionnaireRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria.constraint;
            this.serialization = repository.serialization;
        }

        public Updater setId(String value) {
            this.setFields = this.setFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Updater initId(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Updater setRev(String value) {
            this.setFields = this.setFields.equal(this.serialization.revName, false, Support.writable((Object)value));
            return this;
        }

        public Updater initRev(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.revName, false, Support.writable((Object)value));
            return this;
        }

        public Updater clearAnswers() {
            this.unsetFields = this.unsetFields.equal(this.serialization.answersName, false, (Object)1);
            return this;
        }

        public Updater removeAnswers(Answer value) {
            this.pullFields = this.pullFields.equal(this.serialization.answersName, false, Support.writable(this.serialization.answersEncoder, (Object)value));
            return this;
        }

        public Updater addAnswers(Answer value) {
            this.pushFields = this.pushFields.equal(this.serialization.answersName, false, Support.writable(this.serialization.answersEncoder, (Object)value));
            return this;
        }

        public Updater setAnswers(Iterable<? extends Answer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Answer answer : values) {
                wrappedValues.add(Support.writable(this.serialization.answersEncoder, (Object)answer));
            }
            this.setFields = this.setFields.equal(this.serialization.answersName, false, wrappedValues);
            return this;
        }

        public Updater addAllAnswers(Iterable<? extends Answer> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Answer answer : values) {
                wrappedValues.add(Support.writable(this.serialization.answersEncoder, (Object)answer));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.answersName, false, v);
            return this;
        }

        public Updater clearContext() {
            this.unsetFields = this.unsetFields.equal(this.serialization.contextName, false, (Object)1);
            return this;
        }

        public Updater removeContext(ContextValue value) {
            this.pullFields = this.pullFields.equal(this.serialization.contextName, false, Support.writable(this.serialization.contextEncoder, (Object)value));
            return this;
        }

        public Updater addContext(ContextValue value) {
            this.pushFields = this.pushFields.equal(this.serialization.contextName, false, Support.writable(this.serialization.contextEncoder, (Object)value));
            return this;
        }

        public Updater setContext(Iterable<? extends ContextValue> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ContextValue contextValue : values) {
                wrappedValues.add(Support.writable(this.serialization.contextEncoder, (Object)contextValue));
            }
            this.setFields = this.setFields.equal(this.serialization.contextName, false, wrappedValues);
            return this;
        }

        public Updater addAllContext(Iterable<? extends ContextValue> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ContextValue contextValue : values) {
                wrappedValues.add(Support.writable(this.serialization.contextEncoder, (Object)contextValue));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.contextName, false, v);
            return this;
        }

        public Updater setActiveItem(String value) {
            this.setFields = this.setFields.equal(this.serialization.activeItemName, false, Support.writable((Object)value));
            return this;
        }

        public Updater initActiveItem(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.activeItemName, false, Support.writable((Object)value));
            return this;
        }

        public Updater clearErrors() {
            this.unsetFields = this.unsetFields.equal(this.serialization.errorsName, false, (Object)1);
            return this;
        }

        public Updater removeErrors(Error value) {
            this.pullFields = this.pullFields.equal(this.serialization.errorsName, false, Support.writable(this.serialization.errorsEncoder, (Object)value));
            return this;
        }

        public Updater addErrors(Error value) {
            this.pushFields = this.pushFields.equal(this.serialization.errorsName, false, Support.writable(this.serialization.errorsEncoder, (Object)value));
            return this;
        }

        public Updater setErrors(Iterable<? extends Error> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Error error : values) {
                wrappedValues.add(Support.writable(this.serialization.errorsEncoder, (Object)error));
            }
            this.setFields = this.setFields.equal(this.serialization.errorsName, false, wrappedValues);
            return this;
        }

        public Updater addAllErrors(Iterable<? extends Error> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Error error : values) {
                wrappedValues.add(Support.writable(this.serialization.errorsEncoder, (Object)error));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.errorsName, false, v);
            return this;
        }

        public Updater clearVariableValues() {
            this.unsetFields = this.unsetFields.equal(this.serialization.variableValuesName, false, (Object)1);
            return this;
        }

        public Updater removeVariableValues(VariableValue value) {
            this.pullFields = this.pullFields.equal(this.serialization.variableValuesName, false, Support.writable(this.serialization.variableValuesEncoder, (Object)value));
            return this;
        }

        public Updater addVariableValues(VariableValue value) {
            this.pushFields = this.pushFields.equal(this.serialization.variableValuesName, false, Support.writable(this.serialization.variableValuesEncoder, (Object)value));
            return this;
        }

        public Updater setVariableValues(Iterable<? extends VariableValue> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (VariableValue variableValue : values) {
                wrappedValues.add(Support.writable(this.serialization.variableValuesEncoder, (Object)variableValue));
            }
            this.setFields = this.setFields.equal(this.serialization.variableValuesName, false, wrappedValues);
            return this;
        }

        public Updater addAllVariableValues(Iterable<? extends VariableValue> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (VariableValue variableValue : values) {
                wrappedValues.add(Support.writable(this.serialization.variableValuesEncoder, (Object)variableValue));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.variableValuesName, false, v);
            return this;
        }

        public Updater clearValueSets() {
            this.unsetFields = this.unsetFields.equal(this.serialization.valueSetsName, false, (Object)1);
            return this;
        }

        public Updater removeValueSets(ValueSet value) {
            this.pullFields = this.pullFields.equal(this.serialization.valueSetsName, false, Support.writable(this.serialization.valueSetsEncoder, (Object)value));
            return this;
        }

        public Updater addValueSets(ValueSet value) {
            this.pushFields = this.pushFields.equal(this.serialization.valueSetsName, false, Support.writable(this.serialization.valueSetsEncoder, (Object)value));
            return this;
        }

        public Updater setValueSets(Iterable<? extends ValueSet> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ValueSet valueSet : values) {
                wrappedValues.add(Support.writable(this.serialization.valueSetsEncoder, (Object)valueSet));
            }
            this.setFields = this.setFields.equal(this.serialization.valueSetsName, false, wrappedValues);
            return this;
        }

        public Updater addAllValueSets(Iterable<? extends ValueSet> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (ValueSet valueSet : values) {
                wrappedValues.add(Support.writable(this.serialization.valueSetsEncoder, (Object)valueSet));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.valueSetsName, false, v);
            return this;
        }

        public Updater setMetadata(Questionnaire.Metadata value) {
            this.setFields = this.setFields.equal(this.serialization.metadataName, false, Support.writable(this.serialization.metadataEncoder, (Object)value));
            return this;
        }

        public Updater initMetadata(Questionnaire.Metadata value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.metadataName, false, Support.writable(this.serialization.metadataEncoder, (Object)value));
            return this;
        }
    }

    @Generated(from="Questionnaire", generator="Repositories")
    @NotThreadSafe
    public static final class Finder
    extends Repositories.FinderWithDelete<Questionnaire, Finder> {
        private final Serialization serialization;

        private Finder(QuestionnaireRepository repository, Constraints.ConstraintHost criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria;
            this.serialization = repository.serialization;
        }

        public Finder orderById() {
            this.ordering = this.ordering.equal(this.serialization.idName, false, (Object)1);
            return this;
        }

        public Finder orderByIdDesceding() {
            this.ordering = this.ordering.equal(this.serialization.idName, false, (Object)-1);
            return this;
        }

        public Finder orderByRev() {
            this.ordering = this.ordering.equal(this.serialization.revName, false, (Object)1);
            return this;
        }

        public Finder orderByRevDesceding() {
            this.ordering = this.ordering.equal(this.serialization.revName, false, (Object)-1);
            return this;
        }

        public Finder orderByAnswers() {
            this.ordering = this.ordering.equal(this.serialization.answersName, false, (Object)1);
            return this;
        }

        public Finder orderByAnswersDesceding() {
            this.ordering = this.ordering.equal(this.serialization.answersName, false, (Object)-1);
            return this;
        }

        public Finder orderByContext() {
            this.ordering = this.ordering.equal(this.serialization.contextName, false, (Object)1);
            return this;
        }

        public Finder orderByContextDesceding() {
            this.ordering = this.ordering.equal(this.serialization.contextName, false, (Object)-1);
            return this;
        }

        public Finder orderByActiveItem() {
            this.ordering = this.ordering.equal(this.serialization.activeItemName, false, (Object)1);
            return this;
        }

        public Finder orderByActiveItemDesceding() {
            this.ordering = this.ordering.equal(this.serialization.activeItemName, false, (Object)-1);
            return this;
        }

        public Finder orderByErrors() {
            this.ordering = this.ordering.equal(this.serialization.errorsName, false, (Object)1);
            return this;
        }

        public Finder orderByErrorsDesceding() {
            this.ordering = this.ordering.equal(this.serialization.errorsName, false, (Object)-1);
            return this;
        }

        public Finder orderByVariableValues() {
            this.ordering = this.ordering.equal(this.serialization.variableValuesName, false, (Object)1);
            return this;
        }

        public Finder orderByVariableValuesDesceding() {
            this.ordering = this.ordering.equal(this.serialization.variableValuesName, false, (Object)-1);
            return this;
        }

        public Finder orderByValueSets() {
            this.ordering = this.ordering.equal(this.serialization.valueSetsName, false, (Object)1);
            return this;
        }

        public Finder orderByValueSetsDesceding() {
            this.ordering = this.ordering.equal(this.serialization.valueSetsName, false, (Object)-1);
            return this;
        }

        public Finder orderByMetadata() {
            this.ordering = this.ordering.equal(this.serialization.metadataName, false, (Object)1);
            return this;
        }

        public Finder orderByMetadataDesceding() {
            this.ordering = this.ordering.equal(this.serialization.metadataName, false, (Object)-1);
            return this;
        }

        public Finder excludeAnswers() {
            this.exclusion = this.exclusion.equal(this.serialization.answersName, false, (Object)-1);
            return this;
        }

        public Finder excludeContext() {
            this.exclusion = this.exclusion.equal(this.serialization.contextName, false, (Object)-1);
            return this;
        }

        public Finder excludeErrors() {
            this.exclusion = this.exclusion.equal(this.serialization.errorsName, false, (Object)-1);
            return this;
        }

        public Finder excludeVariableValues() {
            this.exclusion = this.exclusion.equal(this.serialization.variableValuesName, false, (Object)-1);
            return this;
        }

        public Finder excludeValueSets() {
            this.exclusion = this.exclusion.equal(this.serialization.valueSetsName, false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier((QuestionnaireRepository)this.repository, this.criteria, this.ordering, this.exclusion);
        }

        @CheckReturnValue
        public Replacer andReplaceFirst(Questionnaire document) {
            return new Replacer((QuestionnaireRepository)this.repository, document, this.criteria, this.ordering);
        }
    }
}

