/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.proto.ImmutableValueSet;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableAnswer;
import io.dialob.api.questionnaire.ImmutableContextValue;
import io.dialob.api.questionnaire.ImmutableError;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.ImmutableVariableValue;
import io.dialob.api.questionnaire.ModifiableQuestionnaire;
import io.dialob.api.questionnaire.ModifiableQuestionnaireMetadata;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.VariableValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Questionnaire", generator="Immutables")
@Immutable
public final class ImmutableQuestionnaire
implements Questionnaire {
    private final String id;
    private final String rev;
    private final List<Answer> answers;
    private final List<ContextValue> context;
    private final String activeItem;
    private final List<Error> errors;
    private final List<VariableValue> variableValues;
    private final List<ValueSet> valueSets;
    private final ImmutableQuestionnaireMetadata metadata;

    private ImmutableQuestionnaire(String id, String rev, List<Answer> answers, List<ContextValue> context, String activeItem, List<Error> errors, List<VariableValue> variableValues, List<ValueSet> valueSets, ImmutableQuestionnaireMetadata metadata) {
        this.id = id;
        this.rev = rev;
        this.answers = answers;
        this.context = context;
        this.activeItem = activeItem;
        this.errors = errors;
        this.variableValues = variableValues;
        this.valueSets = valueSets;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="_rev")
    public String getRev() {
        return this.rev;
    }

    @Override
    @JsonProperty(value="answers")
    public List<Answer> getAnswers() {
        return this.answers;
    }

    @Override
    @JsonProperty(value="context")
    public List<ContextValue> getContext() {
        return this.context;
    }

    @Override
    @JsonProperty(value="activeItem")
    public String getActiveItem() {
        return this.activeItem;
    }

    @Override
    @JsonProperty(value="errors")
    public List<Error> getErrors() {
        return this.errors;
    }

    @Override
    @JsonProperty(value="variableValues")
    public List<VariableValue> getVariableValues() {
        return this.variableValues;
    }

    @Override
    @JsonProperty(value="valueSets")
    public List<ValueSet> getValueSets() {
        return this.valueSets;
    }

    @Override
    @JsonProperty(value="metadata")
    public ImmutableQuestionnaireMetadata getMetadata() {
        return this.metadata;
    }

    public final ImmutableQuestionnaire withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(value, this.rev, this.answers, this.context, this.activeItem, this.errors, this.variableValues, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withRev(String value) {
        if (Objects.equals(this.rev, value)) {
            return this;
        }
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, value, this.answers, this.context, this.activeItem, this.errors, this.variableValues, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withAnswers(Answer ... elements) {
        List<Answer> newValue = ImmutableQuestionnaire.createUnmodifiableList(false, ImmutableQuestionnaire.createSafeList(Arrays.asList(elements), false, false));
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, newValue, this.context, this.activeItem, this.errors, this.variableValues, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withAnswers(Iterable<? extends Answer> elements) {
        if (this.answers == elements) {
            return this;
        }
        List<Answer> newValue = ImmutableQuestionnaire.createUnmodifiableList(false, ImmutableQuestionnaire.createSafeList(elements, false, false));
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, newValue, this.context, this.activeItem, this.errors, this.variableValues, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withContext(ContextValue ... elements) {
        List<ContextValue> newValue = ImmutableQuestionnaire.createUnmodifiableList(false, ImmutableQuestionnaire.createSafeList(Arrays.asList(elements), false, false));
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, this.answers, newValue, this.activeItem, this.errors, this.variableValues, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withContext(Iterable<? extends ContextValue> elements) {
        if (this.context == elements) {
            return this;
        }
        List<ContextValue> newValue = ImmutableQuestionnaire.createUnmodifiableList(false, ImmutableQuestionnaire.createSafeList(elements, false, false));
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, this.answers, newValue, this.activeItem, this.errors, this.variableValues, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withActiveItem(String value) {
        if (Objects.equals(this.activeItem, value)) {
            return this;
        }
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, this.answers, this.context, value, this.errors, this.variableValues, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withErrors(Error ... elements) {
        List<Error> newValue = ImmutableQuestionnaire.createUnmodifiableList(false, ImmutableQuestionnaire.createSafeList(Arrays.asList(elements), false, false));
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, this.answers, this.context, this.activeItem, newValue, this.variableValues, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withErrors(Iterable<? extends Error> elements) {
        if (this.errors == elements) {
            return this;
        }
        List<Error> newValue = ImmutableQuestionnaire.createUnmodifiableList(false, ImmutableQuestionnaire.createSafeList(elements, false, false));
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, this.answers, this.context, this.activeItem, newValue, this.variableValues, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withVariableValues(VariableValue ... elements) {
        List<VariableValue> newValue = ImmutableQuestionnaire.createUnmodifiableList(false, ImmutableQuestionnaire.createSafeList(Arrays.asList(elements), false, false));
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, this.answers, this.context, this.activeItem, this.errors, newValue, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withVariableValues(Iterable<? extends VariableValue> elements) {
        if (this.variableValues == elements) {
            return this;
        }
        List<VariableValue> newValue = ImmutableQuestionnaire.createUnmodifiableList(false, ImmutableQuestionnaire.createSafeList(elements, false, false));
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, this.answers, this.context, this.activeItem, this.errors, newValue, this.valueSets, this.metadata));
    }

    public final ImmutableQuestionnaire withValueSets(ValueSet ... elements) {
        List<ValueSet> newValue = ImmutableQuestionnaire.createUnmodifiableList(false, ImmutableQuestionnaire.createSafeList(Arrays.asList(elements), false, false));
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, this.answers, this.context, this.activeItem, this.errors, this.variableValues, newValue, this.metadata));
    }

    public final ImmutableQuestionnaire withValueSets(Iterable<? extends ValueSet> elements) {
        if (this.valueSets == elements) {
            return this;
        }
        List<ValueSet> newValue = ImmutableQuestionnaire.createUnmodifiableList(false, ImmutableQuestionnaire.createSafeList(elements, false, false));
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, this.answers, this.context, this.activeItem, this.errors, this.variableValues, newValue, this.metadata));
    }

    public final ImmutableQuestionnaire withMetadata(Questionnaire.Metadata value) {
        if (this.metadata == value) {
            return this;
        }
        ImmutableQuestionnaireMetadata newValue = value == null ? null : ImmutableQuestionnaireMetadata.copyOf(value);
        return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, this.answers, this.context, this.activeItem, this.errors, this.variableValues, this.valueSets, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQuestionnaire && this.equalTo((ImmutableQuestionnaire)another);
    }

    private boolean equalTo(ImmutableQuestionnaire another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.rev, another.rev) && this.answers.equals(another.answers) && this.context.equals(another.context) && Objects.equals(this.activeItem, another.activeItem) && this.errors.equals(another.errors) && this.variableValues.equals(another.variableValues) && this.valueSets.equals(another.valueSets) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.rev);
        h += (h << 5) + this.answers.hashCode();
        h += (h << 5) + this.context.hashCode();
        h += (h << 5) + Objects.hashCode(this.activeItem);
        h += (h << 5) + this.errors.hashCode();
        h += (h << 5) + this.variableValues.hashCode();
        h += (h << 5) + this.valueSets.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "Questionnaire{id=" + this.id + ", rev=" + this.rev + ", answers=" + this.answers + ", context=" + this.context + ", activeItem=" + this.activeItem + ", errors=" + this.errors + ", variableValues=" + this.variableValues + ", valueSets=" + this.valueSets + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableQuestionnaire fromJson(Json json) {
        Builder builder = ImmutableQuestionnaire.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.rev != null) {
            builder.rev(json.rev);
        }
        if (json.answers != null) {
            builder.addAllAnswers(json.answers);
        }
        if (json.context != null) {
            builder.addAllContext(json.context);
        }
        if (json.activeItem != null) {
            builder.activeItem(json.activeItem);
        }
        if (json.errors != null) {
            builder.addAllErrors(json.errors);
        }
        if (json.variableValues != null) {
            builder.addAllVariableValues(json.variableValues);
        }
        if (json.valueSets != null) {
            builder.addAllValueSets(json.valueSets);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    private static ImmutableQuestionnaire validate(ImmutableQuestionnaire instance) {
        instance = (ImmutableQuestionnaire)instance.validate();
        return instance;
    }

    public static ImmutableQuestionnaire copyOf(Questionnaire instance) {
        if (instance instanceof ImmutableQuestionnaire) {
            return (ImmutableQuestionnaire)instance;
        }
        return ImmutableQuestionnaire.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableQuestionnaire.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Questionnaire", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String rev;
        private List<Answer> answers = new ArrayList<Answer>();
        private List<ContextValue> context = new ArrayList<ContextValue>();
        @Nullable
        private String activeItem;
        private List<Error> errors = new ArrayList<Error>();
        private List<VariableValue> variableValues = new ArrayList<VariableValue>();
        private List<ValueSet> valueSets = new ArrayList<ValueSet>();
        @Nullable
        private Questionnaire.Metadata metadata;

        private Builder() {
        }

        public final Builder from(ModifiableQuestionnaire instance) {
            String revValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((revValue = instance.getRev()) != null) {
                this.rev(revValue);
            }
            this.addAllAnswers(instance.getAnswers());
            this.addAllContext(instance.getContext());
            String activeItemValue = instance.getActiveItem();
            if (activeItemValue != null) {
                this.activeItem(activeItemValue);
            }
            this.addAllErrors(instance.getErrors());
            this.addAllVariableValues(instance.getVariableValues());
            this.addAllValueSets(instance.getValueSets());
            ModifiableQuestionnaireMetadata metadataValue = instance.getMetadata();
            if (metadataValue != null) {
                this.metadata(metadataValue);
            }
            return this;
        }

        public final Builder from(Questionnaire instance) {
            String revValue;
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableQuestionnaire) {
                return this.from((ModifiableQuestionnaire)instance);
            }
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((revValue = instance.getRev()) != null) {
                this.rev(revValue);
            }
            this.addAllAnswers(instance.getAnswers());
            this.addAllContext(instance.getContext());
            String activeItemValue = instance.getActiveItem();
            if (activeItemValue != null) {
                this.activeItem(activeItemValue);
            }
            this.addAllErrors(instance.getErrors());
            this.addAllVariableValues(instance.getVariableValues());
            this.addAllValueSets(instance.getValueSets());
            Questionnaire.Metadata metadataValue = instance.getMetadata();
            if (metadataValue != null) {
                this.metadata(metadataValue);
            }
            return this;
        }

        @JsonProperty(value="_id")
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="_rev")
        public final Builder rev(String rev) {
            this.rev = rev;
            return this;
        }

        public final Builder addAnswers(@Nullable Answer element) {
            if (element != null) {
                element = ImmutableAnswer.copyOf(element);
            }
            this.answers.add(element);
            return this;
        }

        public final Builder addAnswers(String id, Object value) {
            return this.addAnswers((Answer)ImmutableAnswer.of(id, value));
        }

        public final Builder addAnswers(Answer ... elements) {
            for (Answer element : elements) {
                if (element != null) {
                    element = ImmutableAnswer.copyOf(element);
                }
                this.answers.add(element);
            }
            return this;
        }

        @JsonProperty(value="answers")
        public final Builder answers(Iterable<? extends Answer> elements) {
            this.answers.clear();
            return this.addAllAnswers(elements);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAllAnswers(Iterable<? extends Answer> elements) {
            for (Answer answer : elements) {
                void var3_3;
                if (answer != null) {
                    ImmutableAnswer immutableAnswer = ImmutableAnswer.copyOf(answer);
                }
                this.answers.add((Answer)var3_3);
            }
            return this;
        }

        public final Builder addContext(@Nullable ContextValue element) {
            if (element != null) {
                element = ImmutableContextValue.copyOf(element);
            }
            this.context.add(element);
            return this;
        }

        public final Builder addContext(String id, Object value) {
            return this.addContext((ContextValue)ImmutableContextValue.of(id, value));
        }

        public final Builder addContext(ContextValue ... elements) {
            for (ContextValue element : elements) {
                if (element != null) {
                    element = ImmutableContextValue.copyOf(element);
                }
                this.context.add(element);
            }
            return this;
        }

        @JsonProperty(value="context")
        public final Builder context(Iterable<? extends ContextValue> elements) {
            this.context.clear();
            return this.addAllContext(elements);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAllContext(Iterable<? extends ContextValue> elements) {
            for (ContextValue contextValue : elements) {
                void var3_3;
                if (contextValue != null) {
                    ImmutableContextValue immutableContextValue = ImmutableContextValue.copyOf(contextValue);
                }
                this.context.add((ContextValue)var3_3);
            }
            return this;
        }

        @JsonProperty(value="activeItem")
        public final Builder activeItem(String activeItem) {
            this.activeItem = activeItem;
            return this;
        }

        public final Builder addErrors(@Nullable Error element) {
            if (element != null) {
                element = ImmutableError.copyOf(element);
            }
            this.errors.add(element);
            return this;
        }

        public final Builder addErrors(String id, String code, String description) {
            return this.addErrors((Error)ImmutableError.of(id, code, description));
        }

        public final Builder addErrors(Error ... elements) {
            for (Error element : elements) {
                if (element != null) {
                    element = ImmutableError.copyOf(element);
                }
                this.errors.add(element);
            }
            return this;
        }

        @JsonProperty(value="errors")
        public final Builder errors(Iterable<? extends Error> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAllErrors(Iterable<? extends Error> elements) {
            for (Error error : elements) {
                void var3_3;
                if (error != null) {
                    ImmutableError immutableError = ImmutableError.copyOf(error);
                }
                this.errors.add((Error)var3_3);
            }
            return this;
        }

        public final Builder addVariableValues(@Nullable VariableValue element) {
            if (element != null) {
                element = ImmutableVariableValue.copyOf(element);
            }
            this.variableValues.add(element);
            return this;
        }

        public final Builder addVariableValues(String id, Object value) {
            return this.addVariableValues((VariableValue)ImmutableVariableValue.of(id, value));
        }

        public final Builder addVariableValues(VariableValue ... elements) {
            for (VariableValue element : elements) {
                if (element != null) {
                    element = ImmutableVariableValue.copyOf(element);
                }
                this.variableValues.add(element);
            }
            return this;
        }

        @JsonProperty(value="variableValues")
        public final Builder variableValues(Iterable<? extends VariableValue> elements) {
            this.variableValues.clear();
            return this.addAllVariableValues(elements);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAllVariableValues(Iterable<? extends VariableValue> elements) {
            for (VariableValue variableValue : elements) {
                void var3_3;
                if (variableValue != null) {
                    ImmutableVariableValue immutableVariableValue = ImmutableVariableValue.copyOf(variableValue);
                }
                this.variableValues.add((VariableValue)var3_3);
            }
            return this;
        }

        public final Builder addValueSets(@Nullable ValueSet element) {
            if (element != null) {
                element = ImmutableValueSet.copyOf(element);
            }
            this.valueSets.add(element);
            return this;
        }

        public final Builder addValueSets(ValueSet ... elements) {
            for (ValueSet element : elements) {
                if (element != null) {
                    element = ImmutableValueSet.copyOf(element);
                }
                this.valueSets.add(element);
            }
            return this;
        }

        @JsonProperty(value="valueSets")
        public final Builder valueSets(Iterable<? extends ValueSet> elements) {
            this.valueSets.clear();
            return this.addAllValueSets(elements);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAllValueSets(Iterable<? extends ValueSet> elements) {
            for (ValueSet valueSet : elements) {
                void var3_3;
                if (valueSet != null) {
                    ImmutableValueSet immutableValueSet = ImmutableValueSet.copyOf(valueSet);
                }
                this.valueSets.add((ValueSet)var3_3);
            }
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(Questionnaire.Metadata metadata) {
            this.metadata = metadata == null ? null : ImmutableQuestionnaireMetadata.copyOf(metadata);
            return this;
        }

        public ImmutableQuestionnaire build() {
            return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(this.id, this.rev, ImmutableQuestionnaire.createUnmodifiableList(true, this.answers), ImmutableQuestionnaire.createUnmodifiableList(true, this.context), this.activeItem, ImmutableQuestionnaire.createUnmodifiableList(true, this.errors), ImmutableQuestionnaire.createUnmodifiableList(true, this.variableValues), ImmutableQuestionnaire.createUnmodifiableList(true, this.valueSets), this.metadata == null ? null : ImmutableQuestionnaireMetadata.copyOf(this.metadata)));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Questionnaire", generator="Immutables")
    static final class Json
    implements Questionnaire {
        @Nullable
        String id;
        @Nullable
        String rev;
        @Nullable
        List<Answer> answers = Collections.emptyList();
        @Nullable
        List<ContextValue> context = Collections.emptyList();
        @Nullable
        String activeItem;
        @Nullable
        List<Error> errors = Collections.emptyList();
        @Nullable
        List<VariableValue> variableValues = Collections.emptyList();
        @Nullable
        List<ValueSet> valueSets = Collections.emptyList();
        @Nullable
        Questionnaire.Metadata metadata;

        Json() {
        }

        @JsonProperty(value="_id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="_rev")
        public void setRev(String rev) {
            this.rev = rev;
        }

        @JsonProperty(value="answers")
        public void setAnswers(List<Answer> answers) {
            this.answers = answers;
        }

        @JsonProperty(value="context")
        public void setContext(List<ContextValue> context) {
            this.context = context;
        }

        @JsonProperty(value="activeItem")
        public void setActiveItem(String activeItem) {
            this.activeItem = activeItem;
        }

        @JsonProperty(value="errors")
        public void setErrors(List<Error> errors) {
            this.errors = errors;
        }

        @JsonProperty(value="variableValues")
        public void setVariableValues(List<VariableValue> variableValues) {
            this.variableValues = variableValues;
        }

        @JsonProperty(value="valueSets")
        public void setValueSets(List<ValueSet> valueSets) {
            this.valueSets = valueSets;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(Questionnaire.Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Answer> getAnswers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ContextValue> getContext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActiveItem() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Error> getErrors() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<VariableValue> getVariableValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ValueSet> getValueSets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Questionnaire.Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

