/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ImmutableAnswer;
import java.io.IOException;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.questionnaire", generator="Gsons")
public final class GsonAdaptersAnswer
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (AnswerTypeAdapter.adapts(type)) {
            return new AnswerTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersAnswer(Answer)";
    }

    @Generated(from="Answer", generator="Gsons")
    private static class AnswerTypeAdapter
    extends TypeAdapter<Answer> {
        public final Object valueTypeSample = null;
        public final Object acceptedValueTypeSample = null;
        public final Date updatedTypeSample = null;
        private final TypeAdapter<Object> valueTypeAdapter;
        private final TypeAdapter<Object> acceptedValueTypeAdapter;
        private final TypeAdapter<Date> updatedTypeAdapter;

        AnswerTypeAdapter(Gson gson) {
            this.valueTypeAdapter = gson.getAdapter(Object.class);
            this.acceptedValueTypeAdapter = gson.getAdapter(Object.class);
            this.updatedTypeAdapter = gson.getAdapter(Date.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Answer.class == type.getRawType() || ImmutableAnswer.class == type.getRawType();
        }

        public void write(JsonWriter out, Answer value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeAnswer(out, value);
            }
        }

        public Answer read(JsonReader in) throws IOException {
            return this.readAnswer(in);
        }

        private void writeAnswer(JsonWriter out, Answer instance) throws IOException {
            out.beginObject();
            String idValue = instance.getId();
            if (idValue != null) {
                out.name("id");
                out.value(idValue);
            } else if (out.getSerializeNulls()) {
                out.name("id");
                out.nullValue();
            }
            Object valueValue = instance.getValue();
            if (valueValue != null) {
                out.name("value");
                this.valueTypeAdapter.write(out, valueValue);
            } else if (out.getSerializeNulls()) {
                out.name("value");
                out.nullValue();
            }
            String typeValue = instance.getType();
            if (typeValue != null) {
                out.name("type");
                out.value(typeValue);
            } else if (out.getSerializeNulls()) {
                out.name("type");
                out.nullValue();
            }
            Object acceptedValueValue = instance.getAcceptedValue();
            if (acceptedValueValue != null) {
                out.name("acceptedValue");
                this.acceptedValueTypeAdapter.write(out, acceptedValueValue);
            } else if (out.getSerializeNulls()) {
                out.name("acceptedValue");
                out.nullValue();
            }
            Date updatedValue = instance.getUpdated();
            if (updatedValue != null) {
                out.name("updated");
                this.updatedTypeAdapter.write(out, (Object)updatedValue);
            } else if (out.getSerializeNulls()) {
                out.name("updated");
                out.nullValue();
            }
            String userIdValue = instance.getUserId();
            if (userIdValue != null) {
                out.name("userId");
                out.value(userIdValue);
            } else if (out.getSerializeNulls()) {
                out.name("userId");
                out.nullValue();
            }
            out.endObject();
        }

        private Answer readAnswer(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableAnswer.Builder builder = ImmutableAnswer.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableAnswer.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'i': {
                    if (!"id".equals(attributeName)) break;
                    this.readInId(in, builder);
                    return;
                }
                case 'v': {
                    if (!"value".equals(attributeName)) break;
                    this.readInValue(in, builder);
                    return;
                }
                case 't': {
                    if (!"type".equals(attributeName)) break;
                    this.readInType(in, builder);
                    return;
                }
                case 'a': {
                    if (!"acceptedValue".equals(attributeName)) break;
                    this.readInAcceptedValue(in, builder);
                    return;
                }
                case 'u': {
                    if ("updated".equals(attributeName)) {
                        this.readInUpdated(in, builder);
                        return;
                    }
                    if (!"userId".equals(attributeName)) break;
                    this.readInUserId(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableAnswer.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.id(in.nextString());
            }
        }

        private void readInValue(JsonReader in, ImmutableAnswer.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Object value = this.valueTypeAdapter.read(in);
                builder.value(value);
            }
        }

        private void readInType(JsonReader in, ImmutableAnswer.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.type(in.nextString());
            }
        }

        private void readInAcceptedValue(JsonReader in, ImmutableAnswer.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Object value = this.acceptedValueTypeAdapter.read(in);
                builder.acceptedValue(value);
            }
        }

        private void readInUpdated(JsonReader in, ImmutableAnswer.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Date value = (Date)this.updatedTypeAdapter.read(in);
                builder.updated(value);
            }
        }

        private void readInUserId(JsonReader in, ImmutableAnswer.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.userId(in.nextString());
            }
        }
    }
}

