/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.proto;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.proto.ImmutableValueSet;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.proto.ValueSetEntry;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.proto", generator="Gsons")
public final class GsonAdaptersValueSet
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ValueSetTypeAdapter.adapts(type)) {
            return new ValueSetTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersValueSet(ValueSet)";
    }

    @Generated(from="ValueSet", generator="Gsons")
    private static class ValueSetTypeAdapter
    extends TypeAdapter<ValueSet> {
        public final ValueSetEntry entriesTypeSample = null;
        private final TypeAdapter<ValueSetEntry> entriesTypeAdapter;

        ValueSetTypeAdapter(Gson gson) {
            this.entriesTypeAdapter = gson.getAdapter(ValueSetEntry.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return ValueSet.class == type.getRawType() || ImmutableValueSet.class == type.getRawType();
        }

        public void write(JsonWriter out, ValueSet value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeValueSet(out, value);
            }
        }

        public ValueSet read(JsonReader in) throws IOException {
            return this.readValueSet(in);
        }

        private void writeValueSet(JsonWriter out, ValueSet instance) throws IOException {
            out.beginObject();
            out.name("id");
            out.value(instance.getId());
            List<ValueSetEntry> entriesElements = instance.getEntries();
            if (!entriesElements.isEmpty()) {
                out.name("entries");
                out.beginArray();
                for (ValueSetEntry e : entriesElements) {
                    this.entriesTypeAdapter.write(out, (Object)e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("entries");
                out.beginArray();
                out.endArray();
            }
            out.endObject();
        }

        private ValueSet readValueSet(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableValueSet.Builder builder = ImmutableValueSet.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableValueSet.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'i': {
                    if (!"id".equals(attributeName)) break;
                    this.readInId(in, builder);
                    return;
                }
                case 'e': {
                    if (!"entries".equals(attributeName)) break;
                    this.readInEntries(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableValueSet.Builder builder) throws IOException {
            builder.id(in.nextString());
        }

        private void readInEntries(JsonReader in, ImmutableValueSet.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    ValueSetEntry value = (ValueSetEntry)this.entriesTypeAdapter.read(in);
                    builder.addEntries(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                ValueSetEntry value = (ValueSetEntry)this.entriesTypeAdapter.read(in);
                builder.addEntries(value);
            }
        }
    }
}

