/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.proto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Error;
import java.io.Serializable;
import java.util.List;
import org.immutables.gson.Gson;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableAction.class)
@JsonDeserialize(as=ImmutableAction.class)
@JsonInclude(content=JsonInclude.Include.NON_NULL, value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@Gson.TypeAdapters(emptyAsNulls=true)
@Value.Style(jdkOnly=true)
public interface Action
extends Serializable {
    public Type getType();

    public String getId();

    public String getMessage();

    public String getTrace();

    public ActionItem getItem();

    public Error getError();

    public Object getAnswer();

    public List<String> getIds();

    public Object getValue();

    public ValueSet getValueSet();

    @JsonIgnore
    public Boolean getServerEvent();

    @JsonIgnore
    public String getResourceId();

    public static enum Type {
        ANSWER(true),
        NEXT(true),
        PREVIOUS(true),
        GOTO(true),
        COMPLETE(true),
        ADD_ROW(true),
        DELETE_ROW(true),
        REMOVE_ANSWERS(true),
        RESET(false),
        ITEM(false),
        REMOVE_ITEMS(false),
        ERROR(false),
        REMOVE_ERROR(false),
        VALUE_SET(false),
        REMOVE_VALUE_SETS(false),
        NOT_FOUND(false),
        SERVER_ERROR(false),
        ROWS(false),
        SET_VALUE(false),
        SET_FAILED(false),
        LOCALE(false),
        SET_LOCALE(true);

        final boolean clientAction;

        private Type(boolean clientAction) {
            this.clientAction = clientAction;
        }

        public boolean isClientAction() {
            return this.clientAction;
        }
    }
}

