/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.form.FormValueSet;
import io.dialob.api.form.FormValueSetEntry;
import io.dialob.api.form.ModifiableFormValueSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FormValueSet", generator="Immutables")
@Immutable
public final class ImmutableFormValueSet
implements FormValueSet {
    private final String id;
    private final List<FormValueSetEntry> entries;
    private final Map<String, Object> additionalProperties;

    private ImmutableFormValueSet(String id, List<FormValueSetEntry> entries, Map<String, Object> additionalProperties) {
        this.id = id;
        this.entries = entries;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="entries")
    public List<FormValueSetEntry> getEntries() {
        return this.entries;
    }

    @Override
    @JsonProperty(value="additionalProperties")
    @JsonInclude
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public final ImmutableFormValueSet withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableFormValueSet(value, this.entries, this.additionalProperties);
    }

    public final ImmutableFormValueSet withEntries(FormValueSetEntry ... elements) {
        List<FormValueSetEntry> newValue = ImmutableFormValueSet.createUnmodifiableList(false, ImmutableFormValueSet.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableFormValueSet(this.id, newValue, this.additionalProperties);
    }

    public final ImmutableFormValueSet withEntries(Iterable<? extends FormValueSetEntry> elements) {
        if (this.entries == elements) {
            return this;
        }
        List<FormValueSetEntry> newValue = ImmutableFormValueSet.createUnmodifiableList(false, ImmutableFormValueSet.createSafeList(elements, false, false));
        return new ImmutableFormValueSet(this.id, newValue, this.additionalProperties);
    }

    public final ImmutableFormValueSet withAdditionalProperties(Map<String, ? extends Object> entries) {
        if (this.additionalProperties == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableFormValueSet.createUnmodifiableMap(false, false, entries);
        return new ImmutableFormValueSet(this.id, this.entries, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormValueSet && this.equalTo((ImmutableFormValueSet)another);
    }

    private boolean equalTo(ImmutableFormValueSet another) {
        return Objects.equals(this.id, another.id) && this.entries.equals(another.entries) && this.additionalProperties.equals(another.additionalProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.entries.hashCode();
        h += (h << 5) + this.additionalProperties.hashCode();
        return h;
    }

    public String toString() {
        return "FormValueSet{id=" + this.id + ", entries=" + this.entries + ", additionalProperties=" + this.additionalProperties + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormValueSet fromJson(Json json) {
        Builder builder = ImmutableFormValueSet.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.entries != null) {
            builder.addAllEntries(json.entries);
        }
        if (json.additionalProperties != null) {
            builder.putAllAdditionalProperties(json.additionalProperties);
        }
        return builder.build();
    }

    public static ImmutableFormValueSet copyOf(FormValueSet instance) {
        if (instance instanceof ImmutableFormValueSet) {
            return (ImmutableFormValueSet)instance;
        }
        return ImmutableFormValueSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="FormValueSet", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        private List<FormValueSetEntry> entries = new ArrayList<FormValueSetEntry>();
        private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public final Builder from(ModifiableFormValueSet instance) {
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            this.addAllEntries(instance.getEntries());
            this.putAllAdditionalProperties(instance.getAdditionalProperties());
            return this;
        }

        public final Builder from(FormValueSet instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableFormValueSet) {
                return this.from((ModifiableFormValueSet)instance);
            }
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            this.addAllEntries(instance.getEntries());
            this.putAllAdditionalProperties(instance.getAdditionalProperties());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Builder addEntries(@Nullable FormValueSetEntry element) {
            this.entries.add(element);
            return this;
        }

        public final Builder addEntries(FormValueSetEntry ... elements) {
            for (FormValueSetEntry element : elements) {
                this.entries.add(element);
            }
            return this;
        }

        @JsonProperty(value="entries")
        public final Builder entries(Iterable<? extends FormValueSetEntry> elements) {
            this.entries.clear();
            return this.addAllEntries(elements);
        }

        public final Builder addAllEntries(Iterable<? extends FormValueSetEntry> elements) {
            for (FormValueSetEntry formValueSetEntry : elements) {
                this.entries.add(formValueSetEntry);
            }
            return this;
        }

        @JsonAnySetter
        public final Builder putAdditionalProperties(@Nullable String key, @Nullable Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public final Builder putAdditionalProperties(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.additionalProperties.put(k, v);
            return this;
        }

        @JsonProperty(value="additionalProperties")
        @JsonInclude
        public final Builder additionalProperties(Map<String, ? extends Object> entries) {
            this.additionalProperties.clear();
            return this.putAllAdditionalProperties(entries);
        }

        public final Builder putAllAdditionalProperties(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.additionalProperties.put(k, v);
            }
            return this;
        }

        public ImmutableFormValueSet build() {
            return new ImmutableFormValueSet(this.id, ImmutableFormValueSet.createUnmodifiableList(true, this.entries), ImmutableFormValueSet.createUnmodifiableMap(false, false, this.additionalProperties));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FormValueSet", generator="Immutables")
    static final class Json
    implements FormValueSet {
        @Nullable
        String id;
        @Nullable
        List<FormValueSetEntry> entries = Collections.emptyList();
        final Map<String, Object> additionalProperties = new HashMap<String, Object>();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="entries")
        public void setEntries(List<FormValueSetEntry> entries) {
            this.entries = entries;
        }

        @JsonAnySetter
        public void setAdditionalProperties(String key, Object value) {
            this.additionalProperties.put(key, value);
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FormValueSetEntry> getEntries() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getAdditionalProperties() {
            throw new UnsupportedOperationException();
        }
    }
}

