/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.form.FormValidationError;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FormValidationError", generator="Immutables")
@Immutable
public final class ImmutableFormValidationError
implements FormValidationError {
    private final String itemId;
    private final String message;
    private final FormValidationError.Level level;
    private final FormValidationError.Type type;
    @Nullable
    private final String expression;
    @Nullable
    private final Integer startIndex;
    @Nullable
    private final Integer endIndex;
    @Nullable
    private final Integer index;

    private ImmutableFormValidationError(Builder builder) {
        this.itemId = builder.itemId;
        this.message = builder.message;
        this.type = builder.type;
        this.expression = builder.expression;
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
        this.index = builder.index;
        this.level = builder.level != null ? builder.level : Objects.requireNonNull(FormValidationError.super.getLevel(), "level");
    }

    private ImmutableFormValidationError(String itemId, String message, FormValidationError.Level level, FormValidationError.Type type, @Nullable String expression, @Nullable Integer startIndex, @Nullable Integer endIndex, @Nullable Integer index) {
        this.itemId = itemId;
        this.message = message;
        this.level = level;
        this.type = type;
        this.expression = expression;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.index = index;
    }

    @Override
    @JsonProperty(value="itemId")
    public String getItemId() {
        return this.itemId;
    }

    @Override
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty(value="level")
    public FormValidationError.Level getLevel() {
        return this.level;
    }

    @Override
    @JsonProperty(value="type")
    public FormValidationError.Type getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="expression")
    public Optional<String> getExpression() {
        return Optional.ofNullable(this.expression);
    }

    @Override
    @JsonProperty(value="startIndex")
    public Optional<Integer> getStartIndex() {
        return Optional.ofNullable(this.startIndex);
    }

    @Override
    @JsonProperty(value="endIndex")
    public Optional<Integer> getEndIndex() {
        return Optional.ofNullable(this.endIndex);
    }

    @Override
    @JsonProperty(value="index")
    public Optional<Integer> getIndex() {
        return Optional.ofNullable(this.index);
    }

    public final ImmutableFormValidationError withItemId(String value) {
        if (Objects.equals(this.itemId, value)) {
            return this;
        }
        return new ImmutableFormValidationError(value, this.message, this.level, this.type, this.expression, this.startIndex, this.endIndex, this.index);
    }

    public final ImmutableFormValidationError withMessage(String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, value, this.level, this.type, this.expression, this.startIndex, this.endIndex, this.index);
    }

    public final ImmutableFormValidationError withLevel(FormValidationError.Level value) {
        if (this.level == value) {
            return this;
        }
        FormValidationError.Level newValue = Objects.requireNonNull(value, "level");
        if (this.level.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, this.message, newValue, this.type, this.expression, this.startIndex, this.endIndex, this.index);
    }

    public final ImmutableFormValidationError withType(FormValidationError.Type value) {
        if (this.type == value) {
            return this;
        }
        if (Objects.equals((Object)this.type, (Object)value)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, this.message, this.level, value, this.expression, this.startIndex, this.endIndex, this.index);
    }

    public final ImmutableFormValidationError withExpression(String value) {
        String newValue = Objects.requireNonNull(value, "expression");
        if (Objects.equals(this.expression, newValue)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, this.message, this.level, this.type, newValue, this.startIndex, this.endIndex, this.index);
    }

    public final ImmutableFormValidationError withExpression(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.expression, value)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, this.message, this.level, this.type, value, this.startIndex, this.endIndex, this.index);
    }

    public final ImmutableFormValidationError withStartIndex(int value) {
        Integer newValue = value;
        if (Objects.equals(this.startIndex, newValue)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, this.message, this.level, this.type, this.expression, newValue, this.endIndex, this.index);
    }

    public final ImmutableFormValidationError withStartIndex(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.startIndex, value)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, this.message, this.level, this.type, this.expression, value, this.endIndex, this.index);
    }

    public final ImmutableFormValidationError withEndIndex(int value) {
        Integer newValue = value;
        if (Objects.equals(this.endIndex, newValue)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, this.message, this.level, this.type, this.expression, this.startIndex, newValue, this.index);
    }

    public final ImmutableFormValidationError withEndIndex(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.endIndex, value)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, this.message, this.level, this.type, this.expression, this.startIndex, value, this.index);
    }

    public final ImmutableFormValidationError withIndex(int value) {
        Integer newValue = value;
        if (Objects.equals(this.index, newValue)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, this.message, this.level, this.type, this.expression, this.startIndex, this.endIndex, newValue);
    }

    public final ImmutableFormValidationError withIndex(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.index, value)) {
            return this;
        }
        return new ImmutableFormValidationError(this.itemId, this.message, this.level, this.type, this.expression, this.startIndex, this.endIndex, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormValidationError && this.equalTo((ImmutableFormValidationError)another);
    }

    private boolean equalTo(ImmutableFormValidationError another) {
        return Objects.equals(this.itemId, another.itemId) && Objects.equals(this.message, another.message) && this.level.equals((Object)another.level) && Objects.equals((Object)this.type, (Object)another.type) && Objects.equals(this.expression, another.expression) && Objects.equals(this.startIndex, another.startIndex) && Objects.equals(this.endIndex, another.endIndex) && Objects.equals(this.index, another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.itemId);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + this.level.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Objects.hashCode(this.expression);
        h += (h << 5) + Objects.hashCode(this.startIndex);
        h += (h << 5) + Objects.hashCode(this.endIndex);
        h += (h << 5) + Objects.hashCode(this.index);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FormValidationError{");
        if (this.itemId != null) {
            builder.append("itemId=").append(this.itemId);
        }
        if (this.message != null) {
            if (builder.length() > 20) {
                builder.append(", ");
            }
            builder.append("message=").append(this.message);
        }
        if (builder.length() > 20) {
            builder.append(", ");
        }
        builder.append("level=").append((Object)this.level);
        if (this.type != null) {
            builder.append(", ");
            builder.append("type=").append((Object)this.type);
        }
        if (this.expression != null) {
            builder.append(", ");
            builder.append("expression=").append(this.expression);
        }
        if (this.startIndex != null) {
            builder.append(", ");
            builder.append("startIndex=").append(this.startIndex);
        }
        if (this.endIndex != null) {
            builder.append(", ");
            builder.append("endIndex=").append(this.endIndex);
        }
        if (this.index != null) {
            builder.append(", ");
            builder.append("index=").append(this.index);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormValidationError fromJson(Json json) {
        Builder builder = ImmutableFormValidationError.builder();
        if (json.itemId != null) {
            builder.itemId(json.itemId);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.level != null) {
            builder.level(json.level);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.expression != null) {
            builder.expression(json.expression);
        }
        if (json.startIndex != null) {
            builder.startIndex(json.startIndex);
        }
        if (json.endIndex != null) {
            builder.endIndex(json.endIndex);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableFormValidationError copyOf(FormValidationError instance) {
        if (instance instanceof ImmutableFormValidationError) {
            return (ImmutableFormValidationError)instance;
        }
        return ImmutableFormValidationError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FormValidationError", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String itemId;
        @Nullable
        private String message;
        @Nullable
        private FormValidationError.Level level;
        @Nullable
        private FormValidationError.Type type;
        @Nullable
        private String expression;
        @Nullable
        private Integer startIndex;
        @Nullable
        private Integer endIndex;
        @Nullable
        private Integer index;

        private Builder() {
        }

        public final Builder from(FormValidationError instance) {
            Optional<Integer> indexOptional;
            Optional<Integer> endIndexOptional;
            Optional<Integer> startIndexOptional;
            Optional<String> expressionOptional;
            String messageValue;
            Objects.requireNonNull(instance, "instance");
            String itemIdValue = instance.getItemId();
            if (itemIdValue != null) {
                this.itemId(itemIdValue);
            }
            if ((messageValue = instance.getMessage()) != null) {
                this.message(messageValue);
            }
            this.level(instance.getLevel());
            FormValidationError.Type typeValue = instance.getType();
            if (typeValue != null) {
                this.type(typeValue);
            }
            if ((expressionOptional = instance.getExpression()).isPresent()) {
                this.expression(expressionOptional);
            }
            if ((startIndexOptional = instance.getStartIndex()).isPresent()) {
                this.startIndex(startIndexOptional);
            }
            if ((endIndexOptional = instance.getEndIndex()).isPresent()) {
                this.endIndex(endIndexOptional);
            }
            if ((indexOptional = instance.getIndex()).isPresent()) {
                this.index(indexOptional);
            }
            return this;
        }

        @JsonProperty(value="itemId")
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        @JsonProperty(value="message")
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="level")
        public final Builder level(FormValidationError.Level level) {
            this.level = Objects.requireNonNull(level, "level");
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(FormValidationError.Type type) {
            this.type = type;
            return this;
        }

        public final Builder expression(String expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            return this;
        }

        @JsonProperty(value="expression")
        public final Builder expression(Optional<String> expression) {
            this.expression = expression.orElse(null);
            return this;
        }

        public final Builder startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        @JsonProperty(value="startIndex")
        public final Builder startIndex(Optional<Integer> startIndex) {
            this.startIndex = startIndex.orElse(null);
            return this;
        }

        public final Builder endIndex(int endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        @JsonProperty(value="endIndex")
        public final Builder endIndex(Optional<Integer> endIndex) {
            this.endIndex = endIndex.orElse(null);
            return this;
        }

        public final Builder index(int index) {
            this.index = index;
            return this;
        }

        @JsonProperty(value="index")
        public final Builder index(Optional<Integer> index) {
            this.index = index.orElse(null);
            return this;
        }

        public ImmutableFormValidationError build() {
            return new ImmutableFormValidationError(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FormValidationError", generator="Immutables")
    static final class Json
    implements FormValidationError {
        @Nullable
        String itemId;
        @Nullable
        String message;
        @Nullable
        FormValidationError.Level level;
        @Nullable
        FormValidationError.Type type;
        @Nullable
        Optional<String> expression = Optional.empty();
        @Nullable
        Optional<Integer> startIndex = Optional.empty();
        @Nullable
        Optional<Integer> endIndex = Optional.empty();
        @Nullable
        Optional<Integer> index = Optional.empty();

        Json() {
        }

        @JsonProperty(value="itemId")
        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="level")
        public void setLevel(FormValidationError.Level level) {
            this.level = level;
        }

        @JsonProperty(value="type")
        public void setType(FormValidationError.Type type) {
            this.type = type;
        }

        @JsonProperty(value="expression")
        public void setExpression(Optional<String> expression) {
            this.expression = expression;
        }

        @JsonProperty(value="startIndex")
        public void setStartIndex(Optional<Integer> startIndex) {
            this.startIndex = startIndex;
        }

        @JsonProperty(value="endIndex")
        public void setEndIndex(Optional<Integer> endIndex) {
            this.endIndex = endIndex;
        }

        @JsonProperty(value="index")
        public void setIndex(Optional<Integer> index) {
            this.index = index;
        }

        @Override
        public String getItemId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FormValidationError.Level getLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FormValidationError.Type getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getExpression() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getStartIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getEndIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

