package io.dialob.api.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IdAndRevision}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIdAndRevision.builder()}.
 */
@Generated(from = "IdAndRevision", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableIdAndRevision implements IdAndRevision {
  private final String id;
  private final String rev;

  private ImmutableIdAndRevision(String id, String rev) {
    this.id = id;
    this.rev = rev;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("_id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("_rev")
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IdAndRevision#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIdAndRevision withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableIdAndRevision(newValue, this.rev);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IdAndRevision#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIdAndRevision withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableIdAndRevision(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIdAndRevision} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIdAndRevision
        && equalTo((ImmutableIdAndRevision) another);
  }

  private boolean equalTo(ImmutableIdAndRevision another) {
    return id.equals(another.id)
        && rev.equals(another.rev);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IdAndRevision} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IdAndRevision{"
        + "id=" + id
        + ", rev=" + rev
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "IdAndRevision", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements IdAndRevision {
    @Nullable String id;
    @Nullable String rev;
    @JsonProperty("_id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("_rev")
    public void setRev(String rev) {
      this.rev = rev;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableIdAndRevision fromJson(Json json) {
    ImmutableIdAndRevision.Builder builder = ImmutableIdAndRevision.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link IdAndRevision} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IdAndRevision instance
   */
  public static ImmutableIdAndRevision copyOf(IdAndRevision instance) {
    if (instance instanceof ImmutableIdAndRevision) {
      return (ImmutableIdAndRevision) instance;
    }
    return ImmutableIdAndRevision.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIdAndRevision ImmutableIdAndRevision}.
   * <pre>
   * ImmutableIdAndRevision.builder()
   *    .id(String) // required {@link IdAndRevision#getId() id}
   *    .rev(String) // required {@link IdAndRevision#getRev() rev}
   *    .build();
   * </pre>
   * @return A new ImmutableIdAndRevision builder
   */
  public static ImmutableIdAndRevision.Builder builder() {
    return new ImmutableIdAndRevision.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIdAndRevision ImmutableIdAndRevision}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IdAndRevision", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String rev;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IdAndRevision} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdAndRevision instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      return this;
    }

    /**
     * Initializes the value for the {@link IdAndRevision#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("_id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link IdAndRevision#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("_rev")
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIdAndRevision ImmutableIdAndRevision}.
     * @return An immutable instance of IdAndRevision
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIdAndRevision build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIdAndRevision(id, rev);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      return "Cannot build IdAndRevision, some of required attributes are not set " + attributes;
    }
  }
}
