package io.dialob.api.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Errors}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableErrors.builder()}.
 */
@Generated(from = "Errors", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableErrors extends Errors {
  private final @Nullable Date timestamp;
  private final @Nullable Integer status;
  private final @Nullable String error;
  private final @Nullable String message;
  private final @Nullable String trace;
  private final @Nullable String path;
  private final @Nullable List<Errors.Error> errors;

  private ImmutableErrors(ImmutableErrors.Builder builder) {
    this.status = builder.status;
    this.error = builder.error;
    this.message = builder.message;
    this.trace = builder.trace;
    this.path = builder.path;
    this.errors = builder.errors == null ? null : createUnmodifiableList(true, builder.errors);
    this.timestamp = builder.timestampIsSet()
        ? builder.timestamp
        : super.getTimestamp();
  }

  private ImmutableErrors(
      @Nullable Date timestamp,
      @Nullable Integer status,
      @Nullable String error,
      @Nullable String message,
      @Nullable String trace,
      @Nullable String path,
      @Nullable List<Errors.Error> errors) {
    this.timestamp = timestamp;
    this.status = status;
    this.error = error;
    this.message = message;
    this.trace = trace;
    this.path = path;
    this.errors = errors;
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @JsonProperty("timestamp")
  @Override
  public @Nullable Date getTimestamp() {
    return timestamp;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public @Nullable Integer getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty("error")
  @Override
  public @Nullable String getError() {
    return error;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public @Nullable String getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code trace} attribute
   */
  @JsonProperty("trace")
  @Override
  public @Nullable String getTrace() {
    return trace;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @JsonProperty("path")
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty("errors")
  @Override
  public @Nullable List<Errors.Error> getErrors() {
    return errors;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Errors#getTimestamp() timestamp} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timestamp (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrors withTimestamp(@Nullable Date value) {
    if (this.timestamp == value) return this;
    return new ImmutableErrors(value, this.status, this.error, this.message, this.trace, this.path, this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Errors#getStatus() status} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrors withStatus(@Nullable Integer value) {
    if (Objects.equals(this.status, value)) return this;
    return new ImmutableErrors(this.timestamp, value, this.error, this.message, this.trace, this.path, this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Errors#getError() error} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for error (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrors withError(@Nullable String value) {
    if (Objects.equals(this.error, value)) return this;
    return new ImmutableErrors(this.timestamp, this.status, value, this.message, this.trace, this.path, this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Errors#getMessage() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrors withMessage(@Nullable String value) {
    if (Objects.equals(this.message, value)) return this;
    return new ImmutableErrors(this.timestamp, this.status, this.error, value, this.trace, this.path, this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Errors#getTrace() trace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for trace (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrors withTrace(@Nullable String value) {
    if (Objects.equals(this.trace, value)) return this;
    return new ImmutableErrors(this.timestamp, this.status, this.error, this.message, value, this.path, this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Errors#getPath() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrors withPath(@Nullable String value) {
    if (Objects.equals(this.path, value)) return this;
    return new ImmutableErrors(this.timestamp, this.status, this.error, this.message, this.trace, value, this.errors);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Errors#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableErrors withErrors(@Nullable Errors.Error... elements) {
    if (elements == null) {
      return new ImmutableErrors(this.timestamp, this.status, this.error, this.message, this.trace, this.path, null);
    }
    List<Errors.Error> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableErrors(this.timestamp, this.status, this.error, this.message, this.trace, this.path, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Errors#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableErrors withErrors(@Nullable Iterable<? extends Errors.Error> elements) {
    if (this.errors == elements) return this;
    List<Errors.Error> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableErrors(this.timestamp, this.status, this.error, this.message, this.trace, this.path, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableErrors} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableErrors
        && equalTo((ImmutableErrors) another);
  }

  private boolean equalTo(ImmutableErrors another) {
    return Objects.equals(timestamp, another.timestamp)
        && Objects.equals(status, another.status)
        && Objects.equals(error, another.error)
        && Objects.equals(message, another.message)
        && Objects.equals(trace, another.trace)
        && Objects.equals(path, another.path)
        && Objects.equals(errors, another.errors);
  }

  /**
   * Computes a hash code from attributes: {@code timestamp}, {@code status}, {@code error}, {@code message}, {@code trace}, {@code path}, {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(timestamp);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + Objects.hashCode(error);
    h += (h << 5) + Objects.hashCode(message);
    h += (h << 5) + Objects.hashCode(trace);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(errors);
    return h;
  }

  /**
   * Prints the immutable value {@code Errors} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Errors{"
        + "timestamp=" + timestamp
        + ", status=" + status
        + ", error=" + error
        + ", message=" + message
        + ", trace=" + trace
        + ", path=" + path
        + ", errors=" + errors
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Errors", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Errors {
    @javax.annotation.Nullable Date timestamp;
    boolean timestampIsSet;
    @javax.annotation.Nullable Integer status;
    @javax.annotation.Nullable String error;
    @javax.annotation.Nullable String message;
    @javax.annotation.Nullable String trace;
    @javax.annotation.Nullable String path;
    @javax.annotation.Nullable List<Errors.Error> errors = null;
    @JsonProperty("timestamp")
    public void setTimestamp(@Nullable Date timestamp) {
      this.timestamp = timestamp;
      this.timestampIsSet = true;
    }
    @JsonProperty("status")
    public void setStatus(@Nullable Integer status) {
      this.status = status;
    }
    @JsonProperty("error")
    public void setError(@Nullable String error) {
      this.error = error;
    }
    @JsonProperty("message")
    public void setMessage(@Nullable String message) {
      this.message = message;
    }
    @JsonProperty("trace")
    public void setTrace(@Nullable String trace) {
      this.trace = trace;
    }
    @JsonProperty("path")
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty("errors")
    public void setErrors(@Nullable List<Errors.Error> errors) {
      this.errors = errors;
    }
    @Override
    public Date getTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public String getTrace() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public List<Errors.Error> getErrors() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableErrors fromJson(Json json) {
    ImmutableErrors.Builder builder = ImmutableErrors.builder();
    if (json.timestampIsSet) {
      builder.timestamp(json.timestamp);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.trace != null) {
      builder.trace(json.trace);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.errors != null) {
      builder.addAllErrors(json.errors);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Errors} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Errors instance
   */
  public static ImmutableErrors copyOf(Errors instance) {
    if (instance instanceof ImmutableErrors) {
      return (ImmutableErrors) instance;
    }
    return ImmutableErrors.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableErrors ImmutableErrors}.
   * <pre>
   * ImmutableErrors.builder()
   *    .timestamp(Date | null) // nullable {@link Errors#getTimestamp() timestamp}
   *    .status(Integer | null) // nullable {@link Errors#getStatus() status}
   *    .error(String | null) // nullable {@link Errors#getError() error}
   *    .message(String | null) // nullable {@link Errors#getMessage() message}
   *    .trace(String | null) // nullable {@link Errors#getTrace() trace}
   *    .path(String | null) // nullable {@link Errors#getPath() path}
   *    .errors(List&amp;lt;io.dialob.api.rest.Errors.Error&amp;gt; | null) // nullable {@link Errors#getErrors() errors}
   *    .build();
   * </pre>
   * @return A new ImmutableErrors builder
   */
  public static ImmutableErrors.Builder builder() {
    return new ImmutableErrors.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableErrors ImmutableErrors}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Errors", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_TIMESTAMP = 0x1L;
    private long optBits;

    private @javax.annotation.Nullable Date timestamp;
    private @javax.annotation.Nullable Integer status;
    private @javax.annotation.Nullable String error;
    private @javax.annotation.Nullable String message;
    private @javax.annotation.Nullable String trace;
    private @javax.annotation.Nullable String path;
    private List<Errors.Error> errors = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Errors} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Errors instance) {
      Objects.requireNonNull(instance, "instance");
      Date timestampValue = instance.getTimestamp();
      if (timestampValue != null) {
        timestamp(timestampValue);
      }
      Integer statusValue = instance.getStatus();
      if (statusValue != null) {
        status(statusValue);
      }
      String errorValue = instance.getError();
      if (errorValue != null) {
        error(errorValue);
      }
      String messageValue = instance.getMessage();
      if (messageValue != null) {
        message(messageValue);
      }
      String traceValue = instance.getTrace();
      if (traceValue != null) {
        trace(traceValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      List<Errors.Error> errorsValue = instance.getErrors();
      if (errorsValue != null) {
        addAllErrors(errorsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Errors#getTimestamp() timestamp} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Errors#getTimestamp() timestamp}.</em>
     * @param timestamp The value for timestamp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("timestamp")
    public final Builder timestamp(@Nullable Date timestamp) {
      this.timestamp = timestamp;
      optBits |= OPT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link Errors#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(@Nullable Integer status) {
      this.status = status;
      return this;
    }

    /**
     * Initializes the value for the {@link Errors#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error")
    public final Builder error(@Nullable String error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link Errors#getMessage() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final Builder message(@Nullable String message) {
      this.message = message;
      return this;
    }

    /**
     * Initializes the value for the {@link Errors#getTrace() trace} attribute.
     * @param trace The value for trace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("trace")
    public final Builder trace(@Nullable String trace) {
      this.trace = trace;
      return this;
    }

    /**
     * Initializes the value for the {@link Errors#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("path")
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Adds one element to {@link Errors#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(Errors.Error element) {
      if (this.errors == null) {
        this.errors = new ArrayList<Errors.Error>();
      }
      this.errors.add(Objects.requireNonNull(element, "errors element"));
      return this;
    }

    /**
     * Adds elements to {@link Errors#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(Errors.Error... elements) {
      if (this.errors == null) {
        this.errors = new ArrayList<Errors.Error>();
      }
      for (Errors.Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Errors#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("errors")
    public final Builder errors(@Nullable Iterable<? extends Errors.Error> elements) {
      if (elements == null) {
        this.errors = null;
        return this;
      }
      this.errors = new ArrayList<Errors.Error>();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link Errors#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllErrors(Iterable<? extends Errors.Error> elements) {
      Objects.requireNonNull(elements, "errors element");
      if (this.errors == null) {
        this.errors = new ArrayList<Errors.Error>();
      }
      for (Errors.Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableErrors ImmutableErrors}.
     * @return An immutable instance of Errors
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableErrors build() {
      return new ImmutableErrors(this);
    }

    private boolean timestampIsSet() {
      return (optBits & OPT_BIT_TIMESTAMP) != 0;
    }
  }

  /**
   * Immutable implementation of {@link Errors.Error}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableErrors.Error.builder()}.
   */
  @Generated(from = "Errors.Error", generator = "Immutables")
  @Immutable
  public static final class Error implements Errors.Error {
    private final @Nullable String code;
    private final @Nullable String context;
    private final @Nullable Object rejectedValue;
    private final @Nullable String error;

    private Error(
        @Nullable String code,
        @Nullable String context,
        @Nullable Object rejectedValue,
        @Nullable String error) {
      this.code = code;
      this.context = context;
      this.rejectedValue = rejectedValue;
      this.error = error;
    }

    /**
     * @return The value of the {@code code} attribute
     */
    @JsonProperty("code")
    @Override
    public @Nullable String getCode() {
      return code;
    }

    /**
     * @return The value of the {@code context} attribute
     */
    @JsonProperty("context")
    @Override
    public @Nullable String getContext() {
      return context;
    }

    /**
     * @return The value of the {@code rejectedValue} attribute
     */
    @JsonProperty("rejectedValue")
    @Override
    public @Nullable Object getRejectedValue() {
      return rejectedValue;
    }

    /**
     * @return The value of the {@code error} attribute
     */
    @JsonProperty("error")
    @Override
    public @Nullable String getError() {
      return error;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Errors.Error#getCode() code} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for code (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableErrors.Error withCode(@Nullable String value) {
      if (Objects.equals(this.code, value)) return this;
      return new ImmutableErrors.Error(value, this.context, this.rejectedValue, this.error);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Errors.Error#getContext() context} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for context (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableErrors.Error withContext(@Nullable String value) {
      if (Objects.equals(this.context, value)) return this;
      return new ImmutableErrors.Error(this.code, value, this.rejectedValue, this.error);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Errors.Error#getRejectedValue() rejectedValue} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for rejectedValue (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableErrors.Error withRejectedValue(@Nullable Object value) {
      if (this.rejectedValue == value) return this;
      return new ImmutableErrors.Error(this.code, this.context, value, this.error);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Errors.Error#getError() error} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for error (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableErrors.Error withError(@Nullable String value) {
      if (Objects.equals(this.error, value)) return this;
      return new ImmutableErrors.Error(this.code, this.context, this.rejectedValue, value);
    }

    /**
     * This instance is equal to all instances of {@code Error} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@javax.annotation.Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableErrors.Error
          && equalTo((ImmutableErrors.Error) another);
    }

    private boolean equalTo(ImmutableErrors.Error another) {
      return Objects.equals(code, another.code)
          && Objects.equals(context, another.context)
          && Objects.equals(rejectedValue, another.rejectedValue)
          && Objects.equals(error, another.error);
    }

    /**
     * Computes a hash code from attributes: {@code code}, {@code context}, {@code rejectedValue}, {@code error}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Objects.hashCode(code);
      h += (h << 5) + Objects.hashCode(context);
      h += (h << 5) + Objects.hashCode(rejectedValue);
      h += (h << 5) + Objects.hashCode(error);
      return h;
    }

    /**
     * Prints the immutable value {@code Error} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Error{"
          + "code=" + code
          + ", context=" + context
          + ", rejectedValue=" + rejectedValue
          + ", error=" + error
          + "}";
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Generated(from = "Errors.Error", generator = "Immutables")
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json implements Errors.Error {
      @javax.annotation.Nullable String code;
      @javax.annotation.Nullable String context;
      @javax.annotation.Nullable Object rejectedValue;
      @javax.annotation.Nullable String error;
      @JsonProperty("code")
      public void setCode(@Nullable String code) {
        this.code = code;
      }
      @JsonProperty("context")
      public void setContext(@Nullable String context) {
        this.context = context;
      }
      @JsonProperty("rejectedValue")
      public void setRejectedValue(@Nullable Object rejectedValue) {
        this.rejectedValue = rejectedValue;
      }
      @JsonProperty("error")
      public void setError(@Nullable String error) {
        this.error = error;
      }
      @Override
      public String getCode() { throw new UnsupportedOperationException(); }
      @Override
      public String getContext() { throw new UnsupportedOperationException(); }
      @Override
      public Object getRejectedValue() { throw new UnsupportedOperationException(); }
      @Override
      public String getError() { throw new UnsupportedOperationException(); }
    }

    /**
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableErrors.Error fromJson(Json json) {
      ImmutableErrors.Error.Builder builder = ImmutableErrors.Error.builder();
      if (json.code != null) {
        builder.code(json.code);
      }
      if (json.context != null) {
        builder.context(json.context);
      }
      if (json.rejectedValue != null) {
        builder.rejectedValue(json.rejectedValue);
      }
      if (json.error != null) {
        builder.error(json.error);
      }
      return builder.build();
    }

    /**
     * Creates an immutable copy of a {@link Errors.Error} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Error instance
     */
    public static ImmutableErrors.Error copyOf(Errors.Error instance) {
      if (instance instanceof ImmutableErrors.Error) {
        return (ImmutableErrors.Error) instance;
      }
      return ImmutableErrors.Error.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableErrors.Error Error}.
     * <pre>
     * ImmutableErrors.Error.builder()
     *    .code(String | null) // nullable {@link Errors.Error#getCode() code}
     *    .context(String | null) // nullable {@link Errors.Error#getContext() context}
     *    .rejectedValue(Object | null) // nullable {@link Errors.Error#getRejectedValue() rejectedValue}
     *    .error(String | null) // nullable {@link Errors.Error#getError() error}
     *    .build();
     * </pre>
     * @return A new Error builder
     */
    public static ImmutableErrors.Error.Builder builder() {
      return new ImmutableErrors.Error.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableErrors.Error Error}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Errors.Error", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private @javax.annotation.Nullable String code;
      private @javax.annotation.Nullable String context;
      private @javax.annotation.Nullable Object rejectedValue;
      private @javax.annotation.Nullable String error;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Error} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Errors.Error instance) {
        Objects.requireNonNull(instance, "instance");
        String codeValue = instance.getCode();
        if (codeValue != null) {
          code(codeValue);
        }
        String contextValue = instance.getContext();
        if (contextValue != null) {
          context(contextValue);
        }
        Object rejectedValueValue = instance.getRejectedValue();
        if (rejectedValueValue != null) {
          rejectedValue(rejectedValueValue);
        }
        String errorValue = instance.getError();
        if (errorValue != null) {
          error(errorValue);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link Errors.Error#getCode() code} attribute.
       * @param code The value for code (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("code")
      public final Builder code(@Nullable String code) {
        this.code = code;
        return this;
      }

      /**
       * Initializes the value for the {@link Errors.Error#getContext() context} attribute.
       * @param context The value for context (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("context")
      public final Builder context(@Nullable String context) {
        this.context = context;
        return this;
      }

      /**
       * Initializes the value for the {@link Errors.Error#getRejectedValue() rejectedValue} attribute.
       * @param rejectedValue The value for rejectedValue (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("rejectedValue")
      public final Builder rejectedValue(@Nullable Object rejectedValue) {
        this.rejectedValue = rejectedValue;
        return this;
      }

      /**
       * Initializes the value for the {@link Errors.Error#getError() error} attribute.
       * @param error The value for error (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("error")
      public final Builder error(@Nullable String error) {
        this.error = error;
        return this;
      }

      /**
       * Builds a new {@link ImmutableErrors.Error Error}.
       * @return An immutable instance of Error
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableErrors.Error build() {
        return new ImmutableErrors.Error(code, context, rejectedValue, error);
      }
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
