package io.dialob.api.rest;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Response}.
 * @see ImmutableResponse
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.rest", generator = "Gsons")
public final class GsonAdaptersResponse implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ResponseTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ResponseTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersResponse(Response)";
  }

  @org.immutables.value.Generated(from = "Response", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class ResponseTypeAdapter extends TypeAdapter<Response> {
    public final Boolean okTypeSample = null;
    private final TypeAdapter<Boolean> okTypeAdapter;

    ResponseTypeAdapter(Gson gson) {
      this.okTypeAdapter = gson.getAdapter( Boolean.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return Response.class == type.getRawType()
          || ImmutableResponse.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Response value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeResponse(out, value);
      }
    }

    @Override
    public Response read(JsonReader in) throws IOException {
      return readResponse(in);
    }

    private void writeResponse(JsonWriter out, Response instance)
        throws IOException {
      out.beginObject();
      Boolean okValue = instance.getOk();
      if (okValue != null) {
        out.name("ok");
        okTypeAdapter.write(out, okValue);
      } else if (out.getSerializeNulls()) {
        out.name("ok");
        out.nullValue();
      }
      String errorValue = instance.getError();
      if (errorValue != null) {
        out.name("error");
        out.value(errorValue);
      } else if (out.getSerializeNulls()) {
        out.name("error");
        out.nullValue();
      }
      String reasonValue = instance.getReason();
      if (reasonValue != null) {
        out.name("reason");
        out.value(reasonValue);
      } else if (out.getSerializeNulls()) {
        out.name("reason");
        out.nullValue();
      }
      out.endObject();
    }

    private  Response readResponse(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableResponse.Builder builder = ImmutableResponse.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableResponse.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'o':
        if ("ok".equals(attributeName)) {
          readInOk(in, builder);
          return;
        }
        break;
      case 'e':
        if ("error".equals(attributeName)) {
          readInError(in, builder);
          return;
        }
        break;
      case 'r':
        if ("reason".equals(attributeName)) {
          readInReason(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInOk(JsonReader in, ImmutableResponse.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = okTypeAdapter.read(in);
        builder.ok(value);
      }
    }

    private void readInError(JsonReader in, ImmutableResponse.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.error(in.nextString());
      }
    }

    private void readInReason(JsonReader in, ImmutableResponse.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.reason(in.nextString());
      }
    }
  }
}
