package io.dialob.api.rest;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Metadata}.
 * @see ImmutableMetadata
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.rest", generator = "Gsons")
public final class GsonAdaptersMetadata implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (MetadataTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new MetadataTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersMetadata(Metadata)";
  }

  @org.immutables.value.Generated(from = "Metadata", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class MetadataTypeAdapter extends TypeAdapter<Metadata> {
    public final Date createdTypeSample = null;
    public final Date lastSavedTypeSample = null;
    public final Boolean validTypeSample = null;
    private final TypeAdapter<Date> createdTypeAdapter;
    private final TypeAdapter<Date> lastSavedTypeAdapter;
    private final TypeAdapter<Boolean> validTypeAdapter;

    MetadataTypeAdapter(Gson gson) {
      this.createdTypeAdapter = gson.getAdapter( Date.class);
      this.lastSavedTypeAdapter = gson.getAdapter( Date.class);
      this.validTypeAdapter = gson.getAdapter( Boolean.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return Metadata.class == type.getRawType()
          || ImmutableMetadata.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Metadata value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeMetadata(out, value);
      }
    }

    @Override
    public Metadata read(JsonReader in) throws IOException {
      return readMetadata(in);
    }

    private void writeMetadata(JsonWriter out, Metadata instance)
        throws IOException {
      out.beginObject();
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        out.name("description");
        out.value(descriptionValue);
      } else if (out.getSerializeNulls()) {
        out.name("description");
        out.nullValue();
      }
      out.name("label");
      out.value(instance.getLabel());
      Date createdValue = instance.getCreated();
      if (createdValue != null) {
        out.name("created");
        createdTypeAdapter.write(out, createdValue);
      } else if (out.getSerializeNulls()) {
        out.name("created");
        out.nullValue();
      }
      Date lastSavedValue = instance.getLastSaved();
      if (lastSavedValue != null) {
        out.name("lastSaved");
        lastSavedTypeAdapter.write(out, lastSavedValue);
      } else if (out.getSerializeNulls()) {
        out.name("lastSaved");
        out.nullValue();
      }
      Boolean validValue = instance.getValid();
      if (validValue != null) {
        out.name("valid");
        validTypeAdapter.write(out, validValue);
      } else if (out.getSerializeNulls()) {
        out.name("valid");
        out.nullValue();
      }
      out.endObject();
    }

    private  Metadata readMetadata(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableMetadata.Builder builder = ImmutableMetadata.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableMetadata.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'd':
        if ("description".equals(attributeName)) {
          readInDescription(in, builder);
          return;
        }
        break;
      case 'l':
        if ("label".equals(attributeName)) {
          readInLabel(in, builder);
          return;
        }
        if ("lastSaved".equals(attributeName)) {
          readInLastSaved(in, builder);
          return;
        }
        break;
      case 'c':
        if ("created".equals(attributeName)) {
          readInCreated(in, builder);
          return;
        }
        break;
      case 'v':
        if ("valid".equals(attributeName)) {
          readInValid(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInDescription(JsonReader in, ImmutableMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.description(in.nextString());
      }
    }

    private void readInLabel(JsonReader in, ImmutableMetadata.Builder builder)
        throws IOException {
      builder.label(in.nextString());
    }

    private void readInCreated(JsonReader in, ImmutableMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Date value = createdTypeAdapter.read(in);
        builder.created(value);
      }
    }

    private void readInLastSaved(JsonReader in, ImmutableMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Date value = lastSavedTypeAdapter.read(in);
        builder.lastSaved(value);
      }
    }

    private void readInValid(JsonReader in, ImmutableMetadata.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = validTypeAdapter.read(in);
        builder.valid(value);
      }
    }
  }
}
