package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link VariableValue VariableValue} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableVariableValue is not thread-safe</em>
 * @see ImmutableVariableValue
 */
@Generated(from = "VariableValue", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "VariableValue"})
@NotThreadSafe
public final class ModifiableVariableValue implements VariableValue {

  private static final long INIT_BIT_ID = 0x1L;
  private long initBits = 0x1L;

  private String id;
  private @Nullable java.lang.Object value;

  private ModifiableVariableValue() {}

  /**
   * Construct a modifiable instance of {@code VariableValue}.
   * @param id The value for the {@link VariableValue#getId() id} attribute 
   * @param value The value for the {@link VariableValue#getValue() value} attribute (can be {@code null})
   * @return A new modifiable instance
   */
  public static ModifiableVariableValue create(String id, @Nullable java.lang.Object value) {
    return new ModifiableVariableValue()
        .setId(id)
        .setValue(value);
  }

  /**
   * Construct a modifiable instance of {@code VariableValue}.
   * @return A new modifiable instance
   */
  public static ModifiableVariableValue create() {
    return new ModifiableVariableValue();
  }

  /**
   * @return value of {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public final String getId() {
    if (!idIsSet()) {
      checkRequiredAttributes();
    }
    return id;
  }

  /**
   * @return value of {@code value} attribute, may be {@code null}
   */
  @JsonProperty("value")
  @JsonInclude(JsonInclude.Include.ALWAYS)
  @Override
  public final @Nullable java.lang.Object getValue() {
    return value;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariableValue clear() {
    initBits = 0x1L;
    id = null;
    value = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link VariableValue} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariableValue from(VariableValue instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableVariableValue) {
      from((ModifiableVariableValue) instance);
      return this;
    }
    setId(instance.getId());
    java.lang.Object valueValue = instance.getValue();
    if (valueValue != null) {
      setValue(valueValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link VariableValue} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariableValue from(ModifiableVariableValue instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.idIsSet()) {
      setId(instance.getId());
    }
    java.lang.Object valueValue = instance.getValue();
    if (valueValue != null) {
      setValue(valueValue);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link VariableValue#getId() id} attribute.
   * @param id The value for id
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariableValue setId(String id) {
    this.id = Objects.requireNonNull(id, "id");
    initBits &= ~INIT_BIT_ID;
    return this;
  }

  /**
   * Assigns a value to the {@link VariableValue#getValue() value} attribute.
   * @param value The value for value, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVariableValue setValue(@Nullable java.lang.Object value) {
    this.value = value;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link VariableValue#getId() id} is set.
   * @return {@code true} if set
   */
  public final boolean idIsSet() {
    return (initBits & INIT_BIT_ID) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableVariableValue unsetId() {
    initBits |= INIT_BIT_ID;
    id = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!idIsSet()) attributes.add("id");
    return "VariableValue is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableVariableValue ImmutableVariableValue}.
   * @return An immutable instance of VariableValue
   */
  public final ImmutableVariableValue toImmutable() {
    checkRequiredAttributes();
    return ImmutableVariableValue.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableVariableValue} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableVariableValue)) return false;
    ModifiableVariableValue other = (ModifiableVariableValue) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableVariableValue another) {
    return id.equals(another.id)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Generates a string representation of this {@code VariableValue}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableVariableValue{"
        + "id="  + (idIsSet() ? getId() : "?")
        + ", value=" + getValue()
        + "}";
  }
}
