package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import io.dialob.api.proto.ValueSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Questionnaire Questionnaire} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableQuestionnaire is not thread-safe</em>
 * @see ImmutableQuestionnaire
 */
@Generated(from = "Questionnaire", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "Questionnaire"})
@NotThreadSafe
public final class ModifiableQuestionnaire implements Questionnaire {

  private @Nullable String id;
  private @Nullable String rev;
  private final ArrayList<Answer> answers = new ArrayList<Answer>();
  private final ArrayList<ContextValue> context = new ArrayList<ContextValue>();
  private @Nullable String activeItem;
  private final ArrayList<Error> errors = new ArrayList<Error>();
  private final ArrayList<VariableValue> variableValues = new ArrayList<VariableValue>();
  private final ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
  private ModifiableQuestionnaireMetadata metadata;

  private ModifiableQuestionnaire() {}

  /**
   * Construct a modifiable instance of {@code Questionnaire}.
   * @return A new modifiable instance
   */
  public static ModifiableQuestionnaire create() {
    return new ModifiableQuestionnaire();
  }

  /**
   * @return value of {@code id} attribute, may be {@code null}
   */
  @JsonProperty("_id")
  @Override
  public final @Nullable String getId() {
    return id;
  }

  /**
   * @return value of {@code rev} attribute, may be {@code null}
   */
  @JsonProperty("_rev")
  @Override
  public final @Nullable String getRev() {
    return rev;
  }

  /**
   * @return modifiable list {@code answers}
   */
  @JsonProperty("answers")
  @Override
  public final List<Answer> getAnswers() {
    return answers;
  }

  /**
   * @return modifiable list {@code context}
   */
  @JsonProperty("context")
  @Override
  public final List<ContextValue> getContext() {
    return context;
  }

  /**
   * @return value of {@code activeItem} attribute, may be {@code null}
   */
  @JsonProperty("activeItem")
  @Override
  public final @Nullable String getActiveItem() {
    return activeItem;
  }

  /**
   * @return modifiable list {@code errors}
   */
  @JsonProperty("errors")
  @Override
  public final List<Error> getErrors() {
    return errors;
  }

  /**
   * @return modifiable list {@code variableValues}
   */
  @JsonProperty("variableValues")
  @Override
  public final List<VariableValue> getVariableValues() {
    return variableValues;
  }

  /**
   * @return modifiable list {@code valueSets}
   */
  @JsonProperty("valueSets")
  @Override
  public final List<ValueSet> getValueSets() {
    return valueSets;
  }

  /**
   * @return value of {@code metadata} attribute, may be {@code null}
   */
  @JsonProperty("metadata")
  @Override
  public final ModifiableQuestionnaireMetadata getMetadata() {
    return metadata;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire clear() {
    id = null;
    rev = null;
    answers.clear();
    context.clear();
    activeItem = null;
    errors.clear();
    variableValues.clear();
    valueSets.clear();
    metadata = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Questionnaire} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire from(Questionnaire instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableQuestionnaire) {
      from((ModifiableQuestionnaire) instance);
      return this;
    }
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    String revValue = instance.getRev();
    if (revValue != null) {
      setRev(revValue);
    }
    addAllAnswers(instance.getAnswers());
    addAllContext(instance.getContext());
    String activeItemValue = instance.getActiveItem();
    if (activeItemValue != null) {
      setActiveItem(activeItemValue);
    }
    addAllErrors(instance.getErrors());
    addAllVariableValues(instance.getVariableValues());
    addAllValueSets(instance.getValueSets());
    Questionnaire.Metadata metadataValue = instance.getMetadata();
    if (metadataValue != null) {
      setMetadata(metadataValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Questionnaire} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire from(ModifiableQuestionnaire instance) {
    Objects.requireNonNull(instance, "instance");
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    String revValue = instance.getRev();
    if (revValue != null) {
      setRev(revValue);
    }
    addAllAnswers(instance.getAnswers());
    addAllContext(instance.getContext());
    String activeItemValue = instance.getActiveItem();
    if (activeItemValue != null) {
      setActiveItem(activeItemValue);
    }
    addAllErrors(instance.getErrors());
    addAllVariableValues(instance.getVariableValues());
    addAllValueSets(instance.getValueSets());
    Questionnaire.Metadata metadataValue = instance.getMetadata();
    if (metadataValue != null) {
      setMetadata(metadataValue);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire#getId() id} attribute.
   * @param id The value for id, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire setId(@Nullable String id) {
    this.id = id;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire#getRev() rev} attribute.
   * @param rev The value for rev, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire setRev(@Nullable String rev) {
    this.rev = rev;
    return this;
  }

  /**
   * Adds one element to {@link Questionnaire#getAnswers() answers} list.
   * @param element The answers element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire addAnswers(Answer element) {
    this.answers.add(element instanceof ModifiableAnswer ? element : ModifiableAnswer.create().from(element));
    return this;
  }

  /**
   * Adds elements to {@link Questionnaire#getAnswers() answers} list.
   * @param elements An array of answers elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableQuestionnaire addAnswers(Answer... elements) {
    for (Answer e : elements) {
      addAnswers(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Questionnaire#getAnswers() answers} list.
   * @param elements An iterable of answers elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire setAnswers(Iterable<? extends Answer> elements) {
    this.answers.clear();
    addAllAnswers(elements);
    return this;
  }

  /**
   * Adds elements to {@link Questionnaire#getAnswers() answers} list.
   * @param elements An iterable of answers elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire addAllAnswers(Iterable<? extends Answer> elements) {
    for (Answer e : elements) {
      addAnswers(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Questionnaire#getContext() context} list.
   * @param element The context element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire addContext(ContextValue element) {
    this.context.add(element instanceof ModifiableContextValue ? element : ModifiableContextValue.create().from(element));
    return this;
  }

  /**
   * Adds elements to {@link Questionnaire#getContext() context} list.
   * @param elements An array of context elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableQuestionnaire addContext(ContextValue... elements) {
    for (ContextValue e : elements) {
      addContext(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Questionnaire#getContext() context} list.
   * @param elements An iterable of context elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire setContext(Iterable<? extends ContextValue> elements) {
    this.context.clear();
    addAllContext(elements);
    return this;
  }

  /**
   * Adds elements to {@link Questionnaire#getContext() context} list.
   * @param elements An iterable of context elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire addAllContext(Iterable<? extends ContextValue> elements) {
    for (ContextValue e : elements) {
      addContext(e);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire#getActiveItem() activeItem} attribute.
   * @param activeItem The value for activeItem, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire setActiveItem(@Nullable String activeItem) {
    this.activeItem = activeItem;
    return this;
  }

  /**
   * Adds one element to {@link Questionnaire#getErrors() errors} list.
   * @param element The errors element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire addErrors(Error element) {
    this.errors.add(element instanceof ModifiableError ? element : ModifiableError.create().from(element));
    return this;
  }

  /**
   * Adds elements to {@link Questionnaire#getErrors() errors} list.
   * @param elements An array of errors elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableQuestionnaire addErrors(Error... elements) {
    for (Error e : elements) {
      addErrors(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Questionnaire#getErrors() errors} list.
   * @param elements An iterable of errors elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire setErrors(Iterable<? extends Error> elements) {
    this.errors.clear();
    addAllErrors(elements);
    return this;
  }

  /**
   * Adds elements to {@link Questionnaire#getErrors() errors} list.
   * @param elements An iterable of errors elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire addAllErrors(Iterable<? extends Error> elements) {
    for (Error e : elements) {
      addErrors(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Questionnaire#getVariableValues() variableValues} list.
   * @param element The variableValues element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire addVariableValues(VariableValue element) {
    this.variableValues.add(element instanceof ModifiableVariableValue ? element : ModifiableVariableValue.create().from(element));
    return this;
  }

  /**
   * Adds elements to {@link Questionnaire#getVariableValues() variableValues} list.
   * @param elements An array of variableValues elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableQuestionnaire addVariableValues(VariableValue... elements) {
    for (VariableValue e : elements) {
      addVariableValues(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Questionnaire#getVariableValues() variableValues} list.
   * @param elements An iterable of variableValues elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire setVariableValues(Iterable<? extends VariableValue> elements) {
    this.variableValues.clear();
    addAllVariableValues(elements);
    return this;
  }

  /**
   * Adds elements to {@link Questionnaire#getVariableValues() variableValues} list.
   * @param elements An iterable of variableValues elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire addAllVariableValues(Iterable<? extends VariableValue> elements) {
    for (VariableValue e : elements) {
      addVariableValues(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Questionnaire#getValueSets() valueSets} list.
   * @param element The valueSets element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire addValueSets(ValueSet element) {
    this.valueSets.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Questionnaire#getValueSets() valueSets} list.
   * @param elements An array of valueSets elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableQuestionnaire addValueSets(ValueSet... elements) {
    for (ValueSet e : elements) {
      addValueSets(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Questionnaire#getValueSets() valueSets} list.
   * @param elements An iterable of valueSets elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire setValueSets(Iterable<? extends ValueSet> elements) {
    this.valueSets.clear();
    addAllValueSets(elements);
    return this;
  }

  /**
   * Adds elements to {@link Questionnaire#getValueSets() valueSets} list.
   * @param elements An iterable of valueSets elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire addAllValueSets(Iterable<? extends ValueSet> elements) {
    for (ValueSet e : elements) {
      addValueSets(e);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire#getMetadata() metadata} attribute.
   * @param metadata The value for metadata, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaire setMetadata(Questionnaire.Metadata metadata) {
    this.metadata = metadata == null ? null : (metadata instanceof ModifiableQuestionnaireMetadata ? (ModifiableQuestionnaireMetadata) metadata : ModifiableQuestionnaireMetadata.create().from(metadata));
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableQuestionnaire ImmutableQuestionnaire}.
   * @return An immutable instance of Questionnaire
   */
  public final ImmutableQuestionnaire toImmutable() {
    return ImmutableQuestionnaire.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableQuestionnaire} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableQuestionnaire)) return false;
    ModifiableQuestionnaire other = (ModifiableQuestionnaire) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableQuestionnaire another) {
    return Objects.equals(id, another.id)
        && Objects.equals(rev, another.rev)
        && answers.equals(another.answers)
        && context.equals(another.context)
        && Objects.equals(activeItem, another.activeItem)
        && errors.equals(another.errors)
        && variableValues.equals(another.variableValues)
        && valueSets.equals(another.valueSets)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code answers}, {@code context}, {@code activeItem}, {@code errors}, {@code variableValues}, {@code valueSets}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(rev);
    h += (h << 5) + answers.hashCode();
    h += (h << 5) + context.hashCode();
    h += (h << 5) + Objects.hashCode(activeItem);
    h += (h << 5) + errors.hashCode();
    h += (h << 5) + variableValues.hashCode();
    h += (h << 5) + valueSets.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Generates a string representation of this {@code Questionnaire}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableQuestionnaire{"
        + "id=" + getId()
        + ", rev=" + getRev()
        + ", answers=" + getAnswers()
        + ", context=" + getContext()
        + ", activeItem=" + getActiveItem()
        + ", errors=" + getErrors()
        + ", variableValues=" + getVariableValues()
        + ", valueSets=" + getValueSets()
        + ", metadata=" + getMetadata()
        + "}";
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
