package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link ContextValue ContextValue} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableContextValue is not thread-safe</em>
 * @see ImmutableContextValue
 */
@Generated(from = "ContextValue", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "ContextValue"})
@NotThreadSafe
public final class ModifiableContextValue implements ContextValue {

  private String id;
  private @Nullable java.lang.Object value;

  private ModifiableContextValue() {}

  /**
   * Construct a modifiable instance of {@code ContextValue}.
   * @param id The value for the {@link ContextValue#getId() id} attribute (can be {@code null})
   * @param value The value for the {@link ContextValue#getValue() value} attribute (can be {@code null})
   * @return A new modifiable instance
   */
  public static ModifiableContextValue create(String id, @Nullable java.lang.Object value) {
    return new ModifiableContextValue()
        .setId(id)
        .setValue(value);
  }

  /**
   * Construct a modifiable instance of {@code ContextValue}.
   * @return A new modifiable instance
   */
  public static ModifiableContextValue create() {
    return new ModifiableContextValue();
  }

  /**
   * @return value of {@code id} attribute, may be {@code null}
   */
  @JsonProperty("id")
  @Override
  public final String getId() {
    return id;
  }

  /**
   * @return value of {@code value} attribute, may be {@code null}
   */
  @JsonProperty("value")
  @JsonInclude(JsonInclude.Include.ALWAYS)
  @Override
  public final @Nullable java.lang.Object getValue() {
    return value;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableContextValue clear() {
    id = null;
    value = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ContextValue} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableContextValue from(ContextValue instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableContextValue) {
      from((ModifiableContextValue) instance);
      return this;
    }
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    java.lang.Object valueValue = instance.getValue();
    if (valueValue != null) {
      setValue(valueValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ContextValue} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableContextValue from(ModifiableContextValue instance) {
    Objects.requireNonNull(instance, "instance");
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    java.lang.Object valueValue = instance.getValue();
    if (valueValue != null) {
      setValue(valueValue);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link ContextValue#getId() id} attribute.
   * @param id The value for id, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableContextValue setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Assigns a value to the {@link ContextValue#getValue() value} attribute.
   * @param value The value for value, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableContextValue setValue(@Nullable java.lang.Object value) {
    this.value = value;
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableContextValue ImmutableContextValue}.
   * @return An immutable instance of ContextValue
   */
  public final ImmutableContextValue toImmutable() {
    return ImmutableContextValue.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableContextValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableContextValue)) return false;
    ModifiableContextValue other = (ModifiableContextValue) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableContextValue another) {
    return Objects.equals(id, another.id)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Generates a string representation of this {@code ContextValue}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableContextValue{"
        + "id=" + getId()
        + ", value=" + getValue()
        + "}";
  }
}
