package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Answer Answer} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableAnswer is not thread-safe</em>
 * @see ImmutableAnswer
 */
@Generated(from = "Answer", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "Answer"})
@NotThreadSafe
public final class ModifiableAnswer implements Answer {

  private String id;
  private @Nullable java.lang.Object value;
  private @Nullable String type;
  private @Nullable java.lang.Object acceptedValue;
  private @Nullable Date updated;
  private @Nullable String userId;

  private ModifiableAnswer() {}

  /**
   * Construct a modifiable instance of {@code Answer}.
   * @param id The value for the {@link Answer#getId() id} attribute (can be {@code null})
   * @param value The value for the {@link Answer#getValue() value} attribute (can be {@code null})
   * @return A new modifiable instance
   */
  public static ModifiableAnswer create(String id, @Nullable java.lang.Object value) {
    return new ModifiableAnswer()
        .setId(id)
        .setValue(value);
  }

  /**
   * Construct a modifiable instance of {@code Answer}.
   * @return A new modifiable instance
   */
  public static ModifiableAnswer create() {
    return new ModifiableAnswer();
  }

  /**
   * @return value of {@code id} attribute, may be {@code null}
   */
  @JsonProperty("id")
  @Override
  public final String getId() {
    return id;
  }

  /**
   * Text and number field answers stored in orignal format
   * @return user's answer in original format
   */
  @JsonProperty("value")
  @JsonInclude(JsonInclude.Include.ALWAYS)
  @Override
  public final @Nullable java.lang.Object getValue() {
    return value;
  }

  /**
   * @return value of {@code type} attribute, may be {@code null}
   */
  @JsonProperty("type")
  @Override
  public final @Nullable String getType() {
    return type;
  }

  /**
   * @return value of {@code acceptedValue} attribute, may be {@code null}
   */
  @JsonProperty("acceptedValue")
  @Override
  public final @Nullable java.lang.Object getAcceptedValue() {
    return acceptedValue;
  }

  /**
   * @return value of {@code updated} attribute, may be {@code null}
   */
  @JsonProperty("updated")
  @Override
  public final @Nullable Date getUpdated() {
    return updated;
  }

  /**
   * @return value of {@code userId} attribute, may be {@code null}
   */
  @JsonProperty("userId")
  @Override
  public final @Nullable String getUserId() {
    return userId;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAnswer clear() {
    id = null;
    value = null;
    type = null;
    acceptedValue = null;
    updated = null;
    userId = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Answer} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAnswer from(Answer instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableAnswer) {
      from((ModifiableAnswer) instance);
      return this;
    }
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    java.lang.Object valueValue = instance.getValue();
    if (valueValue != null) {
      setValue(valueValue);
    }
    String typeValue = instance.getType();
    if (typeValue != null) {
      setType(typeValue);
    }
    java.lang.Object acceptedValueValue = instance.getAcceptedValue();
    if (acceptedValueValue != null) {
      setAcceptedValue(acceptedValueValue);
    }
    Date updatedValue = instance.getUpdated();
    if (updatedValue != null) {
      setUpdated(updatedValue);
    }
    String userIdValue = instance.getUserId();
    if (userIdValue != null) {
      setUserId(userIdValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Answer} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAnswer from(ModifiableAnswer instance) {
    Objects.requireNonNull(instance, "instance");
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    java.lang.Object valueValue = instance.getValue();
    if (valueValue != null) {
      setValue(valueValue);
    }
    String typeValue = instance.getType();
    if (typeValue != null) {
      setType(typeValue);
    }
    java.lang.Object acceptedValueValue = instance.getAcceptedValue();
    if (acceptedValueValue != null) {
      setAcceptedValue(acceptedValueValue);
    }
    Date updatedValue = instance.getUpdated();
    if (updatedValue != null) {
      setUpdated(updatedValue);
    }
    String userIdValue = instance.getUserId();
    if (userIdValue != null) {
      setUserId(userIdValue);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Answer#getId() id} attribute.
   * @param id The value for id, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAnswer setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Assigns a value to the {@link Answer#getValue() value} attribute.
   * @param value The value for value, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAnswer setValue(@Nullable java.lang.Object value) {
    this.value = value;
    return this;
  }

  /**
   * Assigns a value to the {@link Answer#getType() type} attribute.
   * @param type The value for type, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAnswer setType(@Nullable String type) {
    this.type = type;
    return this;
  }

  /**
   * Assigns a value to the {@link Answer#getAcceptedValue() acceptedValue} attribute.
   * @param acceptedValue The value for acceptedValue, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAnswer setAcceptedValue(@Nullable java.lang.Object acceptedValue) {
    this.acceptedValue = acceptedValue;
    return this;
  }

  /**
   * Assigns a value to the {@link Answer#getUpdated() updated} attribute.
   * @param updated The value for updated, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAnswer setUpdated(@Nullable Date updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Assigns a value to the {@link Answer#getUserId() userId} attribute.
   * @param userId The value for userId, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAnswer setUserId(@Nullable String userId) {
    this.userId = userId;
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableAnswer ImmutableAnswer}.
   * @return An immutable instance of Answer
   */
  public final ImmutableAnswer toImmutable() {
    return ImmutableAnswer.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableAnswer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableAnswer)) return false;
    ModifiableAnswer other = (ModifiableAnswer) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableAnswer another) {
    return Objects.equals(id, another.id)
        && Objects.equals(value, another.value)
        && Objects.equals(type, another.type)
        && Objects.equals(acceptedValue, another.acceptedValue)
        && Objects.equals(updated, another.updated)
        && Objects.equals(userId, another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}, {@code type}, {@code acceptedValue}, {@code updated}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(acceptedValue);
    h += (h << 5) + Objects.hashCode(updated);
    h += (h << 5) + Objects.hashCode(userId);
    return h;
  }

  /**
   * Generates a string representation of this {@code Answer}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableAnswer{"
        + "id=" + getId()
        + ", value=" + getValue()
        + ", type=" + getType()
        + ", acceptedValue=" + getAcceptedValue()
        + ", updated=" + getUpdated()
        + ", userId=" + getUserId()
        + "}";
  }
}
