package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuestionnaireListItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaireListItem.builder()}.
 */
@Generated(from = "QuestionnaireListItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQuestionnaireListItem implements QuestionnaireListItem {
  private final String id;
  private final Questionnaire.Metadata metadata;

  private ImmutableQuestionnaireListItem(String id, Questionnaire.Metadata metadata) {
    this.id = id;
    this.metadata = metadata;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty("metadata")
  @Override
  public Questionnaire.Metadata getMetadata() {
    return metadata;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireListItem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireListItem withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableQuestionnaireListItem(newValue, this.metadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireListItem#getMetadata() metadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadata
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireListItem withMetadata(Questionnaire.Metadata value) {
    if (this.metadata == value) return this;
    Questionnaire.Metadata newValue = Objects.requireNonNull(value, "metadata");
    return new ImmutableQuestionnaireListItem(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaireListItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaireListItem
        && equalTo((ImmutableQuestionnaireListItem) another);
  }

  private boolean equalTo(ImmutableQuestionnaireListItem another) {
    return id.equals(another.id)
        && metadata.equals(another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + metadata.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QuestionnaireListItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QuestionnaireListItem")
        .omitNullValues()
        .add("id", id)
        .add("metadata", metadata)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "QuestionnaireListItem", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements QuestionnaireListItem {
    @Nullable String id;
    @Nullable Questionnaire.Metadata metadata;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("metadata")
    public void setMetadata(Questionnaire.Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Questionnaire.Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableQuestionnaireListItem fromJson(Json json) {
    ImmutableQuestionnaireListItem.Builder builder = ImmutableQuestionnaireListItem.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link QuestionnaireListItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuestionnaireListItem instance
   */
  public static ImmutableQuestionnaireListItem copyOf(QuestionnaireListItem instance) {
    if (instance instanceof ImmutableQuestionnaireListItem) {
      return (ImmutableQuestionnaireListItem) instance;
    }
    return ImmutableQuestionnaireListItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaireListItem ImmutableQuestionnaireListItem}.
   * <pre>
   * ImmutableQuestionnaireListItem.builder()
   *    .id(String) // required {@link QuestionnaireListItem#getId() id}
   *    .metadata(io.dialob.api.questionnaire.Questionnaire.Metadata) // required {@link QuestionnaireListItem#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaireListItem builder
   */
  public static ImmutableQuestionnaireListItem.Builder builder() {
    return new ImmutableQuestionnaireListItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaireListItem ImmutableQuestionnaireListItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuestionnaireListItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_METADATA = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable Questionnaire.Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code QuestionnaireListItem} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QuestionnaireListItem instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      metadata(instance.getMetadata());
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireListItem#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireListItem#getMetadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(Questionnaire.Metadata metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaireListItem ImmutableQuestionnaireListItem}.
     * @return An immutable instance of QuestionnaireListItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaireListItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuestionnaireListItem(id, metadata);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      return "Cannot build QuestionnaireListItem, some of required attributes are not set " + attributes;
    }
  }
}
