package io.dialob.api.questionnaire;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code ContextValue}.
 * @see ImmutableContextValue
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.questionnaire", generator = "Gsons")
public final class GsonAdaptersContextValue implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ContextValueTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ContextValueTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersContextValue(ContextValue)";
  }

  @org.immutables.value.Generated(from = "ContextValue", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class ContextValueTypeAdapter extends TypeAdapter<ContextValue> {
    public final Object valueTypeSample = null;
    private final TypeAdapter<Object> valueTypeAdapter;

    ContextValueTypeAdapter(Gson gson) {
      this.valueTypeAdapter = gson.getAdapter( Object.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return ContextValue.class == type.getRawType()
          || ImmutableContextValue.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, ContextValue value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeContextValue(out, value);
      }
    }

    @Override
    public ContextValue read(JsonReader in) throws IOException {
      return readContextValue(in);
    }

    private void writeContextValue(JsonWriter out, ContextValue instance)
        throws IOException {
      out.beginObject();
      String idValue = instance.getId();
      if (idValue != null) {
        out.name("id");
        out.value(idValue);
      } else if (out.getSerializeNulls()) {
        out.name("id");
        out.nullValue();
      }
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        out.name("value");
        valueTypeAdapter.write(out, valueValue);
      } else if (out.getSerializeNulls()) {
        out.name("value");
        out.nullValue();
      }
      out.endObject();
    }

    private  ContextValue readContextValue(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableContextValue.Builder builder = ImmutableContextValue.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableContextValue.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'v':
        if ("value".equals(attributeName)) {
          readInValue(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableContextValue.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.id(in.nextString());
      }
    }

    private void readInValue(JsonReader in, ImmutableContextValue.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Object value = valueTypeAdapter.read(in);
        builder.value(value);
      }
    }
  }
}
