package io.dialob.api.proto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import io.dialob.api.questionnaire.Error;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Action}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAction.builder()}.
 */
@Generated(from = "Action", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAction implements Action {
  private final Action.Type type;
  private final @Nullable String id;
  private final @Nullable String message;
  private final @Nullable String trace;
  private final @Nullable ActionItem item;
  private final @Nullable Error error;
  private final @Nullable Object answer;
  private final @Nullable List<String> ids;
  private final @Nullable Object value;
  private final @Nullable ValueSet valueSet;
  private final @Nullable Boolean serverEvent;
  private final @Nullable String resourceId;

  private ImmutableAction(
      Action.Type type,
      @Nullable String id,
      @Nullable String message,
      @Nullable String trace,
      @Nullable ActionItem item,
      @Nullable Error error,
      @Nullable Object answer,
      @Nullable List<String> ids,
      @Nullable Object value,
      @Nullable ValueSet valueSet,
      @Nullable Boolean serverEvent,
      @Nullable String resourceId) {
    this.type = type;
    this.id = id;
    this.message = message;
    this.trace = trace;
    this.item = item;
    this.error = error;
    this.answer = answer;
    this.ids = ids;
    this.value = value;
    this.valueSet = valueSet;
    this.serverEvent = serverEvent;
    this.resourceId = resourceId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public Action.Type getType() {
    return type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public @Nullable String getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code trace} attribute
   */
  @JsonProperty("trace")
  @Override
  public @Nullable String getTrace() {
    return trace;
  }

  /**
   * @return The value of the {@code item} attribute
   */
  @JsonProperty("item")
  @Override
  public @Nullable ActionItem getItem() {
    return item;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty("error")
  @Override
  public @Nullable Error getError() {
    return error;
  }

  /**
   * @return The value of the {@code answer} attribute
   */
  @JsonProperty("answer")
  @Override
  public @Nullable Object getAnswer() {
    return answer;
  }

  /**
   * @return The value of the {@code ids} attribute
   */
  @JsonProperty("ids")
  @Override
  public @Nullable List<String> getIds() {
    return ids;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public @Nullable Object getValue() {
    return value;
  }

  /**
   * @return The value of the {@code valueSet} attribute
   */
  @JsonProperty("valueSet")
  @Override
  public @Nullable ValueSet getValueSet() {
    return valueSet;
  }

  /**
   * @return The value of the {@code serverEvent} attribute
   */
  @JsonProperty("serverEvent")
  @JsonIgnore
  @Override
  public @Nullable Boolean getServerEvent() {
    return serverEvent;
  }

  /**
   * @return The value of the {@code resourceId} attribute
   */
  @JsonProperty("resourceId")
  @JsonIgnore
  @Override
  public @Nullable String getResourceId() {
    return resourceId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withType(Action.Type value) {
    if (this.type == value) return this;
    Action.Type newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableAction(
        newValue,
        this.id,
        this.message,
        this.trace,
        this.item,
        this.error,
        this.answer,
        this.ids,
        this.value,
        this.valueSet,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableAction(
        this.type,
        value,
        this.message,
        this.trace,
        this.item,
        this.error,
        this.answer,
        this.ids,
        this.value,
        this.valueSet,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getMessage() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withMessage(@Nullable String value) {
    if (Objects.equals(this.message, value)) return this;
    return new ImmutableAction(
        this.type,
        this.id,
        value,
        this.trace,
        this.item,
        this.error,
        this.answer,
        this.ids,
        this.value,
        this.valueSet,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getTrace() trace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for trace (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withTrace(@Nullable String value) {
    if (Objects.equals(this.trace, value)) return this;
    return new ImmutableAction(
        this.type,
        this.id,
        this.message,
        value,
        this.item,
        this.error,
        this.answer,
        this.ids,
        this.value,
        this.valueSet,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getItem() item} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for item (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withItem(@Nullable ActionItem value) {
    if (this.item == value) return this;
    return new ImmutableAction(
        this.type,
        this.id,
        this.message,
        this.trace,
        value,
        this.error,
        this.answer,
        this.ids,
        this.value,
        this.valueSet,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getError() error} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for error (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withError(@Nullable Error value) {
    if (this.error == value) return this;
    return new ImmutableAction(
        this.type,
        this.id,
        this.message,
        this.trace,
        this.item,
        value,
        this.answer,
        this.ids,
        this.value,
        this.valueSet,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getAnswer() answer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for answer (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withAnswer(@Nullable Object value) {
    if (this.answer == value) return this;
    return new ImmutableAction(
        this.type,
        this.id,
        this.message,
        this.trace,
        this.item,
        this.error,
        value,
        this.ids,
        this.value,
        this.valueSet,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Action#getIds() ids}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAction withIds(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableAction(
          this.type,
          this.id,
          this.message,
          this.trace,
          this.item,
          this.error,
          this.answer,
          null,
          this.value,
          this.valueSet,
          this.serverEvent,
          this.resourceId);
    }
    List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableAction(
        this.type,
        this.id,
        this.message,
        this.trace,
        this.item,
        this.error,
        this.answer,
        newValue,
        this.value,
        this.valueSet,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Action#getIds() ids}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ids elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAction withIds(@Nullable Iterable<String> elements) {
    if (this.ids == elements) return this;
    List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableAction(
        this.type,
        this.id,
        this.message,
        this.trace,
        this.item,
        this.error,
        this.answer,
        newValue,
        this.value,
        this.valueSet,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withValue(@Nullable Object value) {
    if (this.value == value) return this;
    return new ImmutableAction(
        this.type,
        this.id,
        this.message,
        this.trace,
        this.item,
        this.error,
        this.answer,
        this.ids,
        value,
        this.valueSet,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getValueSet() valueSet} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueSet (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withValueSet(@Nullable ValueSet value) {
    if (this.valueSet == value) return this;
    return new ImmutableAction(
        this.type,
        this.id,
        this.message,
        this.trace,
        this.item,
        this.error,
        this.answer,
        this.ids,
        this.value,
        value,
        this.serverEvent,
        this.resourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getServerEvent() serverEvent} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serverEvent (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withServerEvent(@Nullable Boolean value) {
    if (Objects.equals(this.serverEvent, value)) return this;
    return new ImmutableAction(
        this.type,
        this.id,
        this.message,
        this.trace,
        this.item,
        this.error,
        this.answer,
        this.ids,
        this.value,
        this.valueSet,
        value,
        this.resourceId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Action#getResourceId() resourceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAction withResourceId(@Nullable String value) {
    if (Objects.equals(this.resourceId, value)) return this;
    return new ImmutableAction(
        this.type,
        this.id,
        this.message,
        this.trace,
        this.item,
        this.error,
        this.answer,
        this.ids,
        this.value,
        this.valueSet,
        this.serverEvent,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAction
        && equalTo((ImmutableAction) another);
  }

  private boolean equalTo(ImmutableAction another) {
    return type.equals(another.type)
        && Objects.equals(id, another.id)
        && Objects.equals(message, another.message)
        && Objects.equals(trace, another.trace)
        && Objects.equals(item, another.item)
        && Objects.equals(error, another.error)
        && Objects.equals(answer, another.answer)
        && Objects.equals(ids, another.ids)
        && Objects.equals(value, another.value)
        && Objects.equals(valueSet, another.valueSet)
        && Objects.equals(serverEvent, another.serverEvent)
        && Objects.equals(resourceId, another.resourceId);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code id}, {@code message}, {@code trace}, {@code item}, {@code error}, {@code answer}, {@code ids}, {@code value}, {@code valueSet}, {@code serverEvent}, {@code resourceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(message);
    h += (h << 5) + Objects.hashCode(trace);
    h += (h << 5) + Objects.hashCode(item);
    h += (h << 5) + Objects.hashCode(error);
    h += (h << 5) + Objects.hashCode(answer);
    h += (h << 5) + Objects.hashCode(ids);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(valueSet);
    h += (h << 5) + Objects.hashCode(serverEvent);
    h += (h << 5) + Objects.hashCode(resourceId);
    return h;
  }

  /**
   * Prints the immutable value {@code Action} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Action{"
        + "type=" + type
        + ", id=" + id
        + ", message=" + message
        + ", trace=" + trace
        + ", item=" + item
        + ", error=" + error
        + ", answer=" + answer
        + ", ids=" + ids
        + ", value=" + value
        + ", valueSet=" + valueSet
        + ", serverEvent=" + serverEvent
        + ", resourceId=" + resourceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Action", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Action {
    @javax.annotation.Nullable Action.Type type;
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable String message;
    @javax.annotation.Nullable String trace;
    @javax.annotation.Nullable ActionItem item;
    @javax.annotation.Nullable Error error;
    @javax.annotation.Nullable Object answer;
    @javax.annotation.Nullable List<String> ids = null;
    @javax.annotation.Nullable Object value;
    @javax.annotation.Nullable ValueSet valueSet;
    @javax.annotation.Nullable Boolean serverEvent;
    @javax.annotation.Nullable String resourceId;
    @JsonProperty("type")
    public void setType(Action.Type type) {
      this.type = type;
    }
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("message")
    public void setMessage(@Nullable String message) {
      this.message = message;
    }
    @JsonProperty("trace")
    public void setTrace(@Nullable String trace) {
      this.trace = trace;
    }
    @JsonProperty("item")
    public void setItem(@Nullable ActionItem item) {
      this.item = item;
    }
    @JsonProperty("error")
    public void setError(@Nullable Error error) {
      this.error = error;
    }
    @JsonProperty("answer")
    public void setAnswer(@Nullable Object answer) {
      this.answer = answer;
    }
    @JsonProperty("ids")
    public void setIds(@Nullable List<String> ids) {
      this.ids = ids;
    }
    @JsonProperty("value")
    public void setValue(@Nullable Object value) {
      this.value = value;
    }
    @JsonProperty("valueSet")
    public void setValueSet(@Nullable ValueSet valueSet) {
      this.valueSet = valueSet;
    }
    @JsonProperty("serverEvent")
    @JsonIgnore
    public void setServerEvent(@Nullable Boolean serverEvent) {
      this.serverEvent = serverEvent;
    }
    @JsonProperty("resourceId")
    @JsonIgnore
    public void setResourceId(@Nullable String resourceId) {
      this.resourceId = resourceId;
    }
    @Override
    public Action.Type getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public String getTrace() { throw new UnsupportedOperationException(); }
    @Override
    public ActionItem getItem() { throw new UnsupportedOperationException(); }
    @Override
    public Error getError() { throw new UnsupportedOperationException(); }
    @Override
    public Object getAnswer() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getIds() { throw new UnsupportedOperationException(); }
    @Override
    public Object getValue() { throw new UnsupportedOperationException(); }
    @Override
    public ValueSet getValueSet() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getServerEvent() { throw new UnsupportedOperationException(); }
    @Override
    public String getResourceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAction fromJson(Json json) {
    ImmutableAction.Builder builder = ImmutableAction.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.trace != null) {
      builder.trace(json.trace);
    }
    if (json.item != null) {
      builder.item(json.item);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.answer != null) {
      builder.answer(json.answer);
    }
    if (json.ids != null) {
      builder.addAllIds(json.ids);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.valueSet != null) {
      builder.valueSet(json.valueSet);
    }
    if (json.serverEvent != null) {
      builder.serverEvent(json.serverEvent);
    }
    if (json.resourceId != null) {
      builder.resourceId(json.resourceId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Action} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Action instance
   */
  public static ImmutableAction copyOf(Action instance) {
    if (instance instanceof ImmutableAction) {
      return (ImmutableAction) instance;
    }
    return ImmutableAction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAction ImmutableAction}.
   * <pre>
   * ImmutableAction.builder()
   *    .type(io.dialob.api.proto.Action.Type) // required {@link Action#getType() type}
   *    .id(String | null) // nullable {@link Action#getId() id}
   *    .message(String | null) // nullable {@link Action#getMessage() message}
   *    .trace(String | null) // nullable {@link Action#getTrace() trace}
   *    .item(io.dialob.api.proto.ActionItem | null) // nullable {@link Action#getItem() item}
   *    .error(io.dialob.api.questionnaire.Error | null) // nullable {@link Action#getError() error}
   *    .answer(Object | null) // nullable {@link Action#getAnswer() answer}
   *    .ids(List&amp;lt;String&amp;gt; | null) // nullable {@link Action#getIds() ids}
   *    .value(Object | null) // nullable {@link Action#getValue() value}
   *    .valueSet(io.dialob.api.proto.ValueSet | null) // nullable {@link Action#getValueSet() valueSet}
   *    .serverEvent(Boolean | null) // nullable {@link Action#getServerEvent() serverEvent}
   *    .resourceId(String | null) // nullable {@link Action#getResourceId() resourceId}
   *    .build();
   * </pre>
   * @return A new ImmutableAction builder
   */
  public static ImmutableAction.Builder builder() {
    return new ImmutableAction.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAction ImmutableAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Action", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable Action.Type type;
    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String message;
    private @javax.annotation.Nullable String trace;
    private @javax.annotation.Nullable ActionItem item;
    private @javax.annotation.Nullable Error error;
    private @javax.annotation.Nullable Object answer;
    private List<String> ids = null;
    private @javax.annotation.Nullable Object value;
    private @javax.annotation.Nullable ValueSet valueSet;
    private @javax.annotation.Nullable Boolean serverEvent;
    private @javax.annotation.Nullable String resourceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Action} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Action instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String messageValue = instance.getMessage();
      if (messageValue != null) {
        message(messageValue);
      }
      String traceValue = instance.getTrace();
      if (traceValue != null) {
        trace(traceValue);
      }
      ActionItem itemValue = instance.getItem();
      if (itemValue != null) {
        item(itemValue);
      }
      Error errorValue = instance.getError();
      if (errorValue != null) {
        error(errorValue);
      }
      Object answerValue = instance.getAnswer();
      if (answerValue != null) {
        answer(answerValue);
      }
      List<String> idsValue = instance.getIds();
      if (idsValue != null) {
        addAllIds(idsValue);
      }
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      ValueSet valueSetValue = instance.getValueSet();
      if (valueSetValue != null) {
        valueSet(valueSetValue);
      }
      Boolean serverEventValue = instance.getServerEvent();
      if (serverEventValue != null) {
        serverEvent(serverEventValue);
      }
      String resourceIdValue = instance.getResourceId();
      if (resourceIdValue != null) {
        resourceId(resourceIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(Action.Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getMessage() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final Builder message(@Nullable String message) {
      this.message = message;
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getTrace() trace} attribute.
     * @param trace The value for trace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("trace")
    public final Builder trace(@Nullable String trace) {
      this.trace = trace;
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getItem() item} attribute.
     * @param item The value for item (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("item")
    public final Builder item(@Nullable ActionItem item) {
      this.item = item;
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error")
    public final Builder error(@Nullable Error error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getAnswer() answer} attribute.
     * @param answer The value for answer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("answer")
    public final Builder answer(@Nullable Object answer) {
      this.answer = answer;
      return this;
    }

    /**
     * Adds one element to {@link Action#getIds() ids} list.
     * @param element A ids element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addIds(String element) {
      if (this.ids == null) {
        this.ids = new ArrayList<String>();
      }
      this.ids.add(Objects.requireNonNull(element, "ids element"));
      return this;
    }

    /**
     * Adds elements to {@link Action#getIds() ids} list.
     * @param elements An array of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addIds(String... elements) {
      if (this.ids == null) {
        this.ids = new ArrayList<String>();
      }
      for (String element : elements) {
        this.ids.add(Objects.requireNonNull(element, "ids element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Action#getIds() ids} list.
     * @param elements An iterable of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ids")
    public final Builder ids(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.ids = null;
        return this;
      }
      this.ids = new ArrayList<String>();
      return addAllIds(elements);
    }

    /**
     * Adds elements to {@link Action#getIds() ids} list.
     * @param elements An iterable of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "ids element");
      if (this.ids == null) {
        this.ids = new ArrayList<String>();
      }
      for (String element : elements) {
        this.ids.add(Objects.requireNonNull(element, "ids element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(@Nullable Object value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getValueSet() valueSet} attribute.
     * @param valueSet The value for valueSet (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("valueSet")
    public final Builder valueSet(@Nullable ValueSet valueSet) {
      this.valueSet = valueSet;
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getServerEvent() serverEvent} attribute.
     * @param serverEvent The value for serverEvent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("serverEvent")
    @JsonIgnore
    public final Builder serverEvent(@Nullable Boolean serverEvent) {
      this.serverEvent = serverEvent;
      return this;
    }

    /**
     * Initializes the value for the {@link Action#getResourceId() resourceId} attribute.
     * @param resourceId The value for resourceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resourceId")
    @JsonIgnore
    public final Builder resourceId(@Nullable String resourceId) {
      this.resourceId = resourceId;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAction ImmutableAction}.
     * @return An immutable instance of Action
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAction build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAction(
          type,
          id,
          message,
          trace,
          item,
          error,
          answer,
          ids == null ? null : createUnmodifiableList(true, ids),
          value,
          valueSet,
          serverEvent,
          resourceId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build Action, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
