package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Validation Validation} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableValidation is not thread-safe</em>
 * @see ImmutableValidation
 */
@Generated(from = "Validation", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "Validation"})
@NotThreadSafe
public final class ModifiableValidation implements Validation {

  private final Map<String, String> message = new LinkedHashMap<String, String>();
  private @Nullable String rule;

  private ModifiableValidation() {}

  /**
   * Construct a modifiable instance of {@code Validation}.
   * @return A new modifiable instance
   */
  public static ModifiableValidation create() {
    return new ModifiableValidation();
  }

  /**
   * @return value of {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public final Map<String, String> getMessage() {
    return message;
  }

  /**
   * @return value of {@code rule} attribute, may be {@code null}
   */
  @JsonProperty("rule")
  @Override
  public final @Nullable String getRule() {
    return rule;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableValidation clear() {
    message.clear();
    rule = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Validation} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableValidation from(Validation instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableValidation) {
      from((ModifiableValidation) instance);
      return this;
    }
    putAllMessage(instance.getMessage());
    String ruleValue = instance.getRule();
    if (ruleValue != null) {
      setRule(ruleValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Validation} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableValidation from(ModifiableValidation instance) {
    Objects.requireNonNull(instance, "instance");
    putAllMessage(instance.getMessage());
    String ruleValue = instance.getRule();
    if (ruleValue != null) {
      setRule(ruleValue);
    }
    return this;
  }

  /**
   * Put one entry to the {@link Validation#getMessage() message} map.
   * @param key The key in message map
   * @param value The associated value in the message map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableValidation putMessage(String key, String value) {
    this.message.put(
        Objects.requireNonNull(key, "message key"),
        Objects.requireNonNull(value, "message value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Validation#getMessage() message} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the message map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableValidation setMessage(Map<String, ? extends String> entries) {
    this.message.clear();
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.message.put(
          Objects.requireNonNull(k, "message key"),
          Objects.requireNonNull(v, "message value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Validation#getMessage() message} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to message map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableValidation putAllMessage(Map<String, ? extends String> entries) {
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.message.put(
          Objects.requireNonNull(k, "message key"),
          Objects.requireNonNull(v, "message value"));
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Validation#getRule() rule} attribute.
   * @param rule The value for rule, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableValidation setRule(@Nullable String rule) {
    this.rule = rule;
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableValidation ImmutableValidation}.
   * @return An immutable instance of Validation
   */
  public final ImmutableValidation toImmutable() {
    return ImmutableValidation.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableValidation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableValidation)) return false;
    ModifiableValidation other = (ModifiableValidation) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableValidation another) {
    return message.equals(another.message)
        && Objects.equals(rule, another.rule);
  }

  /**
   * Computes a hash code from attributes: {@code message}, {@code rule}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + message.hashCode();
    h += (h << 5) + Objects.hashCode(rule);
    return h;
  }

  /**
   * Generates a string representation of this {@code Validation}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableValidation{"
        + "message=" + getMessage()
        + ", rule=" + getRule()
        + "}";
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
