package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Variable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVariable.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableVariable.of()}.
 */
@Generated(from = "Variable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableVariable implements Variable {
  private final String name;
  private final @Nullable String expression;
  private final @Nullable Object defaultValue;
  private final @Nullable Boolean context;
  private final @Nullable Boolean published;
  private final @Nullable String contextType;

  private ImmutableVariable(String name, @Nullable String expression) {
    this.name = name;
    this.expression = expression;
    this.defaultValue = null;
    this.context = null;
    this.published = null;
    this.contextType = null;
  }

  private ImmutableVariable(
      String name,
      @Nullable String expression,
      @Nullable Object defaultValue,
      @Nullable Boolean context,
      @Nullable Boolean published,
      @Nullable String contextType) {
    this.name = name;
    this.expression = expression;
    this.defaultValue = defaultValue;
    this.context = context;
    this.published = published;
    this.contextType = contextType;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @JsonProperty("expression")
  @Override
  public @Nullable String getExpression() {
    return expression;
  }

  /**
   * @return The value of the {@code defaultValue} attribute
   */
  @JsonProperty("defaultValue")
  @Override
  public @Nullable Object getDefaultValue() {
    return defaultValue;
  }

  /**
   * @return true when this is context variable
   */
  @JsonProperty("context")
  @Override
  public @Nullable Boolean getContext() {
    return context;
  }

  /**
   * @return true when context variable can be published and sent to client.
   */
  @JsonProperty("published")
  @Override
  public @Nullable Boolean getPublished() {
    return published;
  }

  /**
   * @return The value of the {@code contextType} attribute
   */
  @JsonProperty("contextType")
  @Override
  public @Nullable String getContextType() {
    return contextType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Variable#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariable withName(String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableVariable(value, this.expression, this.defaultValue, this.context, this.published, this.contextType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Variable#getExpression() expression} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariable withExpression(@Nullable String value) {
    if (Objects.equals(this.expression, value)) return this;
    return new ImmutableVariable(this.name, value, this.defaultValue, this.context, this.published, this.contextType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Variable#getDefaultValue() defaultValue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariable withDefaultValue(@Nullable Object value) {
    if (this.defaultValue == value) return this;
    return new ImmutableVariable(this.name, this.expression, value, this.context, this.published, this.contextType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Variable#getContext() context} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for context (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariable withContext(@Nullable Boolean value) {
    if (Objects.equals(this.context, value)) return this;
    return new ImmutableVariable(this.name, this.expression, this.defaultValue, value, this.published, this.contextType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Variable#getPublished() published} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for published (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariable withPublished(@Nullable Boolean value) {
    if (Objects.equals(this.published, value)) return this;
    return new ImmutableVariable(this.name, this.expression, this.defaultValue, this.context, value, this.contextType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Variable#getContextType() contextType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contextType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariable withContextType(@Nullable String value) {
    if (Objects.equals(this.contextType, value)) return this;
    return new ImmutableVariable(this.name, this.expression, this.defaultValue, this.context, this.published, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVariable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVariable
        && equalTo((ImmutableVariable) another);
  }

  private boolean equalTo(ImmutableVariable another) {
    return Objects.equals(name, another.name)
        && Objects.equals(expression, another.expression)
        && Objects.equals(defaultValue, another.defaultValue)
        && Objects.equals(context, another.context)
        && Objects.equals(published, another.published)
        && Objects.equals(contextType, another.contextType);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code expression}, {@code defaultValue}, {@code context}, {@code published}, {@code contextType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(expression);
    h += (h << 5) + Objects.hashCode(defaultValue);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(published);
    h += (h << 5) + Objects.hashCode(contextType);
    return h;
  }

  /**
   * Prints the immutable value {@code Variable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Variable{"
        + "name=" + name
        + ", expression=" + expression
        + ", defaultValue=" + defaultValue
        + ", context=" + context
        + ", published=" + published
        + ", contextType=" + contextType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Variable", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Variable {
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String expression;
    @javax.annotation.Nullable Object defaultValue;
    @javax.annotation.Nullable Boolean context;
    @javax.annotation.Nullable Boolean published;
    @javax.annotation.Nullable String contextType;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("expression")
    public void setExpression(@Nullable String expression) {
      this.expression = expression;
    }
    @JsonProperty("defaultValue")
    public void setDefaultValue(@Nullable Object defaultValue) {
      this.defaultValue = defaultValue;
    }
    @JsonProperty("context")
    public void setContext(@Nullable Boolean context) {
      this.context = context;
    }
    @JsonProperty("published")
    public void setPublished(@Nullable Boolean published) {
      this.published = published;
    }
    @JsonProperty("contextType")
    public void setContextType(@Nullable String contextType) {
      this.contextType = contextType;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getExpression() { throw new UnsupportedOperationException(); }
    @Override
    public Object getDefaultValue() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getContext() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPublished() { throw new UnsupportedOperationException(); }
    @Override
    public String getContextType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableVariable fromJson(Json json) {
    ImmutableVariable.Builder builder = ImmutableVariable.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.expression != null) {
      builder.expression(json.expression);
    }
    if (json.defaultValue != null) {
      builder.defaultValue(json.defaultValue);
    }
    if (json.context != null) {
      builder.context(json.context);
    }
    if (json.published != null) {
      builder.published(json.published);
    }
    if (json.contextType != null) {
      builder.contextType(json.contextType);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Variable} instance.
   * @param name The value for the {@code name} attribute
   * @param expression The value for the {@code expression} attribute
   * @return An immutable Variable instance
   */
  public static ImmutableVariable of(String name, @Nullable String expression) {
    return new ImmutableVariable(name, expression);
  }

  /**
   * Creates an immutable copy of a {@link Variable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Variable instance
   */
  public static ImmutableVariable copyOf(Variable instance) {
    if (instance instanceof ImmutableVariable) {
      return (ImmutableVariable) instance;
    }
    return ImmutableVariable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVariable ImmutableVariable}.
   * <pre>
   * ImmutableVariable.builder()
   *    .name(String | null) // nullable {@link Variable#getName() name}
   *    .expression(String | null) // nullable {@link Variable#getExpression() expression}
   *    .defaultValue(Object | null) // nullable {@link Variable#getDefaultValue() defaultValue}
   *    .context(Boolean | null) // nullable {@link Variable#getContext() context}
   *    .published(Boolean | null) // nullable {@link Variable#getPublished() published}
   *    .contextType(String | null) // nullable {@link Variable#getContextType() contextType}
   *    .build();
   * </pre>
   * @return A new ImmutableVariable builder
   */
  public static ImmutableVariable.Builder builder() {
    return new ImmutableVariable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVariable ImmutableVariable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Variable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String expression;
    private @javax.annotation.Nullable Object defaultValue;
    private @javax.annotation.Nullable Boolean context;
    private @javax.annotation.Nullable Boolean published;
    private @javax.annotation.Nullable String contextType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableVariable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableVariable instance) {
      Objects.requireNonNull(instance, "instance");
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String expressionValue = instance.getExpression();
      if (expressionValue != null) {
        expression(expressionValue);
      }
      Object defaultValueValue = instance.getDefaultValue();
      if (defaultValueValue != null) {
        defaultValue(defaultValueValue);
      }
      Boolean contextValue = instance.getContext();
      if (contextValue != null) {
        context(contextValue);
      }
      Boolean publishedValue = instance.getPublished();
      if (publishedValue != null) {
        published(publishedValue);
      }
      String contextTypeValue = instance.getContextType();
      if (contextTypeValue != null) {
        contextType(contextTypeValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Variable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Variable instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableVariable) {
        return from((ModifiableVariable) instance);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String expressionValue = instance.getExpression();
      if (expressionValue != null) {
        expression(expressionValue);
      }
      Object defaultValueValue = instance.getDefaultValue();
      if (defaultValueValue != null) {
        defaultValue(defaultValueValue);
      }
      Boolean contextValue = instance.getContext();
      if (contextValue != null) {
        context(contextValue);
      }
      Boolean publishedValue = instance.getPublished();
      if (publishedValue != null) {
        published(publishedValue);
      }
      String contextTypeValue = instance.getContextType();
      if (contextTypeValue != null) {
        contextType(contextTypeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Variable#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Variable#getExpression() expression} attribute.
     * @param expression The value for expression (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("expression")
    public final Builder expression(@Nullable String expression) {
      this.expression = expression;
      return this;
    }

    /**
     * Initializes the value for the {@link Variable#getDefaultValue() defaultValue} attribute.
     * @param defaultValue The value for defaultValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("defaultValue")
    public final Builder defaultValue(@Nullable Object defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }

    /**
     * Initializes the value for the {@link Variable#getContext() context} attribute.
     * @param context The value for context (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("context")
    public final Builder context(@Nullable Boolean context) {
      this.context = context;
      return this;
    }

    /**
     * Initializes the value for the {@link Variable#getPublished() published} attribute.
     * @param published The value for published (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("published")
    public final Builder published(@Nullable Boolean published) {
      this.published = published;
      return this;
    }

    /**
     * Initializes the value for the {@link Variable#getContextType() contextType} attribute.
     * @param contextType The value for contextType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("contextType")
    public final Builder contextType(@Nullable String contextType) {
      this.contextType = contextType;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVariable ImmutableVariable}.
     * @return An immutable instance of Variable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVariable build() {
      return new ImmutableVariable(name, expression, defaultValue, context, published, contextType);
    }
  }
}
