package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormValueSetEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormValueSetEntry.builder()}.
 */
@Generated(from = "FormValueSetEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFormValueSetEntry implements FormValueSetEntry {
  private final String id;
  private final Map<String, String> label;
  private final @Nullable String when;
  private final Map<String, Object> additionalProperties;

  private ImmutableFormValueSetEntry(
      String id,
      Map<String, String> label,
      @Nullable String when,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.label = label;
    this.when = when;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public Map<String, String> getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code when} attribute
   */
  @JsonProperty("when")
  @Override
  public @Nullable String getWhen() {
    return when;
  }

  /**
   * @return The value of the {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @JsonInclude
  @JsonAnyGetter
  @Override
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormValueSetEntry#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormValueSetEntry withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableFormValueSetEntry(newValue, this.label, this.when, this.additionalProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link FormValueSetEntry#getLabel() label} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the label map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValueSetEntry withLabel(Map<String, ? extends String> entries) {
    if (this.label == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableFormValueSetEntry(this.id, newValue, this.when, this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormValueSetEntry#getWhen() when} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for when (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormValueSetEntry withWhen(@Nullable String value) {
    if (Objects.equals(this.when, value)) return this;
    return new ImmutableFormValueSetEntry(this.id, this.label, value, this.additionalProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link FormValueSetEntry#getAdditionalProperties() additionalProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the additionalProperties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValueSetEntry withAdditionalProperties(Map<String, ? extends Object> entries) {
    if (this.additionalProperties == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableFormValueSetEntry(this.id, this.label, this.when, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormValueSetEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormValueSetEntry
        && equalTo((ImmutableFormValueSetEntry) another);
  }

  private boolean equalTo(ImmutableFormValueSetEntry another) {
    return id.equals(another.id)
        && label.equals(another.label)
        && Objects.equals(when, another.when)
        && additionalProperties.equals(another.additionalProperties);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code label}, {@code when}, {@code additionalProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + label.hashCode();
    h += (h << 5) + Objects.hashCode(when);
    h += (h << 5) + additionalProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormValueSetEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FormValueSetEntry{"
        + "id=" + id
        + ", label=" + label
        + ", when=" + when
        + ", additionalProperties=" + additionalProperties
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FormValueSetEntry", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FormValueSetEntry {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable Map<String, String> label = Collections.emptyMap();
    @javax.annotation.Nullable String when;
    final Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("label")
    public void setLabel(Map<String, String> label) {
      this.label = label;
    }
    @JsonProperty("when")
    public void setWhen(@Nullable String when) {
      this.when = when;
    }

    @JsonAnySetter
    public void setAdditionalProperties(String key, Object value) {
      this.additionalProperties.put(key, value);
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public String getWhen() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getAdditionalProperties() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormValueSetEntry fromJson(Json json) {
    ImmutableFormValueSetEntry.Builder builder = ImmutableFormValueSetEntry.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.label != null) {
      builder.putAllLabel(json.label);
    }
    if (json.when != null) {
      builder.when(json.when);
    }
    if (json.additionalProperties != null) {
      builder.putAllAdditionalProperties(json.additionalProperties);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FormValueSetEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormValueSetEntry instance
   */
  public static ImmutableFormValueSetEntry copyOf(FormValueSetEntry instance) {
    if (instance instanceof ImmutableFormValueSetEntry) {
      return (ImmutableFormValueSetEntry) instance;
    }
    return ImmutableFormValueSetEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormValueSetEntry ImmutableFormValueSetEntry}.
   * <pre>
   * ImmutableFormValueSetEntry.builder()
   *    .id(String) // required {@link FormValueSetEntry#getId() id}
   *    .putLabel|putAllLabel(String =&gt; String) // {@link FormValueSetEntry#getLabel() label} mappings
   *    .when(String | null) // nullable {@link FormValueSetEntry#getWhen() when}
   *    .putAdditionalProperties|putAllAdditionalProperties(String =&gt; Object) // {@link FormValueSetEntry#getAdditionalProperties() additionalProperties} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableFormValueSetEntry builder
   */
  public static ImmutableFormValueSetEntry.Builder builder() {
    return new ImmutableFormValueSetEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormValueSetEntry ImmutableFormValueSetEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormValueSetEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String id;
    private Map<String, String> label = new LinkedHashMap<String, String>();
    private @javax.annotation.Nullable String when;
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableFormValueSetEntry} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableFormValueSetEntry instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.idIsSet()) {
        id(instance.getId());
      }
      putAllLabel(instance.getLabel());
      String whenValue = instance.getWhen();
      if (whenValue != null) {
        when(whenValue);
      }
      putAllAdditionalProperties(instance.getAdditionalProperties());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code FormValueSetEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormValueSetEntry instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableFormValueSetEntry) {
        return from((ModifiableFormValueSetEntry) instance);
      }
      id(instance.getId());
      putAllLabel(instance.getLabel());
      String whenValue = instance.getWhen();
      if (whenValue != null) {
        when(whenValue);
      }
      putAllAdditionalProperties(instance.getAdditionalProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link FormValueSetEntry#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link FormValueSetEntry#getLabel() label} map.
     * @param key The key in the label map
     * @param value The associated value in the label map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putLabel(String key, String value) {
      this.label.put(
          Objects.requireNonNull(key, "label key"),
          Objects.requireNonNull(value, "label value"));
      return this;
    }

    /**
     * Put one entry to the {@link FormValueSetEntry#getLabel() label} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putLabel(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.label.put(
          Objects.requireNonNull(k, "label key"),
          Objects.requireNonNull(v, "label value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FormValueSetEntry#getLabel() label} map. Nulls are not permitted
     * @param entries The entries that will be added to the label map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(Map<String, ? extends String> entries) {
      this.label.clear();
      return putAllLabel(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FormValueSetEntry#getLabel() label} map. Nulls are not permitted
     * @param entries The entries that will be added to the label map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLabel(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.label.put(
            Objects.requireNonNull(k, "label key"),
            Objects.requireNonNull(v, "label value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FormValueSetEntry#getWhen() when} attribute.
     * @param when The value for when (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("when")
    public final Builder when(@Nullable String when) {
      this.when = when;
      return this;
    }

    /**
     * Put one entry to the {@link FormValueSetEntry#getAdditionalProperties() additionalProperties} map.
     * @param key The key in the additionalProperties map
     * @param value The associated value in the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonAnySetter
    public final Builder putAdditionalProperties(@javax.annotation.Nullable String key, @javax.annotation.Nullable Object value) {
      this.additionalProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FormValueSetEntry#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAdditionalProperties(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.additionalProperties.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FormValueSetEntry#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("additionalProperties")
    @JsonInclude
    public final Builder additionalProperties(Map<String, ? extends Object> entries) {
      this.additionalProperties.clear();
      return putAllAdditionalProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FormValueSetEntry#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAdditionalProperties(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.additionalProperties.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormValueSetEntry ImmutableFormValueSetEntry}.
     * @return An immutable instance of FormValueSetEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormValueSetEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormValueSetEntry(
          id,
          createUnmodifiableMap(false, false, label),
          when,
          createUnmodifiableMap(false, false, additionalProperties));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build FormValueSetEntry, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
