package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormValidationError}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormValidationError.builder()}.
 */
@Generated(from = "FormValidationError", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFormValidationError implements FormValidationError {
  private final String itemId;
  private final String message;
  private final FormValidationError.Level level;
  private final FormValidationError.Type type;
  private final @Nullable String expression;
  private final @Nullable Integer startIndex;
  private final @Nullable Integer endIndex;
  private final @Nullable Integer index;

  private ImmutableFormValidationError(ImmutableFormValidationError.Builder builder) {
    this.itemId = builder.itemId;
    this.message = builder.message;
    this.type = builder.type;
    this.expression = builder.expression;
    this.startIndex = builder.startIndex;
    this.endIndex = builder.endIndex;
    this.index = builder.index;
    this.level = builder.level != null
        ? builder.level
        : Objects.requireNonNull(FormValidationError.super.getLevel(), "level");
  }

  private ImmutableFormValidationError(
      String itemId,
      String message,
      FormValidationError.Level level,
      FormValidationError.Type type,
      @Nullable String expression,
      @Nullable Integer startIndex,
      @Nullable Integer endIndex,
      @Nullable Integer index) {
    this.itemId = itemId;
    this.message = message;
    this.level = level;
    this.type = type;
    this.expression = expression;
    this.startIndex = startIndex;
    this.endIndex = endIndex;
    this.index = index;
  }

  /**
   * @return The value of the {@code itemId} attribute
   */
  @JsonProperty("itemId")
  @Override
  public String getItemId() {
    return itemId;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public String getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code level} attribute
   */
  @JsonProperty("level")
  @Override
  public FormValidationError.Level getLevel() {
    return level;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public FormValidationError.Type getType() {
    return type;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @JsonProperty("expression")
  @Override
  public Optional<String> getExpression() {
    return Optional.ofNullable(expression);
  }

  /**
   * @return The value of the {@code startIndex} attribute
   */
  @JsonProperty("startIndex")
  @Override
  public Optional<Integer> getStartIndex() {
    return Optional.ofNullable(startIndex);
  }

  /**
   * @return The value of the {@code endIndex} attribute
   */
  @JsonProperty("endIndex")
  @Override
  public Optional<Integer> getEndIndex() {
    return Optional.ofNullable(endIndex);
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @JsonProperty("index")
  @Override
  public Optional<Integer> getIndex() {
    return Optional.ofNullable(index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormValidationError#getItemId() itemId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormValidationError withItemId(String value) {
    if (Objects.equals(this.itemId, value)) return this;
    return new ImmutableFormValidationError(
        value,
        this.message,
        this.level,
        this.type,
        this.expression,
        this.startIndex,
        this.endIndex,
        this.index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormValidationError#getMessage() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormValidationError withMessage(String value) {
    if (Objects.equals(this.message, value)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        value,
        this.level,
        this.type,
        this.expression,
        this.startIndex,
        this.endIndex,
        this.index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormValidationError#getLevel() level} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for level
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormValidationError withLevel(FormValidationError.Level value) {
    if (this.level == value) return this;
    FormValidationError.Level newValue = Objects.requireNonNull(value, "level");
    if (this.level.equals(newValue)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        this.message,
        newValue,
        this.type,
        this.expression,
        this.startIndex,
        this.endIndex,
        this.index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormValidationError#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormValidationError withType(FormValidationError.Type value) {
    if (this.type == value) return this;
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        this.message,
        this.level,
        value,
        this.expression,
        this.startIndex,
        this.endIndex,
        this.index);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormValidationError#getExpression() expression} attribute.
   * @param value The value for expression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValidationError withExpression(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "expression");
    if (Objects.equals(this.expression, newValue)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        this.message,
        this.level,
        this.type,
        newValue,
        this.startIndex,
        this.endIndex,
        this.index);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormValidationError#getExpression() expression} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for expression
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValidationError withExpression(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.expression, value)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        this.message,
        this.level,
        this.type,
        value,
        this.startIndex,
        this.endIndex,
        this.index);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormValidationError#getStartIndex() startIndex} attribute.
   * @param value The value for startIndex
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValidationError withStartIndex(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.startIndex, newValue)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        this.message,
        this.level,
        this.type,
        this.expression,
        newValue,
        this.endIndex,
        this.index);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormValidationError#getStartIndex() startIndex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for startIndex
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValidationError withStartIndex(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.startIndex, value)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        this.message,
        this.level,
        this.type,
        this.expression,
        value,
        this.endIndex,
        this.index);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormValidationError#getEndIndex() endIndex} attribute.
   * @param value The value for endIndex
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValidationError withEndIndex(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.endIndex, newValue)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        this.message,
        this.level,
        this.type,
        this.expression,
        this.startIndex,
        newValue,
        this.index);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormValidationError#getEndIndex() endIndex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for endIndex
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValidationError withEndIndex(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.endIndex, value)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        this.message,
        this.level,
        this.type,
        this.expression,
        this.startIndex,
        value,
        this.index);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FormValidationError#getIndex() index} attribute.
   * @param value The value for index
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValidationError withIndex(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.index, newValue)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        this.message,
        this.level,
        this.type,
        this.expression,
        this.startIndex,
        this.endIndex,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FormValidationError#getIndex() index} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for index
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormValidationError withIndex(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.index, value)) return this;
    return new ImmutableFormValidationError(
        this.itemId,
        this.message,
        this.level,
        this.type,
        this.expression,
        this.startIndex,
        this.endIndex,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormValidationError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormValidationError
        && equalTo((ImmutableFormValidationError) another);
  }

  private boolean equalTo(ImmutableFormValidationError another) {
    return Objects.equals(itemId, another.itemId)
        && Objects.equals(message, another.message)
        && level.equals(another.level)
        && Objects.equals(type, another.type)
        && Objects.equals(expression, another.expression)
        && Objects.equals(startIndex, another.startIndex)
        && Objects.equals(endIndex, another.endIndex)
        && Objects.equals(index, another.index);
  }

  /**
   * Computes a hash code from attributes: {@code itemId}, {@code message}, {@code level}, {@code type}, {@code expression}, {@code startIndex}, {@code endIndex}, {@code index}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(itemId);
    h += (h << 5) + Objects.hashCode(message);
    h += (h << 5) + level.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(expression);
    h += (h << 5) + Objects.hashCode(startIndex);
    h += (h << 5) + Objects.hashCode(endIndex);
    h += (h << 5) + Objects.hashCode(index);
    return h;
  }

  /**
   * Prints the immutable value {@code FormValidationError} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("FormValidationError{");
    if (itemId != null) {
      builder.append("itemId=").append(itemId);
    }
    if (message != null) {
      if (builder.length() > 20) builder.append(", ");
      builder.append("message=").append(message);
    }
    if (builder.length() > 20) builder.append(", ");
    builder.append("level=").append(level);
    if (type != null) {
      builder.append(", ");
      builder.append("type=").append(type);
    }
    if (expression != null) {
      builder.append(", ");
      builder.append("expression=").append(expression);
    }
    if (startIndex != null) {
      builder.append(", ");
      builder.append("startIndex=").append(startIndex);
    }
    if (endIndex != null) {
      builder.append(", ");
      builder.append("endIndex=").append(endIndex);
    }
    if (index != null) {
      builder.append(", ");
      builder.append("index=").append(index);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FormValidationError", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FormValidationError {
    @Nullable String itemId;
    @Nullable String message;
    @Nullable FormValidationError.Level level;
    @Nullable FormValidationError.Type type;
    @Nullable Optional<String> expression = Optional.empty();
    @Nullable Optional<Integer> startIndex = Optional.empty();
    @Nullable Optional<Integer> endIndex = Optional.empty();
    @Nullable Optional<Integer> index = Optional.empty();
    @JsonProperty("itemId")
    public void setItemId(String itemId) {
      this.itemId = itemId;
    }
    @JsonProperty("message")
    public void setMessage(String message) {
      this.message = message;
    }
    @JsonProperty("level")
    public void setLevel(FormValidationError.Level level) {
      this.level = level;
    }
    @JsonProperty("type")
    public void setType(FormValidationError.Type type) {
      this.type = type;
    }
    @JsonProperty("expression")
    public void setExpression(Optional<String> expression) {
      this.expression = expression;
    }
    @JsonProperty("startIndex")
    public void setStartIndex(Optional<Integer> startIndex) {
      this.startIndex = startIndex;
    }
    @JsonProperty("endIndex")
    public void setEndIndex(Optional<Integer> endIndex) {
      this.endIndex = endIndex;
    }
    @JsonProperty("index")
    public void setIndex(Optional<Integer> index) {
      this.index = index;
    }
    @Override
    public String getItemId() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public FormValidationError.Level getLevel() { throw new UnsupportedOperationException(); }
    @Override
    public FormValidationError.Type getType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getExpression() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getStartIndex() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getEndIndex() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getIndex() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormValidationError fromJson(Json json) {
    ImmutableFormValidationError.Builder builder = ImmutableFormValidationError.builder();
    if (json.itemId != null) {
      builder.itemId(json.itemId);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.level != null) {
      builder.level(json.level);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.expression != null) {
      builder.expression(json.expression);
    }
    if (json.startIndex != null) {
      builder.startIndex(json.startIndex);
    }
    if (json.endIndex != null) {
      builder.endIndex(json.endIndex);
    }
    if (json.index != null) {
      builder.index(json.index);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FormValidationError} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormValidationError instance
   */
  public static ImmutableFormValidationError copyOf(FormValidationError instance) {
    if (instance instanceof ImmutableFormValidationError) {
      return (ImmutableFormValidationError) instance;
    }
    return ImmutableFormValidationError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormValidationError ImmutableFormValidationError}.
   * <pre>
   * ImmutableFormValidationError.builder()
   *    .itemId(String | null) // nullable {@link FormValidationError#getItemId() itemId}
   *    .message(String | null) // nullable {@link FormValidationError#getMessage() message}
   *    .level(io.dialob.api.form.FormValidationError.Level) // optional {@link FormValidationError#getLevel() level}
   *    .type(io.dialob.api.form.FormValidationError.Type | null) // nullable {@link FormValidationError#getType() type}
   *    .expression(String) // optional {@link FormValidationError#getExpression() expression}
   *    .startIndex(Integer) // optional {@link FormValidationError#getStartIndex() startIndex}
   *    .endIndex(Integer) // optional {@link FormValidationError#getEndIndex() endIndex}
   *    .index(Integer) // optional {@link FormValidationError#getIndex() index}
   *    .build();
   * </pre>
   * @return A new ImmutableFormValidationError builder
   */
  public static ImmutableFormValidationError.Builder builder() {
    return new ImmutableFormValidationError.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormValidationError ImmutableFormValidationError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormValidationError", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String itemId;
    private @Nullable String message;
    private @Nullable FormValidationError.Level level;
    private @Nullable FormValidationError.Type type;
    private @Nullable String expression;
    private @Nullable Integer startIndex;
    private @Nullable Integer endIndex;
    private @Nullable Integer index;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FormValidationError} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormValidationError instance) {
      Objects.requireNonNull(instance, "instance");
      String itemIdValue = instance.getItemId();
      if (itemIdValue != null) {
        itemId(itemIdValue);
      }
      String messageValue = instance.getMessage();
      if (messageValue != null) {
        message(messageValue);
      }
      level(instance.getLevel());
      FormValidationError.Type typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      Optional<String> expressionOptional = instance.getExpression();
      if (expressionOptional.isPresent()) {
        expression(expressionOptional);
      }
      Optional<Integer> startIndexOptional = instance.getStartIndex();
      if (startIndexOptional.isPresent()) {
        startIndex(startIndexOptional);
      }
      Optional<Integer> endIndexOptional = instance.getEndIndex();
      if (endIndexOptional.isPresent()) {
        endIndex(endIndexOptional);
      }
      Optional<Integer> indexOptional = instance.getIndex();
      if (indexOptional.isPresent()) {
        index(indexOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FormValidationError#getItemId() itemId} attribute.
     * @param itemId The value for itemId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("itemId")
    public final Builder itemId(String itemId) {
      this.itemId = itemId;
      return this;
    }

    /**
     * Initializes the value for the {@link FormValidationError#getMessage() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final Builder message(String message) {
      this.message = message;
      return this;
    }

    /**
     * Initializes the value for the {@link FormValidationError#getLevel() level} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FormValidationError#getLevel() level}.</em>
     * @param level The value for level 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("level")
    public final Builder level(FormValidationError.Level level) {
      this.level = Objects.requireNonNull(level, "level");
      return this;
    }

    /**
     * Initializes the value for the {@link FormValidationError#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(FormValidationError.Type type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the optional value {@link FormValidationError#getExpression() expression} to expression.
     * @param expression The value for expression
     * @return {@code this} builder for chained invocation
     */
    public final Builder expression(String expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      return this;
    }

    /**
     * Initializes the optional value {@link FormValidationError#getExpression() expression} to expression.
     * @param expression The value for expression
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("expression")
    public final Builder expression(Optional<String> expression) {
      this.expression = expression.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FormValidationError#getStartIndex() startIndex} to startIndex.
     * @param startIndex The value for startIndex
     * @return {@code this} builder for chained invocation
     */
    public final Builder startIndex(int startIndex) {
      this.startIndex = startIndex;
      return this;
    }

    /**
     * Initializes the optional value {@link FormValidationError#getStartIndex() startIndex} to startIndex.
     * @param startIndex The value for startIndex
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("startIndex")
    public final Builder startIndex(Optional<Integer> startIndex) {
      this.startIndex = startIndex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FormValidationError#getEndIndex() endIndex} to endIndex.
     * @param endIndex The value for endIndex
     * @return {@code this} builder for chained invocation
     */
    public final Builder endIndex(int endIndex) {
      this.endIndex = endIndex;
      return this;
    }

    /**
     * Initializes the optional value {@link FormValidationError#getEndIndex() endIndex} to endIndex.
     * @param endIndex The value for endIndex
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("endIndex")
    public final Builder endIndex(Optional<Integer> endIndex) {
      this.endIndex = endIndex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FormValidationError#getIndex() index} to index.
     * @param index The value for index
     * @return {@code this} builder for chained invocation
     */
    public final Builder index(int index) {
      this.index = index;
      return this;
    }

    /**
     * Initializes the optional value {@link FormValidationError#getIndex() index} to index.
     * @param index The value for index
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("index")
    public final Builder index(Optional<Integer> index) {
      this.index = index.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormValidationError ImmutableFormValidationError}.
     * @return An immutable instance of FormValidationError
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormValidationError build() {
      return new ImmutableFormValidationError(this);
    }
  }
}
