package io.dialob.api.form;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code FormValidationError}.
 * @see ImmutableFormValidationError
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.form", generator = "Gsons")
public final class GsonAdaptersFormValidationError implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (FormValidationErrorTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new FormValidationErrorTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersFormValidationError(FormValidationError)";
  }

  @org.immutables.value.Generated(from = "FormValidationError", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class FormValidationErrorTypeAdapter extends TypeAdapter<FormValidationError> {
    public final FormValidationError.Level levelTypeSample = null;
    public final FormValidationError.Type typeTypeSample = null;
    public final Integer startIndexTypeSample = null;
    public final Integer endIndexTypeSample = null;
    public final Integer indexTypeSample = null;
    private final TypeAdapter<FormValidationError.Level> levelTypeAdapter;
    private final TypeAdapter<FormValidationError.Type> typeTypeAdapter;
    private final TypeAdapter<Integer> startIndexTypeAdapter;
    private final TypeAdapter<Integer> endIndexTypeAdapter;
    private final TypeAdapter<Integer> indexTypeAdapter;

    FormValidationErrorTypeAdapter(Gson gson) {
      this.levelTypeAdapter = gson.getAdapter( FormValidationError.Level.class);
      this.typeTypeAdapter = gson.getAdapter( FormValidationError.Type.class);
      this.startIndexTypeAdapter = gson.getAdapter( Integer.class);
      this.endIndexTypeAdapter = gson.getAdapter( Integer.class);
      this.indexTypeAdapter = gson.getAdapter( Integer.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return FormValidationError.class == type.getRawType()
          || ImmutableFormValidationError.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, FormValidationError value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeFormValidationError(out, value);
      }
    }

    @Override
    public FormValidationError read(JsonReader in) throws IOException {
      return readFormValidationError(in);
    }

    private void writeFormValidationError(JsonWriter out, FormValidationError instance)
        throws IOException {
      out.beginObject();
      String itemIdValue = instance.getItemId();
      if (itemIdValue != null) {
        out.name("itemId");
        out.value(itemIdValue);
      } else if (out.getSerializeNulls()) {
        out.name("itemId");
        out.nullValue();
      }
      String messageValue = instance.getMessage();
      if (messageValue != null) {
        out.name("message");
        out.value(messageValue);
      } else if (out.getSerializeNulls()) {
        out.name("message");
        out.nullValue();
      }
      out.name("level");
      levelTypeAdapter.write(out, instance.getLevel());
      FormValidationError.Type typeValue = instance.getType();
      if (typeValue != null) {
        out.name("type");
        typeTypeAdapter.write(out, typeValue);
      } else if (out.getSerializeNulls()) {
        out.name("type");
        out.nullValue();
      }
      Optional<String> expressionOptional = instance.getExpression();
      if (expressionOptional.isPresent()) {
        out.name("expression");
        String expressionValue = expressionOptional.get();
        out.value(expressionValue);
      } else if (out.getSerializeNulls()) {
        out.name("expression");
        out.nullValue();
      }
      Optional<Integer> startIndexOptional = instance.getStartIndex();
      if (startIndexOptional.isPresent()) {
        out.name("startIndex");
        Integer startIndexValue = startIndexOptional.get();
        startIndexTypeAdapter.write(out, startIndexValue);
      } else if (out.getSerializeNulls()) {
        out.name("startIndex");
        out.nullValue();
      }
      Optional<Integer> endIndexOptional = instance.getEndIndex();
      if (endIndexOptional.isPresent()) {
        out.name("endIndex");
        Integer endIndexValue = endIndexOptional.get();
        endIndexTypeAdapter.write(out, endIndexValue);
      } else if (out.getSerializeNulls()) {
        out.name("endIndex");
        out.nullValue();
      }
      Optional<Integer> indexOptional = instance.getIndex();
      if (indexOptional.isPresent()) {
        out.name("index");
        Integer indexValue = indexOptional.get();
        indexTypeAdapter.write(out, indexValue);
      } else if (out.getSerializeNulls()) {
        out.name("index");
        out.nullValue();
      }
      out.endObject();
    }

    private  FormValidationError readFormValidationError(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableFormValidationError.Builder builder = ImmutableFormValidationError.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableFormValidationError.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("itemId".equals(attributeName)) {
          readInItemId(in, builder);
          return;
        }
        if ("index".equals(attributeName)) {
          readInIndex(in, builder);
          return;
        }
        break;
      case 'm':
        if ("message".equals(attributeName)) {
          readInMessage(in, builder);
          return;
        }
        break;
      case 'l':
        if ("level".equals(attributeName)) {
          readInLevel(in, builder);
          return;
        }
        break;
      case 't':
        if ("type".equals(attributeName)) {
          readInType(in, builder);
          return;
        }
        break;
      case 'e':
        if ("expression".equals(attributeName)) {
          readInExpression(in, builder);
          return;
        }
        if ("endIndex".equals(attributeName)) {
          readInEndIndex(in, builder);
          return;
        }
        break;
      case 's':
        if ("startIndex".equals(attributeName)) {
          readInStartIndex(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInItemId(JsonReader in, ImmutableFormValidationError.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.itemId(in.nextString());
      }
    }

    private void readInMessage(JsonReader in, ImmutableFormValidationError.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.message(in.nextString());
      }
    }

    private void readInLevel(JsonReader in, ImmutableFormValidationError.Builder builder)
        throws IOException {
      FormValidationError.Level value = levelTypeAdapter.read(in);
      builder.level(value);
    }

    private void readInType(JsonReader in, ImmutableFormValidationError.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        FormValidationError.Type value = typeTypeAdapter.read(in);
        builder.type(value);
      }
    }

    private void readInExpression(JsonReader in, ImmutableFormValidationError.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.expression(in.nextString());
      }
    }

    private void readInStartIndex(JsonReader in, ImmutableFormValidationError.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Integer value = startIndexTypeAdapter.read(in);
        builder.startIndex(value);
      }
    }

    private void readInEndIndex(JsonReader in, ImmutableFormValidationError.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Integer value = endIndexTypeAdapter.read(in);
        builder.endIndex(value);
      }
    }

    private void readInIndex(JsonReader in, ImmutableFormValidationError.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Integer value = indexTypeAdapter.read(in);
        builder.index(value);
      }
    }
  }
}
