package io.dialob.api.form;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code FormPutResponse}.
 * @see ImmutableFormPutResponse
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.form", generator = "Gsons")
public final class GsonAdaptersFormPutResponse implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (FormPutResponseTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new FormPutResponseTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersFormPutResponse(FormPutResponse)";
  }

  @org.immutables.value.Generated(from = "FormPutResponse", generator = "Gsons")
  @SuppressWarnings({"unchecked", "raw"}) // safe unchecked, types are verified in runtime
  private static class FormPutResponseTypeAdapter extends TypeAdapter<FormPutResponse> {
    public final Boolean okTypeSample = null;
    public final FormValidationError errorsTypeSample = null;
    public final Form formTypeSample = null;
    private final TypeAdapter<Boolean> okTypeAdapter;
    private final TypeAdapter<FormValidationError> errorsTypeAdapter;
    private final TypeAdapter<Form> formTypeAdapter;

    FormPutResponseTypeAdapter(Gson gson) {
      this.okTypeAdapter = gson.getAdapter( Boolean.class);
      this.errorsTypeAdapter = gson.getAdapter( FormValidationError.class);
      this.formTypeAdapter = gson.getAdapter( Form.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return FormPutResponse.class == type.getRawType()
          || ImmutableFormPutResponse.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, FormPutResponse value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeFormPutResponse(out, value);
      }
    }

    @Override
    public FormPutResponse read(JsonReader in) throws IOException {
      return readFormPutResponse(in);
    }

    private void writeFormPutResponse(JsonWriter out, FormPutResponse instance)
        throws IOException {
      out.beginObject();
      Boolean okValue = instance.getOk();
      if (okValue != null) {
        out.name("ok");
        okTypeAdapter.write(out, okValue);
      } else if (out.getSerializeNulls()) {
        out.name("ok");
        out.nullValue();
      }
      String errorValue = instance.getError();
      if (errorValue != null) {
        out.name("error");
        out.value(errorValue);
      } else if (out.getSerializeNulls()) {
        out.name("error");
        out.nullValue();
      }
      String reasonValue = instance.getReason();
      if (reasonValue != null) {
        out.name("reason");
        out.value(reasonValue);
      } else if (out.getSerializeNulls()) {
        out.name("reason");
        out.nullValue();
      }
      String idValue = instance.getId();
      if (idValue != null) {
        out.name("id");
        out.value(idValue);
      } else if (out.getSerializeNulls()) {
        out.name("id");
        out.nullValue();
      }
      String revValue = instance.getRev();
      if (revValue != null) {
        out.name("rev");
        out.value(revValue);
      } else if (out.getSerializeNulls()) {
        out.name("rev");
        out.nullValue();
      }
      List<FormValidationError> errorsElements = instance.getErrors();
      out.name("errors");
      out.beginArray();
      for (FormValidationError e : errorsElements) {
        errorsTypeAdapter.write(out, e);
      }
      out.endArray();
      Form formValue = instance.getForm();
      if (formValue != null) {
        out.name("form");
        formTypeAdapter.write(out, formValue);
      } else if (out.getSerializeNulls()) {
        out.name("form");
        out.nullValue();
      }
      out.endObject();
    }

    private  FormPutResponse readFormPutResponse(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableFormPutResponse.Builder builder = ImmutableFormPutResponse.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableFormPutResponse.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'o':
        if ("ok".equals(attributeName)) {
          readInOk(in, builder);
          return;
        }
        break;
      case 'e':
        if ("error".equals(attributeName)) {
          readInError(in, builder);
          return;
        }
        if ("errors".equals(attributeName)) {
          readInErrors(in, builder);
          return;
        }
        break;
      case 'r':
        if ("reason".equals(attributeName)) {
          readInReason(in, builder);
          return;
        }
        if ("rev".equals(attributeName)) {
          readInRev(in, builder);
          return;
        }
        break;
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'f':
        if ("form".equals(attributeName)) {
          readInForm(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInOk(JsonReader in, ImmutableFormPutResponse.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = okTypeAdapter.read(in);
        builder.ok(value);
      }
    }

    private void readInError(JsonReader in, ImmutableFormPutResponse.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.error(in.nextString());
      }
    }

    private void readInReason(JsonReader in, ImmutableFormPutResponse.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.reason(in.nextString());
      }
    }

    private void readInId(JsonReader in, ImmutableFormPutResponse.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.id(in.nextString());
      }
    }

    private void readInRev(JsonReader in, ImmutableFormPutResponse.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.rev(in.nextString());
      }
    }

    private void readInErrors(JsonReader in, ImmutableFormPutResponse.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          FormValidationError value = errorsTypeAdapter.read(in);
          builder.addErrors(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        FormValidationError value = errorsTypeAdapter.read(in);
        builder.addErrors(value);
      }
    }

    private void readInForm(JsonReader in, ImmutableFormPutResponse.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Form value = formTypeAdapter.read(in);
        builder.form(value);
      }
    }
  }
}
